/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

public class CMSProcessableInputStreamImpl
implements CMSProcessable {
    private static final int BUFFER_SIZE = 30720;
    private InputStream input;
    private long startIndex;
    private long endIndex;
    private boolean used = false;

    public CMSProcessableInputStreamImpl(InputStream input, long startIndex, long endIndex) {
        this.input = input;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    private long pipeLimitedOffset(InputStream inStr, long startIndex, long endIndex, OutputStream outStr) throws IOException, CMSException {
        long maxEndIndex;
        long length = inStr.available();
        long l = maxEndIndex = length == 0L ? 0L : length - 1L;
        if (startIndex > endIndex || startIndex < 0L || endIndex > maxEndIndex) {
            throw new CMSException("index of input stream invalid, pls check startIndex and endIndex");
        }
        long total = 0L;
        byte[] bs = new byte[30720];
        long limit = endIndex - startIndex + 1L;
        int numRead = 0;
        long skipLen = inStr.skip(startIndex);
        if (skipLen != startIndex) {
            throw new CMSException("src input stream skip startIndex length error");
        }
        while (limit - total > (long)bs.length) {
            numRead = inStr.read(bs, 0, bs.length);
            if (numRead == -1) {
                return total;
            }
            total += (long)numRead;
            outStr.write(bs, 0, numRead);
        }
        numRead = inStr.read(bs, 0, (int)(limit - total));
        if (numRead == -1) {
            return total;
        }
        outStr.write(bs, 0, numRead);
        return total += (long)numRead;
    }

    public void write(OutputStream out) throws IOException, CMSException {
        this.checkSingleUsage();
        long len = this.pipeLimitedOffset(this.input, this.startIndex, this.endIndex, out);
        if (len != this.endIndex - this.startIndex + 1L) {
            throw new IOException("CMSProcessableInputStreamImpl error, len = " + len);
        }
    }

    public Object getContent() {
        this.checkSingleUsage();
        return this.input;
    }

    private synchronized void checkSingleUsage() {
        if (this.used) {
            throw new IllegalStateException("CMSProcessableInputStreamImpl can only be used once");
        }
        this.used = true;
    }
}

