/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.utils;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;

public class CertificateChainSorter {
    public static X509Certificate[] sortCertificateChain(X509Certificate[] certificateChain) {
        return (X509Certificate[])Arrays.stream(certificateChain).sorted(new CertSortComparator()).toArray(X509Certificate[]::new);
    }

    private CertificateChainSorter() {
    }

    private static class CertSortComparator
    implements Comparator<X509Certificate> {
        private CertSortComparator() {
        }

        @Override
        public int compare(X509Certificate cert1, X509Certificate cert2) {
            if (cert1.getSubjectDN().equals(cert2.getIssuerDN()) || cert1.getSubjectDN().equals(cert1.getIssuerDN())) {
                return -1;
            }
            if (cert1.getIssuerDN().equals(cert2.getSubjectDN()) || cert2.getIssuerDN().equals(cert2.getSubjectDN())) {
                return 1;
            }
            return 0;
        }
    }
}

