/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskWithNode;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.TempProtocols;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.entity.CollectScene;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ComputeNodeParam;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.InfocollectUserOpData;
import com.huawei.ism.tool.infocollect.interf.IGetPackagesPath;
import com.huawei.ism.tool.infocollect.interf.IResultHandler;
import com.huawei.ism.tool.infocollect.interf.IUICallBack;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskBase;
import com.huawei.ism.tool.infocollect.util.FileFilterParser;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JDialog;
import org.slf4j.Logger;
import utils.FilesUtil;

public final class CollectDataContext
extends AbstractContext {
    public static final AtomicInteger BACK_COUNT = new AtomicInteger(0);
    public static final String T3000_RENAME_STR = "Red Hat,SUSE";
    public static final String T3000_NAME_PRE = "T3000-";
    public static final String SPLIT_BYTIME = "bytime";
    public static final String PYFRAMEPATH = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", "collect", "products", "pyframe");
    public static final String COLLECTMAPPATH = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "configuration", "collectItemMap.xml");
    public static final String FILE_CODE_7Z = "377abcaf271c";
    public static final String VERSION_KEY = "toolkit.app.zh.version";
    public static final int NUM_100 = 100;
    public static final int INIT_SINGLE_DEV_PROGRESS = 5;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CollectDataContext.class);
    private static final CollectDataContext INSTANCE = new CollectDataContext();
    private static final String SCENE_NAME = "jsonScene";
    private static final String SCENE_RESULT_PATH = "jsonSceneResultPath";
    private static final String SCENE_TOOL_ID = "collect";
    private static final String ENTRY_DIR = "entry";
    private static final String STORAGE_FIELD = "Storage";
    private static final String TROUBLESHOOTING_MAIN_SCENE = "Troubleshooting";
    private static final String STORAGE_COLLECT_SUB_SCENE = "Storage Collect";
    private static final Object SILENT_RESULT_MAP_LOCK = new Object();
    private static final int MAX_INSPECT_NUM = 10;
    private static final Object COLLECT_INFO_ES_LOCK = new Object();
    private static final int COMPRESS_TOTAL_PROGRESS = 5;
    private static String silentResultDir = "CollectResult";
    private Map<String, AiDevNode> aiDevNodeMap = new HashMap<String, AiDevNode>();
    private Map<String, DpcCollectNode> collectNodeMap = new HashMap<String, DpcCollectNode>();
    private Map<DevNode, String> t3000ShowName = new HashMap<DevNode, String>();
    private boolean hostInfoCollectPermissionGranted = false;
    private IResultHandler retHandler = null;
    private List<InfocollectUserOpData> userOpList = new ArrayList<InfocollectUserOpData>();
    private TempProtocols tempProtocols = new TempProtocols();
    private boolean foreground = false;
    private boolean foolkitZhCn = false;
    private Map<DevNode, ICollectInfo> collectInfoes = new HashMap<DevNode, ICollectInfo>();
    private boolean startCollect = true;
    private String mode = "";
    private boolean running = false;
    private final List<DevNode> waitingOldDevs = new LinkedList<DevNode>();
    private IUICallBack iuiCallBack = null;
    private IGetPackagesPath igetPackagesPath = null;
    private boolean foreProcessRunning = false;
    private ConcurrentHashMap<DevNode, Integer> silentProgressMap = new ConcurrentHashMap();
    private String silenceWorkPath = "";
    private ConcurrentHashMap<DevNode, SilentProcessData> silentResultMap = new ConcurrentHashMap();
    private Queue<TaskBase> taskQueue = new LinkedList<TaskBase>();
    private List<File> silentFileToCompress = new LinkedList<File>();
    private int totalSilentProgress = 0;
    private long silentStartTime = 0L;
    private int splitTaskPercent = 0;
    private boolean isLastStep = false;
    private boolean background = false;
    private boolean hasOneTaskFailed = false;
    private boolean useApply = false;
    private boolean logSplit = false;
    private boolean openHelpFile = false;
    private boolean backProcessRunning = false;
    private List<File> silentFileToDel = new LinkedList<File>();
    private ExecutorService taskExecutor;
    private ExecutorService cachedThredPool = Executors.newCachedThreadPool();
    private ConcurrentHashMap<DevNode, Future<TreeMap<DiskLocation, Disk>>> globalQryDiskFutureMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, TreeMap<DiskLocation, Disk>> globalConDiskHashMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, Map<DiskLocation, CollectStatus>> lastDiskLogResultMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DevNode, Integer> diskTotalNumMap = new ConcurrentHashMap();
    private Map<String, String> upgTgtVersionMap = new HashMap<String, String>();
    private Map<String, Map<String, String>> upgExtendMap = new HashMap<String, Map<String, String>>();
    private Map<DevNode, CollectScene> devNodeCollectSceneMap = new HashMap<DevNode, CollectScene>();
    private Set<DevNode> hasImportPatchDevs = new HashSet<DevNode>();
    private boolean someCmdNeedRemove = false;
    private Map<DevNode, Map<String, ComputeNodeParam>> devComputeNodesInfo = new HashMap<DevNode, Map<String, ComputeNodeParam>>();
    private Map<DevNode, List<String>> devComputeNodesGroupsInfo = new HashMap<DevNode, List<String>>();
    private List<DevNode> initCollectInfoComputeStorageDev = new ArrayList<DevNode>();
    private Map<DevNode, Boolean> devLicenseQueryResultCacheMap = new HashMap<DevNode, Boolean>();
    private Map<DevNode, Boolean> devStartupScenarioMap = new HashMap<DevNode, Boolean>();
    private JDialog infoCollectMainDialog;
    private Map<DevNode, String> devCollectCliTypeMap = new HashMap<DevNode, String>();
    private int threadPoolNumbers = 8;
    private ConcurrentHashMap<DevNode, List<DiskWithNode>> globalConDiskHashMapForDiskWithNode = new ConcurrentHashMap();
    private int dataTurboNodeNumber = 0;

    private CollectDataContext() {
        this.taskExecutor = ThreadPoolHelper.getFixedNumThreadPool((int)10, (String)"task_thread_pool");
    }

    private static String getPyframePathInCollect() {
        return String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", SCENE_TOOL_ID, "products", "pyframe");
    }

    public static CollectDataContext getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSilentResult(DevNode node, SilentProcessData data) {
        if (!this.isBackground()) {
            return;
        }
        Object object = SILENT_RESULT_MAP_LOCK;
        synchronized (object) {
            data.setUsedTime(String.valueOf(System.currentTimeMillis() - this.silentStartTime));
            if ("failed".equalsIgnoreCase(data.getResult())) {
                this.setHasOneTaskFailed(true);
            }
            this.silentResultMap.put(node, data);
            data.setPassRate(this.silentProgressMap.get(node).intValue());
            data.setProcess(String.valueOf(this.silentProgressMap.get(node)));
            LOGGER.info("update silent data: {}", (Object)data);
            SilentProcessToFile.updateDeviceData((SilentProcessData)data, (String)this.silenceWorkPath);
            int totalPro = 0;
            for (Integer pro : this.silentProgressMap.values()) {
                totalPro += pro.intValue();
            }
            int totalProWithoutCompress = this.totalSilentProgress - 5;
            totalPro = (totalPro = totalPro * totalProWithoutCompress / 100 / this.silentProgressMap.size()) <= 0 || totalPro > totalProWithoutCompress ? totalProWithoutCompress : totalPro;
            SilentProcessData totalData = new SilentProcessData();
            totalData.setProcess(String.valueOf(totalPro));
            totalData.setStatus("running");
            totalData.setResult(this.hasOneTaskFailed ? "failed" : "");
            LOGGER.info("update total silent data: {}", (Object)totalData);
            SilentProcessToFile.updateProcessData((SilentProcessData)totalData, (String)this.silenceWorkPath);
        }
    }

    public static String getSilentResultDir() {
        return silentResultDir;
    }

    public static void setSilentResultDir(String silentResultDir) {
        CollectDataContext.silentResultDir = silentResultDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSilentFileToDel(File file) {
        if (null == file) {
            return;
        }
        List<File> list = this.silentFileToDel;
        synchronized (list) {
            this.silentFileToDel.add(file);
        }
        LOGGER.info("add file to delete: {}", (Object)FilesUtil.getCanonicalPath((File)file));
    }

    public void delSilentFileExiting() {
        if (!this.isLastStep()) {
            return;
        }
        for (File file : this.silentFileToDel) {
            FileUtils.deleteFile((File)file);
        }
    }

    public void updateSilentResultExiting(boolean hasException) {
        if (!this.isBackground()) {
            return;
        }
        for (SilentProcessData data : this.silentResultMap.values()) {
            data.setPassRate(this.totalSilentProgress);
            data.setProcess(String.valueOf(this.totalSilentProgress));
            data.setResult(hasException ? "failed" : (this.isLastStep ? (data.getResult().isEmpty() ? "success" : data.getResult()) : "failed"));
            data.setStatus("finished");
            data.setUsedTime(String.valueOf(System.currentTimeMillis() - this.silentStartTime));
            LOGGER.info("update silent result exiting: {}", (Object)data);
            SilentProcessToFile.updateDeviceData((SilentProcessData)data, (String)this.silenceWorkPath);
        }
        SilentProcessData totalData = new SilentProcessData();
        totalData.setProcess(String.valueOf(this.totalSilentProgress));
        totalData.setStatus(hasException ? "finished" : (this.isLastStep ? "finished" : "running"));
        totalData.setResult(hasException ? "failed" : (this.hasOneTaskFailed ? "failed" : (this.isLastStep ? "success" : "")));
        LOGGER.info("update total silent result exiting: {}", (Object)totalData);
        SilentProcessToFile.updateProcessData((SilentProcessData)totalData, (String)this.silenceWorkPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSilentDevCollectSuccess(DevNode node) {
        Object object = SILENT_RESULT_MAP_LOCK;
        synchronized (object) {
            SilentProcessData data = this.silentResultMap.get(node);
            return null != data && null != data.getResult() && !"failed".equals(data.getResult());
        }
    }

    public int calcProgressCollecting(int curr, int total) {
        int collectPercent = 100 - this.splitTaskPercent - 5;
        return curr < 0 || total <= 0 || total < curr ? collectPercent : collectPercent * curr / total;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(ExecutorService taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isForeProcessRunning() {
        return this.foreProcessRunning;
    }

    public void setForeProcessRunning(boolean foreProcessRunning) {
        this.foreProcessRunning = foreProcessRunning;
    }

    public boolean isBackProcessRunning() {
        return this.backProcessRunning;
    }

    public void setBackProcessRunning(boolean backProcessRunning) {
        this.backProcessRunning = backProcessRunning;
    }

    public Queue<TaskBase> getTaskQueue() {
        return this.taskQueue;
    }

    public void setTaskQueue(Queue<TaskBase> taskQueue) {
        this.taskQueue = taskQueue;
    }

    public boolean isCollecting() {
        return !this.getCollectingDevNodes().isEmpty();
    }

    public List<InfocollectUserOpData> getUserOpList() {
        return this.userOpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevNode getContainDevNodebyIP(String ip) {
        Object object = COLLECT_INFO_ES_LOCK;
        synchronized (object) {
            Set<DevNode> devNodes = this.collectInfoes.keySet();
            for (DevNode current : devNodes) {
                if (!current.getIp().equals(ip)) continue;
                return current;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollecting(DevNode devNode) {
        Object object = COLLECT_INFO_ES_LOCK;
        synchronized (object) {
            Collection<ICollectInfo> collectInfoses = this.collectInfoes.values();
            for (ICollectInfo collectInfo : collectInfoses) {
                if (collectInfo == null || !collectInfo.isCollecting(devNode)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.startCollect = false;
        Object object = COLLECT_INFO_ES_LOCK;
        synchronized (object) {
            this.collectInfoes.clear();
        }
        LOGGER.info("clear collectInfoes");
        this.waitingOldDevs.clear();
    }

    public void setUserOpList(List<InfocollectUserOpData> userOpList) {
        this.userOpList = userOpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCollectInfo(DevNode node, ICollectInfo collectInfo) {
        Object object = COLLECT_INFO_ES_LOCK;
        synchronized (object) {
            this.collectInfoes.put(node, collectInfo);
        }
    }

    public List<DevNode> getCollectingDevNodes() {
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        Collection<ICollectInfo> collectInfoses = this.getCollectInfoes();
        for (ICollectInfo collectInfo : collectInfoses) {
            if (collectInfo == null || !collectInfo.isCollecting()) continue;
            devNodes.add(collectInfo.getDevNode());
        }
        return devNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICollectInfo getCollectInfo(DevNode devNode) {
        ICollectInfo result;
        Object object = COLLECT_INFO_ES_LOCK;
        synchronized (object) {
            result = this.collectInfoes.get(devNode);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ICollectInfo> getCollectInfoes() {
        Object object = COLLECT_INFO_ES_LOCK;
        synchronized (object) {
            return this.collectInfoes.values();
        }
    }

    public List<DevNode> getWaitingOldDevs() {
        return this.waitingOldDevs;
    }

    public TempProtocols getTempProtocols() {
        return this.tempProtocols;
    }

    public IResultHandler getRetHandler() {
        return this.retHandler;
    }

    public void setRetHandler(IResultHandler retHandler) {
        this.retHandler = retHandler;
    }

    public IUICallBack getIuiCallBack() {
        if (null == this.iuiCallBack) {
            return CollectUIContext.getInstance();
        }
        return this.iuiCallBack;
    }

    public void setIuiCallBack(IUICallBack iuiCallBack) {
        this.iuiCallBack = iuiCallBack;
    }

    public boolean isStartCollect() {
        return this.startCollect;
    }

    public IGetPackagesPath getIgetPackagesPath() {
        if (null == this.igetPackagesPath) {
            return InfoConfiguration.getInstance();
        }
        return this.igetPackagesPath;
    }

    public boolean isToolkitEnv() {
        String toolBase = ApplicationContext.getInstance().getWorkPath();
        File toolBaseFile = new File(toolBase);
        File[] files = toolBaseFile.listFiles(new FileFilterParser());
        if (null == files) {
            return true;
        }
        for (File file : files) {
            if (!ENTRY_DIR.equals(file.getName())) continue;
            return false;
        }
        return true;
    }

    public void setIgetPackagesPath(IGetPackagesPath igetPackagesPath) {
        this.igetPackagesPath = igetPackagesPath;
    }

    public void setStartCollect(boolean startCollect) {
        this.startCollect = startCollect;
    }

    public boolean isScene() {
        return SceneUtils.isScene();
    }

    public String getSceneCollectDir() {
        ScenePathValue scenePathValue = null;
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            scenePathValue = (ScenePathValue)environment.getEnvirValueByKey(SCENE_RESULT_PATH);
        }
        catch (ToolException e) {
            LOGGER.error("can't get scene path value");
            return "";
        }
        if (null == scenePathValue) {
            return "";
        }
        return scenePathValue.getJsonSceneResultPathValue();
    }

    public void finishedSceneTask(List<Map<String, String>> callBackMap) {
        TaskResult result = null;
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            result = environment.finishedSceneTask(callBackMap);
            if (null == result) {
                throw new NullPointerException();
            }
        }
        catch (ToolException e) {
            LOGGER.error("write roll back data failed");
        }
        if (null == result || null == result.getResult()) {
            LOGGER.info("scene call back faild!");
            return;
        }
        if (!result.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
            LOGGER.info("scene call back faild!");
        }
    }

    public boolean sceneSelectDevNode(String sn) {
        String sceneStatus;
        String jsonStr = "{'toolId':'collect','SN':'" + sn + "'}";
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            sceneStatus = environment.getDataVarByKey(jsonStr);
        }
        catch (ToolException e) {
            LOGGER.error("get scene select device node failed");
            return false;
        }
        if (StringUtils.isNULLStr((String)sceneStatus) || sceneStatus.equals(TaskResult.Result.SUCCESS.toString())) {
            LOGGER.info("devNode's scene is {}", (Object)sceneStatus);
            return false;
        }
        return true;
    }

    public void addT3000ShownName(DevNode devNode, String name) {
        this.t3000ShowName.put(devNode, name);
    }

    public boolean isStorageCollectSec() {
        return this.isSceneSupport(STORAGE_FIELD, TROUBLESHOOTING_MAIN_SCENE, STORAGE_COLLECT_SUB_SCENE);
    }

    public boolean isSceneSupport(String field, String mainScene, String subScene) {
        SceneValue sceneValue;
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            sceneValue = (SceneValue)environment.getEnvirValueByKey(SCENE_NAME);
        }
        catch (ToolException e) {
            LOGGER.error("cant't get scene value");
            return false;
        }
        if (sceneValue == null) {
            LOGGER.error("cant't get scene value");
            return false;
        }
        if (!(field.equals(sceneValue.getField()) && mainScene.equals(sceneValue.getMainScene()) && subScene.equals(sceneValue.getSubScene()))) {
            String scenV = sceneValue.toString();
            LOGGER.info("scene env is not support:{}", (Object)scenV);
            return false;
        }
        return true;
    }

    public String getT3000ShownName(DevNode devNode) {
        return T3000_NAME_PRE + this.t3000ShowName.get(devNode);
    }

    public Map<DevNode, String> getT3000ShowName() {
        return this.t3000ShowName;
    }

    public void putSilentProgress(DevNode node, int progress) {
        if (null == node) {
            return;
        }
        this.silentProgressMap.put(node, progress < 0 || progress > 100 ? 100 : progress);
    }

    public String getSilenceWorkPath() {
        return this.silenceWorkPath;
    }

    public void setSilenceWorkPath(String silenceWorkPath) {
        this.silenceWorkPath = silenceWorkPath;
    }

    public int getTotalSilentProgress() {
        return this.totalSilentProgress;
    }

    public void setTotalSilentProgress(int totalSilentProgress) {
        this.totalSilentProgress = totalSilentProgress;
        LOGGER.info("set total silent progress: {}", (Object)totalSilentProgress);
    }

    public int getSplitTaskPercent() {
        return this.splitTaskPercent;
    }

    public void setSilentStartTime(long silentStartTime) {
        this.silentStartTime = silentStartTime;
    }

    public ConcurrentHashMap<DevNode, SilentProcessData> getSilentResultMap() {
        return this.silentResultMap;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public boolean isLastStep() {
        return this.isLastStep;
    }

    public void isLastStep(boolean lastStep) {
        this.isLastStep = lastStep;
    }

    public boolean isHasOneTaskFailed() {
        return this.hasOneTaskFailed;
    }

    public void setHasOneTaskFailed(boolean hasOneTaskFailed) {
        this.hasOneTaskFailed = hasOneTaskFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSilentFileToCompress(File file) {
        List<File> list = this.silentFileToCompress;
        synchronized (list) {
            this.silentFileToCompress.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSilentFileToCompress(List<File> files) {
        List<File> list = this.silentFileToCompress;
        synchronized (list) {
            this.silentFileToCompress.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String moveSilentFileToCompress() {
        File saveDir = this.preProcess();
        if (saveDir == null) {
            return null;
        }
        try {
            List<File> list = this.silentFileToCompress;
            synchronized (list) {
                for (File file : this.silentFileToCompress) {
                    if (!file.exists() || file.isDirectory()) {
                        LOGGER.info("dir: {} does not exist or is a directory, no need to move.", (Object)file.getCanonicalPath());
                        continue;
                    }
                    File parentPath = file.getParentFile();
                    if (null == parentPath) continue;
                    String parentName = parentPath.getName();
                    String name = file.getName();
                    File newParent = new File(saveDir + File.separator + parentName);
                    if (!newParent.exists() && !newParent.mkdirs()) {
                        LOGGER.error("mkdir for: " + newParent.getCanonicalPath() + " error.");
                        continue;
                    }
                    File newFile = new File(newParent, name);
                    boolean renameResult = file.renameTo(newFile);
                    LOGGER.info("move file to: {} : res:{}", (Object)newFile.getCanonicalPath(), (Object)renameResult);
                    if (renameResult) continue;
                    FileUtils.deleteFile((File)newParent);
                }
            }
            if (saveDir.listFiles() == null || saveDir.listFiles().length == 0) {
                FileUtils.deleteFile((File)saveDir);
                LOGGER.error("save dir is empty.");
                return null;
            }
            return saveDir.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("some thing is worng.", (Throwable)e);
            return null;
        }
    }

    private File preProcess() {
        if (!this.isLastStep()) {
            return null;
        }
        File saveDir = new File(this.silenceWorkPath + File.separator + CollectDataContext.getSilentResultDir());
        if (!saveDir.exists() && !saveDir.mkdirs()) {
            LOGGER.error("mkdir for collect result  error.");
            return null;
        }
        return saveDir;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
        this.splitTaskPercent = SPLIT_BYTIME.equalsIgnoreCase(mode) ? 20 : 0;
    }

    public ConcurrentHashMap<DevNode, TreeMap<DiskLocation, Disk>> getGlobalConDiskHashMap() {
        return this.globalConDiskHashMap;
    }

    public void setGlobalConDiskHashMap(ConcurrentHashMap<DevNode, TreeMap<DiskLocation, Disk>> globalConDiskHashMap) {
        this.globalConDiskHashMap = globalConDiskHashMap;
    }

    public ConcurrentHashMap<DevNode, List<DiskWithNode>> getGlobalConDiskHashMapForDiskWithNode() {
        return this.globalConDiskHashMapForDiskWithNode;
    }

    public void setGlobalConDiskHashMapForDiskWithNode(ConcurrentHashMap<DevNode, List<DiskWithNode>> globalConDiskHashMapForDiskWithNode) {
        this.globalConDiskHashMapForDiskWithNode = globalConDiskHashMapForDiskWithNode;
    }

    public List<DiskLocation> getSelectedDiskFromContext(DevNode devNode) {
        ArrayList<DiskLocation> diskLocList = new ArrayList<DiskLocation>();
        TreeMap<DiskLocation, Disk> diskMap = this.globalConDiskHashMap.get(devNode);
        if (null == diskMap || diskMap.isEmpty()) {
            return diskLocList;
        }
        Set<Map.Entry<DiskLocation, Disk>> locVsDiskEntrySet = diskMap.entrySet();
        for (Map.Entry<DiskLocation, Disk> entry : locVsDiskEntrySet) {
            if (!entry.getValue().isChecked()) continue;
            diskLocList.add(entry.getKey());
        }
        return diskLocList;
    }

    public void clearDiskWithNodeAllSelected(DevNode devNode) {
        List<DiskWithNode> nodeDisks = this.getGlobalConDiskHashMapForDiskWithNode().get(devNode);
        if (nodeDisks != null && !nodeDisks.isEmpty()) {
            for (DiskWithNode disk : nodeDisks) {
                disk.setChecked(false);
            }
        }
    }

    public List<Disk> getSelectedDiskForPython(DevNode devNode) {
        ArrayList<Disk> selDiskObjList = new ArrayList<Disk>();
        List<DiskLocation> diskLocObjList = this.getSelectedDiskFromContext(devNode);
        if (diskLocObjList.isEmpty()) {
            return selDiskObjList;
        }
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode);
        for (DiskLocation dl : diskLocObjList) {
            selDiskObjList.add(diskTreeMap.get(dl));
        }
        return selDiskObjList;
    }

    public List<DiskWithNode> getSelectedDiskWithNodeForPython(DevNode devNode) {
        ArrayList<DiskWithNode> userSelected = new ArrayList<DiskWithNode>();
        List<DiskWithNode> globalDisks = this.getGlobalConDiskHashMapForDiskWithNode().get(devNode);
        if (globalDisks != null && !globalDisks.isEmpty()) {
            for (DiskWithNode global : globalDisks) {
                if (!global.isChecked()) continue;
                userSelected.add(global);
            }
        }
        return userSelected;
    }

    public void updateGlobalCacheCheckStatus(List<DiskWithNode> selectedDisks, DevNode devNode) {
        List<DiskWithNode> nodeDisks = this.getGlobalConDiskHashMapForDiskWithNode().get(devNode);
        if (nodeDisks == null || nodeDisks.isEmpty()) {
            return;
        }
        this.clearDiskWithNodeAllSelected(devNode);
        if (selectedDisks == null || selectedDisks.isEmpty()) {
            return;
        }
        block0: for (DiskWithNode disk : nodeDisks) {
            for (DiskWithNode selectedDisk : selectedDisks) {
                if (!selectedDisk.getDiskSn().equals(disk.getDiskSn()) || !selectedDisk.getNodeId().equals(disk.getNodeId())) continue;
                disk.setChecked(true);
                continue block0;
            }
        }
    }

    public boolean isDiskWithNodeChecked(DevNode devNode) {
        List<DiskWithNode> nodeDisks = this.getGlobalConDiskHashMapForDiskWithNode().get(devNode);
        if (nodeDisks != null && !nodeDisks.isEmpty()) {
            for (DiskWithNode disk : nodeDisks) {
                if (!disk.isChecked()) continue;
                return true;
            }
        }
        return false;
    }

    public void updateDevSelectedDiskCheckStatus(DevNode deviceNode, List<DiskLocation> selectedDiskLocList) {
        if (null == selectedDiskLocList) {
            return;
        }
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(deviceNode);
        this.clearDiskCheckStatus(diskTreeMap);
        for (DiskLocation dl : selectedDiskLocList) {
            diskTreeMap.get(dl).setChecked(true);
        }
        LOGGER.info("Update disk check status in data collect context finished.");
    }

    public void clearDiskCheckStatus(TreeMap<DiskLocation, Disk> diskTreeMap) {
        if (null == diskTreeMap || diskTreeMap.isEmpty()) {
            LOGGER.info("Null or emtpy diskTreeMap.");
            return;
        }
        for (Disk dsk : diskTreeMap.values()) {
            dsk.setChecked(false);
        }
        LOGGER.info("Clear diskTreeMap check status finished.");
    }

    public boolean isDiskLastChecked(DiskWithNode disk, List<DiskWithNode> lastCheckedList) {
        if (lastCheckedList != null && !lastCheckedList.isEmpty()) {
            for (DiskWithNode lastChecked : lastCheckedList) {
                if (!disk.getNodeId().equals(lastChecked.getNodeId()) || !disk.getDiskSn().equals(lastChecked.getDiskSn())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDebugHostInfoCollect() {
        return "true".equalsIgnoreCase(System.getenv("debugHost"));
    }

    public ConcurrentHashMap<DevNode, Map<DiskLocation, CollectStatus>> getLastDiskLogResultMap() {
        return this.lastDiskLogResultMap;
    }

    public void setLastDiskLogResultMap(ConcurrentHashMap<DevNode, Map<DiskLocation, CollectStatus>> lastDiskLogResultMap) {
        this.lastDiskLogResultMap = lastDiskLogResultMap;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public void setForeground(boolean isForeground) {
        this.foreground = isForeground;
    }

    public boolean getFoolkitZhCn() {
        return this.foolkitZhCn;
    }

    public void setFoolkitZhCn(boolean isToolkit_zh_CN) {
        this.foolkitZhCn = isToolkit_zh_CN;
    }

    public ConcurrentHashMap<DevNode, Integer> getDiskTotalNumMap() {
        return this.diskTotalNumMap;
    }

    public void setDiskTotalNumMap(ConcurrentHashMap<DevNode, Integer> diskTotalNumMap) {
        this.diskTotalNumMap = diskTotalNumMap;
    }

    public ExecutorService getCachedThredPool() {
        return this.cachedThredPool;
    }

    public void setCachedThredPool(ExecutorService cachedThredPool) {
        this.cachedThredPool = cachedThredPool;
    }

    public ConcurrentHashMap<DevNode, Future<TreeMap<DiskLocation, Disk>>> getGlobalQryDiskFutureMap() {
        return this.globalQryDiskFutureMap;
    }

    public void setGlobalQryDiskFutureMap(ConcurrentHashMap<DevNode, Future<TreeMap<DiskLocation, Disk>>> globalQryDiskFutureMap) {
        this.globalQryDiskFutureMap = globalQryDiskFutureMap;
    }

    public boolean isUseApply() {
        return this.useApply;
    }

    public void setUseApply(boolean useApply) {
        this.useApply = useApply;
    }

    public boolean isLogSplit() {
        return this.logSplit;
    }

    public void setLogSplit(boolean logSplit) {
        this.logSplit = logSplit;
    }

    public boolean isOpenHelpFile() {
        return this.openHelpFile;
    }

    public void setOpenHelpFile(boolean openHelpFile) {
        this.openHelpFile = openHelpFile;
    }

    public Map<String, String> getUpgTgtVersionMap() {
        return this.upgTgtVersionMap;
    }

    public void setUpgTgtVersionMap(Map<String, String> upgTgtVersionMap) {
        this.upgTgtVersionMap = upgTgtVersionMap;
    }

    public Map<String, Map<String, String>> getUpgExtendMap() {
        return this.upgExtendMap;
    }

    public void setUpgExtendMap(Map<String, Map<String, String>> upgTgtVersionMap) {
        this.upgExtendMap = upgTgtVersionMap;
    }

    public boolean isHostInfoCollectPermissionGranted() {
        return this.hostInfoCollectPermissionGranted;
    }

    public void setHostInfoCollectPermissionGranted(boolean hostInfoCollectPermissionGranted) {
        this.hostInfoCollectPermissionGranted = hostInfoCollectPermissionGranted;
    }

    public boolean isSimpleCollectScene(DevNode devNode) {
        return this.getDevNodeCollectSceneMap().get(devNode) == CollectScene.SIMPLE_COLLECT;
    }

    public void addInitCollectInfoComputeStorageDev(DevNode devNode) {
        this.initCollectInfoComputeStorageDev.add(devNode);
    }

    public Map<String, AiDevNode> getAiDevNodeMap() {
        return this.aiDevNodeMap;
    }

    public Map<String, DpcCollectNode> getCollectNodeMap() {
        return this.collectNodeMap;
    }

    public Map<DevNode, CollectScene> getDevNodeCollectSceneMap() {
        return this.devNodeCollectSceneMap;
    }

    public Set<DevNode> getHasImportPatchDevs() {
        return this.hasImportPatchDevs;
    }

    public void setSomeCmdNeedRemove(boolean someCmdNeedRemove) {
        this.someCmdNeedRemove = someCmdNeedRemove;
    }

    public boolean isSomeCmdNeedRemove() {
        return this.someCmdNeedRemove;
    }

    public void setDevComputeNodesInfo(Map<DevNode, Map<String, ComputeNodeParam>> devComputeNodesInfo) {
        this.devComputeNodesInfo = devComputeNodesInfo;
    }

    public Map<DevNode, Map<String, ComputeNodeParam>> getDevComputeNodesInfo() {
        return this.devComputeNodesInfo;
    }

    public Map<DevNode, List<String>> getDevComputeNodesGroupsInfo() {
        return this.devComputeNodesGroupsInfo;
    }

    public void setDevComputeNodesGroupsInfo(Map<DevNode, List<String>> devComputeNodesGroupsInfo) {
        this.devComputeNodesGroupsInfo = devComputeNodesGroupsInfo;
    }

    public List<DevNode> getInitCollectInfoComputeStorageDev() {
        return this.initCollectInfoComputeStorageDev;
    }

    public Map<DevNode, Boolean> getDevLicenseQueryResultCacheMap() {
        return this.devLicenseQueryResultCacheMap;
    }

    public void setDevLicenseQueryResultCacheMap(Map<DevNode, Boolean> devLicenseQueryResultCacheMap) {
        this.devLicenseQueryResultCacheMap = devLicenseQueryResultCacheMap;
    }

    public Map<DevNode, Boolean> getDevStartupScenarioMap() {
        return this.devStartupScenarioMap;
    }

    public void setDevStartupScenarioMap(Map<DevNode, Boolean> devStartupScenarioMap) {
        this.devStartupScenarioMap = devStartupScenarioMap;
    }

    public JDialog getInfoCollectMainDialog() {
        return this.infoCollectMainDialog;
    }

    public void setInfoCollectMainDialog(JDialog infoCollectMainDialog) {
        this.infoCollectMainDialog = infoCollectMainDialog;
    }

    public Map<DevNode, String> getDevCollectCliTypeMap() {
        return this.devCollectCliTypeMap;
    }

    public void setDevCollectCliTypeMap(Map<DevNode, String> devCollectCliTypeMap) {
        this.devCollectCliTypeMap = devCollectCliTypeMap;
    }

    public int getThreadPoolNumbers() {
        return this.threadPoolNumbers;
    }

    public void setThreadPoolNumbers(int threadPoolNumbers) {
        this.threadPoolNumbers = threadPoolNumbers;
    }

    public int getDataTurboNodeNumber() {
        return this.dataTurboNodeNumber;
    }

    public void setDataTurboNodeNumber(int dataTurboNodeNumber) {
        this.dataTurboNodeNumber = dataTurboNodeNumber;
    }
}

