/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect;

import com.huawei.ism.tool.infocollect.interf.IUICallBack;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.image.ImageObserver;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectUIContext
implements IUICallBack {
    public static final ImageIcon SUCCESS_IMAGE = ResourceUtil.getImage((String)"success.png");
    public static final ImageIcon PARTIAL_SUCCESS_IMAGE = ResourceUtil.getImage((String)"partialsuccess.png");
    public static final ImageIcon FAILED_IMAGE = ResourceUtil.getImage((String)"failed.png");
    public static final ImageIcon UNSUPPORT_IMAGE = ResourceUtil.getImage((String)"nosupport.png");
    public static final ImageIcon PROCESSING_IMAGE = ResourceUtil.getImage((String)"loading.gif");
    private static final CollectUIContext INSTANCE = new CollectUIContext();
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectUIContext.class);
    private static final Object OBJ = new Object();
    private InfoCollectMainDialog mainDialog = null;

    private CollectUIContext() {
    }

    public static CollectUIContext getInstance() {
        return INSTANCE;
    }

    public void clear() {
        this.mainDialog.dispose();
        this.mainDialog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uiCallBack(DevNode devNode) {
        Object object = OBJ;
        synchronized (object) {
            if (this.mainDialog != null) {
                this.mainDialog.collectCallback(devNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeProgress(DevNode devNode, int progress) {
        Object object = OBJ;
        synchronized (object) {
            if (Objects.nonNull(this.mainDialog)) {
                this.mainDialog.updateProgress(devNode, progress);
            }
        }
    }

    public void integrateCallBack(boolean result) {
        if (!result) {
            LOGGER.info("Failed to get the integrated devices infomation.");
            DialogUtils.showErrorDialog((JDialog)this.mainDialog, (String)ResourceUtil.getString((String)"infocollect.remind.integrateinfoerror"));
        }
    }

    public InfoCollectMainDialog getMainDialog() {
        return this.mainDialog;
    }

    public void setMainDialog(InfoCollectMainDialog mainDialog) {
        this.mainDialog = mainDialog;
        PROCESSING_IMAGE.setImageObserver((ImageObserver)mainDialog.getInfoCollectMainLayout().getDeviceTable());
    }
}

