/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TempProtocols {
    private Map<DevNode, SshConnection> sshConnections = new HashMap<DevNode, SshConnection>();
    private Map<DevNode, SftpTransporter> sftps = new HashMap<DevNode, SftpTransporter>();
    private Map<String, SshConnection> sshConnectionsForShellCreated = new HashMap<String, SshConnection>();
    private Map<String, SftpTransporter> sftpsForForShellCreated = new HashMap<String, SftpTransporter>();
    private Map<DevNode, ITLVConnection> tlvs = new HashMap<DevNode, ITLVConnection>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocolForShellCreated(String ip, Object protocol) {
        Object object = this.lock;
        synchronized (object) {
            if (protocol instanceof SshConnection) {
                this.sshConnectionsForShellCreated.put(ip, (SshConnection)protocol);
            }
            if (protocol instanceof SftpTransporter) {
                this.sftpsForForShellCreated.put(ip, (SftpTransporter)protocol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocol(DevNode devNode, Object protocol) {
        Object object = this.lock;
        synchronized (object) {
            if (protocol instanceof SshConnection) {
                this.sshConnections.put(devNode, (SshConnection)protocol);
            }
            if (protocol instanceof SftpTransporter) {
                this.sftps.put(devNode, (SftpTransporter)protocol);
            }
            if (protocol instanceof ITLVConnection) {
                this.tlvs.put(devNode, (ITLVConnection)protocol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(DevNode devNode) {
        Object object = this.lock;
        synchronized (object) {
            ITLVConnection tlv;
            SftpTransporter sftp;
            SshConnection sshConnection = this.sshConnections.remove(devNode);
            if (sshConnection != null) {
                SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
            }
            if ((sftp = this.sftps.remove(devNode)) != null) {
                sftp.close();
            }
            if ((tlv = this.tlvs.remove(devNode)) != null) {
                TlvConnectionManager.releaseConnection((ITLVConnection)tlv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Collection<SshConnection> connections = this.sshConnections.values();
            for (SshConnection sshConnection : connections) {
                if (sshConnection == null) continue;
                SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
            }
            this.sshConnections.clear();
            Collection<SftpTransporter> sftpValues = this.sftps.values();
            for (SftpTransporter sftp : sftpValues) {
                if (sftp == null) continue;
                sftp.close();
            }
            this.sftps.clear();
            Collection<ITLVConnection> collection = this.tlvs.values();
            for (ITLVConnection tlv : collection) {
                if (tlv == null) continue;
                TlvConnectionManager.releaseConnection((ITLVConnection)tlv);
            }
            this.tlvs.clear();
            this.clearShellCreated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearShellCreated() {
        Object object = this.lock;
        synchronized (object) {
            Collection<SshConnection> connections = this.sshConnectionsForShellCreated.values();
            for (SshConnection connection : connections) {
                if (connection == null) continue;
                SshConnectionManager.releaseConnection((ICliConnection)connection);
            }
            this.sshConnectionsForShellCreated.clear();
            Collection<SftpTransporter> sftpValues = this.sftpsForForShellCreated.values();
            for (SftpTransporter sftp : sftpValues) {
                if (sftp == null) continue;
                sftp.close();
            }
            this.sftpsForForShellCreated.clear();
        }
    }
}

