/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.config.ConfigParser;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfDebufMod;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ComputeNodeParam;
import com.huawei.ism.tool.infocollect.entity.ItemConditionTag;
import com.huawei.ism.tool.infocollect.service.QueryComputeNodesInfoTask;
import com.huawei.ism.tool.infocollect.service.backgroud.ComputeStorageCons;
import com.huawei.ism.tool.infocollect.util.ApplyRange;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectConfParser
extends ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(CollectConfParser.class);
    private static final String ITEM_ID = "id";
    private static final String MICRO_SERVICE_ID = "microservice";
    private static final String NAME_KEY = "namekey";
    private static final String MODE = "mode";
    private static final String DEFAULT_CHOOSE = "default";
    private static final String ENABLE_DATE_ATTRI = "enabledate";
    private static final String APPLY_RANGE = "applyrange";
    private static final String DEBUG_ELEMENT = "debug";
    private static final String COLLECT_MODULE = "module";
    private static final String SINGLE_SELECT = "singleSelect";
    private static final String VERSIONS = "versions";
    private static final String QUERY_SUPPORT_COLLECT = "querySupportCollect";
    private static final String PART_SINGLE_SELECT = "partSingleSelect";
    private static final String COLLECT_DISK_WITH_NODE = "collectDiskWithNode";
    private static final String EXECUTE_SCRIPT = "executeScript";
    private static final String DURATION = "duration";
    private static final String DEFAULT_DURATION = "defaultDuration";
    private static final String ITEM_TAG = "itemTag";
    private static final CollectConfDebufMod BUGMOD = new CollectConfDebufMod();
    private static final String CANCEL_NON_IMMEDIATE_FAMILY = "cancelNonImmediateFamily";
    private static final String TIPS = "tips";
    private static final String CONCURRENT = "concurrent";
    private static final List<String> PRODUCT_VERSION = Arrays.asList("7.0", "8.0", "8.1.0");
    private static final List<String> NO_SELECTED_ITEM = Arrays.asList("node_collect_disksmartinfo", "collect_disk_log");
    private DevNode devNode = null;
    private boolean isSupportSmartCollect = Boolean.parseBoolean(CollectConfigParser.getConfigureValue("isSupportSmartCollect", "false").trim());

    public CollectConf getCollectConfig(DevNode node) {
        this.devNode = node;
        if (!this.isInitResult()) {
            return null;
        }
        try {
            CollectConf result = new CollectConf();
            result.setDebugMode(this.getEnableDebug());
            result.setEnableDate(this.isEnableDate());
            result.setModules(this.getCollectModelsWithoutSmart(node));
            result.setDefaultDuration(this.getDefaultDuration());
            result.setApplyRange(this.getApplyRange());
            result.setVersion(node.getProductVersion());
            result.setDevType(node.getDeviceType().toString());
            result.setComputeStorageFcvNode(InfoCollectUtil.isComputeStorageDevLoginThroughFcv(node));
            return result;
        }
        catch (Exception e) {
            log.error("get collect config error.", (Throwable)e);
            return null;
        }
    }

    private List<CollectModule> getCollectModelsWithoutSmart(DevNode node) {
        if (node.isDsStorage()) {
            return this.getCollectModels().stream().filter(module -> this.isSupportSmartCollect || !this.isSmartCollectModule((CollectModule)module)).collect(Collectors.toList());
        }
        return this.getCollectModels();
    }

    private boolean isSmartCollectModule(CollectModule collectModule) {
        return Stream.of("smart", "disk_info").anyMatch(collectModule.getModuleId()::equalsIgnoreCase);
    }

    private String getDefaultDuration() {
        Element root = this.getDocument().getDocumentElement();
        NodeList nodeList = root.getElementsByTagName(DURATION);
        int length = nodeList.getLength();
        if (length == 0) {
            return "oneDay";
        }
        Element durationElement = (Element)nodeList.item(0);
        String defaultDuration = durationElement.getAttribute(DEFAULT_DURATION);
        if (StringUtils.isNULLStr((String)defaultDuration)) {
            defaultDuration = "oneDay";
        }
        return defaultDuration;
    }

    private CollectConfDebufMod getEnableDebug() {
        Element root = this.getDocument().getDocumentElement();
        NodeList nodeList = root.getElementsByTagName(DEBUG_ELEMENT);
        CollectConfDebufMod mode = new CollectConfDebufMod();
        int length = nodeList.getLength();
        if (length == 0) {
            return mode;
        }
        Element debugElement = (Element)nodeList.item(0);
        String enableString = debugElement.getAttribute("enable");
        try {
            boolean enable = Boolean.parseBoolean(enableString);
            mode.setEnableDebug(enable);
        }
        catch (RuntimeException e) {
            mode.setEnableDebug(false);
        }
        catch (Exception e) {
            mode.setEnableDebug(false);
        }
        return mode;
    }

    private boolean isEnableDate() {
        Element root = this.getDocument().getDocumentElement();
        String enableDateString = root.getAttribute(ENABLE_DATE_ATTRI);
        if (StringUtils.isNULLStr((String)enableDateString)) {
            enableDateString = "false";
        }
        return Boolean.parseBoolean(enableDateString);
    }

    private ApplyRange getApplyRange() {
        Element root = this.getDocument().getDocumentElement();
        Element pathNode = XmlUtils.getChild((Element)root, (String)APPLY_RANGE);
        if (null == pathNode || null == pathNode.getFirstChild()) {
            return ApplyRange.ALL;
        }
        String applyRange = pathNode.getFirstChild().getNodeValue();
        if (StringUtils.isNULLStr((String)applyRange)) {
            return ApplyRange.ALL;
        }
        return ApplyRange.valueOf(applyRange.toUpperCase(Locale.ENGLISH));
    }

    private List<CollectModule> getCollectModels() {
        Element root = this.getDocument().getDocumentElement();
        NodeList nodeList = root.getElementsByTagName(COLLECT_MODULE);
        List<CollectModule> result = new ArrayList<CollectModule>();
        this.getResult(nodeList, result);
        try {
            if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(this.devNode)) {
                result = this.addComputeNodesInfo(result);
            }
            this.notSelectedByDefault(result);
            return result;
        }
        catch (RuntimeException e) {
            log.error("parse collect list config file error!!", (Throwable)e);
            return this.getModulesExcludeComputeNode(Collections.emptyList());
        }
        catch (Exception e) {
            log.error("parse collect list config file error!!", (Throwable)e);
            return this.getModulesExcludeComputeNode(Collections.emptyList());
        }
    }

    private void notSelectedByDefault(List<CollectModule> result) {
        if (!this.devNode.isDsStorage()) {
            return;
        }
        boolean isMatchProductVersion = PRODUCT_VERSION.stream().anyMatch(version -> this.devNode.getProductVersion().contains((CharSequence)version));
        if (isMatchProductVersion) {
            result.stream().flatMap(collectModule -> collectModule.getItems().stream()).filter(item -> NO_SELECTED_ITEM.contains(item.getId())).forEach(item -> item.setDefaultChoose(false));
        }
    }

    private List<CollectModule> addComputeNodesInfo(List<CollectModule> result) throws ToolException {
        if (this.isNotInitialized()) {
            this.waitingForQueryComputeNodesInfo();
        }
        List<CollectModule> transResult = this.getModulesExcludeComputeNode(result);
        Optional<CollectModule> computeNodeModule = this.parseCollectNodeModule(result);
        if (!computeNodeModule.isPresent()) {
            return transResult;
        }
        List<CollectModule> computeNodeModules = this.generateComputeNodeModules(computeNodeModule.get());
        transResult.addAll(computeNodeModules);
        return transResult;
    }

    private void waitingForQueryComputeNodesInfo() throws ToolException {
        ProgressDialog progressDialog = new ProgressDialog((Window)CollectDataContext.getInstance().getInfoCollectMainDialog());
        QueryComputeNodesInfoTask task = new QueryComputeNodesInfoTask(progressDialog, this.devNode);
        Future queryComputeNodesInfoFuture = AsyncExcutor.submit((Callable)task);
        progressDialog.setVisible(true);
        try {
            queryComputeNodesInfoFuture.get();
        }
        catch (InterruptedException e) {
            log.error("query compute nodes information future get InterruptedException:" + e);
            throw new ToolException("query compute nodes information error. " + e.getMessage());
        }
        catch (ExecutionException e) {
            log.error("query compute nodes information future get ExecutionException:" + e);
            throw new ToolException("query compute nodes information error. " + e.getMessage());
        }
    }

    private boolean isNotInitialized() {
        return Objects.isNull(CollectDataContext.getInstance().getDevComputeNodesInfo()) || Objects.isNull(CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode));
    }

    private List<CollectModule> generateComputeNodeModules(CollectModule module) {
        Map<String, ComputeNodeParam> computeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode);
        return computeNodesInfo.keySet().stream().map(key -> this.generateComputeNodeModule(module, computeNodesInfo, (String)key)).collect(Collectors.toList());
    }

    private CollectModule generateComputeNodeModule(CollectModule module, Map<String, ComputeNodeParam> computeNodesInfo, String key) {
        CollectModule transModule = (CollectModule)module.clone();
        transModule.setNameKey(key);
        transModule.setModuleId(key);
        transModule.setItems(this.generateComputeNodeItems(computeNodesInfo, transModule.getItems(), key));
        return transModule;
    }

    private List<CollectItem> generateComputeNodeItems(Map<String, ComputeNodeParam> computeNodesInfo, List<CollectItem> originItems, String key) {
        return originItems.stream().map(item -> this.generateComputeNodeItem((CollectItem)item, key)).filter(item -> !this.isCnaNode(computeNodesInfo, key, (CollectItem)item)).collect(Collectors.toList());
    }

    private CollectItem generateComputeNodeItem(CollectItem item, String key) {
        CollectItem transItem = (CollectItem)item.clone();
        transItem.setModuleId(key);
        return transItem;
    }

    @NotNull
    private Optional<CollectModule> parseCollectNodeModule(List<CollectModule> result) {
        return result.stream().filter(moudle -> moudle.getModuleId().equals("compute_node")).findFirst();
    }

    @NotNull
    private List<CollectModule> getModulesExcludeComputeNode(List<CollectModule> result) {
        return result.stream().filter(module -> !module.getModuleId().equals("compute_node")).collect(Collectors.toList());
    }

    private boolean isCnaNode(Map<String, ComputeNodeParam> computeNodesInfo, String key, CollectItem tmpItem) {
        return computeNodesInfo.get(key).getNodesType().equals("CNA") && !ComputeStorageCons.NODE_CNA_COLLECT_ITEM.contains(tmpItem.getNameKey());
    }

    private void getResult(NodeList nodeList, List<CollectModule> result) {
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Node modelNode = nodeList.item(index);
            CollectModule module = this.parseCollectModule((Element)modelNode);
            result.add(module);
        }
    }

    private List<CollectItem> getCollectItems(Element moduleElement) {
        try {
            String nameKey = moduleElement.getAttribute(NAME_KEY);
            NodeList nodeList = moduleElement.getChildNodes();
            ArrayList<CollectItem> result = new ArrayList<CollectItem>();
            int length = nodeList.getLength();
            for (int index = 0; index < length; ++index) {
                Node itemNode = nodeList.item(index);
                if (!(itemNode instanceof Element)) continue;
                String itemConditionTag = ((Element)itemNode).getAttribute(ITEM_TAG);
                result.add(this.parseCollectItem((Element)itemNode, nameKey));
            }
            return result;
        }
        catch (RuntimeException e) {
            log.error("parse collect list config file error!!", (Throwable)e);
            return new ArrayList<CollectItem>();
        }
        catch (Exception e) {
            log.error("parse collect list config file error!!", (Throwable)e);
            return new ArrayList<CollectItem>();
        }
    }

    private CollectModule parseCollectModule(Element moduleElement) {
        CollectModule module = new CollectModule();
        String nameKey = moduleElement.getAttribute(NAME_KEY);
        String mode = moduleElement.getAttribute(MODE);
        String singleSel = moduleElement.getAttribute(SINGLE_SELECT);
        module.setSingleSelect(Boolean.parseBoolean(singleSel));
        module.setPartSingleSelect(Boolean.parseBoolean(moduleElement.getAttribute(PART_SINGLE_SELECT)));
        ResourceBundle resBundle = this.getResourceBundle();
        module.setNameKey(this.getNameKey(nameKey, resBundle));
        module.setModuleId(nameKey);
        module.setMode(mode);
        module.setItems(this.getCollectItems(moduleElement));
        String versions = moduleElement.getAttribute(VERSIONS);
        module.setVersions(versions);
        String itemSupportQueryScript = moduleElement.getAttribute(QUERY_SUPPORT_COLLECT);
        if (!StringUtils.isNULLStr((String)itemSupportQueryScript)) {
            String itemSupportQryScriptPath = this.getXmlPath().toString() + File.separator + "script" + File.separator + itemSupportQueryScript;
            module.setModuleSupportQueryScript(itemSupportQryScriptPath);
        }
        String cancelNonImmediateFamilyString = moduleElement.getAttribute(CANCEL_NON_IMMEDIATE_FAMILY);
        boolean cancelNonImmediateFamily = false;
        if (!StringUtils.isNULLStr((String)cancelNonImmediateFamilyString)) {
            cancelNonImmediateFamily = Boolean.parseBoolean(cancelNonImmediateFamilyString);
        }
        module.setCancelNonImmediateFamily(cancelNonImmediateFamily);
        String tipsKey = moduleElement.getAttribute(TIPS);
        if (!StringUtils.isNULLStr((String)tipsKey)) {
            module.setTips(this.getRsesourceByKey(tipsKey));
        }
        return module;
    }

    private String getNameKey(String nameKey, ResourceBundle resBundle) {
        return !VerifyUtil.isEmpty((Object)resBundle) && resBundle.containsKey(nameKey) ? resBundle.getString(nameKey) : "--";
    }

    private CollectItem parseCollectItem(Element itemElement, String moduleNameKey) {
        CollectItem item = new CollectItem();
        item.setModuleId(moduleNameKey);
        item.setId(itemElement.getAttribute(ITEM_ID));
        item.setCollectDiskWithNode(itemElement.getAttribute(COLLECT_DISK_WITH_NODE));
        item.setExecuteScript(itemElement.getAttribute(EXECUTE_SCRIPT));
        item.setMicroServiceId(itemElement.getAttribute(MICRO_SERVICE_ID));
        item.setPackageURL(itemElement.getAttribute("packageURL"));
        item.setGetpathURL(itemElement.getAttribute("getpathURL"));
        item.setDownURL(itemElement.getAttribute("downURL"));
        item.setConcurrent(Boolean.parseBoolean(itemElement.getAttribute(CONCURRENT)));
        String nameKey = itemElement.getAttribute(NAME_KEY);
        item.setEnNameKey(nameKey);
        item.setNameKey(this.getResourceBundle().getString(nameKey));
        String defaultString = itemElement.getAttribute(DEFAULT_CHOOSE);
        boolean defaultChoosen = true;
        if (!StringUtils.isNULLStr((String)defaultString)) {
            defaultChoosen = Boolean.parseBoolean(defaultString);
        }
        item.setSingleSelect(Boolean.parseBoolean(itemElement.getAttribute(SINGLE_SELECT)));
        item.setDefaultChoose(defaultChoosen);
        String versions = itemElement.getAttribute(VERSIONS);
        item.setVersions(versions);
        String cancelNonImmediateFamilyString = itemElement.getAttribute(CANCEL_NON_IMMEDIATE_FAMILY);
        boolean cancelNonImmediateFamily = false;
        if (!StringUtils.isNULLStr((String)cancelNonImmediateFamilyString)) {
            cancelNonImmediateFamily = Boolean.parseBoolean(cancelNonImmediateFamilyString);
        }
        item.setCancelNonImmediateFamily(cancelNonImmediateFamily);
        String tipsKey = itemElement.getAttribute(TIPS);
        if (!StringUtils.isNULLStr((String)tipsKey)) {
            String tips = this.getResourceBundle().getString(tipsKey);
            item.setTips(tips);
        }
        item.setItemConditionTag(itemElement.getAttribute(ITEM_TAG));
        this.setSimpleCollectItemTag(item);
        return item;
    }

    private void setSimpleCollectItemTag(CollectItem item) {
        if (!this.devNode.isDsStorage()) {
            return;
        }
        if (item.getId().contains("_extend") || item.getId().equals("collect_common")) {
            item.setItemConditionTag(ItemConditionTag.SIMPLE_COLLECT_ITEM.name());
        }
    }
}

