/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.infocollect.config.ConfigParser;
import com.huawei.ism.tool.infocollect.config.ProtocolParser;
import com.huawei.ism.tool.infocollect.entity.command.CommandConf;
import com.huawei.ism.tool.infocollect.entity.command.ProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommandConfParser
extends ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(CommandConfParser.class);
    private static final String DEFAULT_MAIN_METHOD = "execute";
    private static final String DEFAULT_FILE_POSTFIX = ".py";
    private static final String DEFAULT_PREPROC_FILE_NAME = "preproc.py";
    private static final String DEFAULT_AFTERPROC_FILE_NAME = "postproc.py";
    private String packageFolder = "";

    @Override
    public void init(File xmlFile) {
        this.packageFolder = xmlFile.getParentFile().toString();
        super.init(xmlFile);
    }

    public CommandConf getCommandConf() {
        if (!this.isInitResult()) {
            return null;
        }
        try {
            CommandConf commandConf = new CommandConf();
            ScriptItem preScriptItem = this.parsePreScriptItem();
            if (preScriptItem != null) {
                commandConf.setPreScriptItem(preScriptItem);
            }
            commandConf.setScriptItems(this.parseScriptItems());
            ScriptItem postScriptItem = this.parsePostScriptItem();
            if (postScriptItem != null) {
                commandConf.setPostScriptItem(postScriptItem);
            }
            commandConf.setProtocolItems(this.parseProtocolItems());
            return commandConf;
        }
        catch (Exception e) {
            log.error("parse commandConf failed!!!");
            return null;
        }
    }

    private ScriptItem parsePreScriptItem() throws ToolException {
        String path = this.getAbsluteScriptPath(DEFAULT_PREPROC_FILE_NAME);
        ScriptItem scriptItem = null;
        if (new File(path).exists()) {
            scriptItem = new ScriptItem();
            scriptItem.setMainMethod(DEFAULT_MAIN_METHOD);
            this.setDescKey(scriptItem, "command.preproc");
            scriptItem.setScriptFileName(path);
        }
        return scriptItem;
    }

    private void setDescKey(ScriptItem scriptItem, String key) {
        scriptItem.setDescriptionKey(this.getRsesourceByKey(key));
    }

    private ScriptItem parsePostScriptItem() {
        String path = this.getAbsluteScriptPath(DEFAULT_AFTERPROC_FILE_NAME);
        ScriptItem scriptItem = null;
        if (new File(path).exists()) {
            scriptItem = new ScriptItem();
            scriptItem.setMainMethod(DEFAULT_MAIN_METHOD);
            this.setDescKey(scriptItem, "command.preproc");
            scriptItem.setScriptFileName(path);
        }
        return scriptItem;
    }

    private List<ScriptItem> parseScriptItems() throws ToolException {
        ArrayList<ScriptItem> scriptItems = new ArrayList<ScriptItem>();
        NodeList nodeList = this.getDocument().getElementsByTagName("script");
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Element son = (Element)nodeList.item(index);
            String step = son.getAttribute("step");
            boolean keepOn = false;
            String value = son.getAttribute("independent");
            if (!StringUtils.isNULLStr((String)value)) {
                keepOn = Boolean.valueOf(value);
            }
            if (son.getChildNodes().getLength() != 0) {
                NodeList sonList = son.getElementsByTagName("item");
                for (int sonIndex = 0; sonIndex < sonList.getLength(); ++sonIndex) {
                    ScriptItem item = this.parseScriptItem((Element)sonList.item(sonIndex));
                    item.setStep(step);
                    item.setKeepOn(keepOn);
                    scriptItems.add(item);
                }
                continue;
            }
            ScriptItem item = this.parseScriptItem((Element)nodeList.item(index));
            item.setKeepOn(keepOn);
            scriptItems.add(item);
        }
        return scriptItems;
    }

    private ScriptItem parseScriptItem(Element scriptElement) {
        String linkValue;
        String linkKey;
        ScriptItem item = new ScriptItem();
        String step = scriptElement.getAttribute("step");
        item.setStep(step);
        item.setMainMethod(this.parseMainMethod(scriptElement));
        item.setDescriptionKey(this.getDescKey(scriptElement));
        item.setScriptFileName(this.parseFileItem(scriptElement));
        String linkDesc = scriptElement.getAttribute("linkDesc");
        if (!StringUtils.isNULLStr((String)linkDesc)) {
            item.setLinkDesc(this.getRsesourceByKey(linkDesc));
        }
        if (!StringUtils.isNULLStr((String)(linkKey = scriptElement.getAttribute("linkKey")))) {
            item.setLinkName(this.getRsesourceByKey(linkKey));
        }
        if (!StringUtils.isNULLStr((String)(linkValue = scriptElement.getAttribute("linkValue")))) {
            item.setHelpWords(this.getRsesourceByKey(linkValue));
        }
        this.parsingCheck(item, scriptElement);
        item.setType(this.parseType(scriptElement));
        return item;
    }

    @Nullable
    private ScriptType parseType(Element scriptElement) {
        String type = scriptElement.getAttribute("type");
        return ScriptType.getScriptType(type);
    }

    private String getDescKey(Element scriptElement) {
        String desc = scriptElement.getAttribute("description");
        if (StringUtils.isNULLStr((String)desc)) {
            return "--";
        }
        try {
            return this.getRsesourceByKey(desc);
        }
        catch (RuntimeException e) {
            log.error("get script item desc description error");
            return ResourceUtil.getString((String)"infocollect.detail.nodescription");
        }
        catch (Exception e) {
            log.error("get script item desc description error");
            return ResourceUtil.getString((String)"infocollect.detail.nodescription");
        }
    }

    @NotNull
    private String parseFileItem(Element scriptElement) {
        String fileName = scriptElement.getAttribute("file");
        if (StringUtils.isNULLStr((String)fileName)) {
            fileName = scriptElement.getAttribute("step") + DEFAULT_FILE_POSTFIX;
        }
        fileName = this.getAbsluteScriptPath(fileName);
        return fileName;
    }

    @NotNull
    private String parseMainMethod(Element scriptElement) {
        String mainMethod = scriptElement.getAttribute("method");
        if (StringUtils.isNULLStr((String)mainMethod)) {
            mainMethod = DEFAULT_MAIN_METHOD;
        }
        return mainMethod;
    }

    private void parsingCheck(ScriptItem item, Element scriptElement) {
        String check = scriptElement.getAttribute("check");
        if ("true".equals(check)) {
            item.setNeedCheck(true);
        }
    }

    private List<ProtocolItem> parseProtocolItems() {
        ArrayList<ProtocolItem> scriptItems = new ArrayList<ProtocolItem>();
        NodeList nodeList = this.getDocument().getElementsByTagName("protocol");
        int length = nodeList.getLength();
        ProtocolParser protocolParser = new ProtocolParser();
        for (int index = 0; index < length; ++index) {
            Element protocolElement = (Element)nodeList.item(index);
            ProtocolItem item = protocolParser.parseProtocolItem(protocolElement);
            if (item == null) continue;
            scriptItems.add(item);
        }
        return scriptItems;
    }

    private String getAbsluteScriptPath(String fileName) {
        return this.packageFolder + File.separator + "script" + File.separator + fileName;
    }
}

