/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigParser.class);
    private Document document = null;
    private Path xmlPath = null;
    private boolean initResult = false;
    private ResourceBundle resourceBundle = null;

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(File xmlFile) {
        InputStream is = null;
        Path path = xmlFile.toPath();
        try {
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (!attrs.isRegularFile()) {
                log.error("Could not open File.");
                return;
            }
            if (!xmlFile.exists()) {
                log.error("Could not open FileInputStream, beacuse the xmlFile may not exist.");
                return;
            }
            is = Files.newInputStream(path, new OpenOption[0]);
            this.document = XmlUtils.parseDocument((InputStream)is);
            this.xmlPath = path.getParent().toAbsolutePath();
            this.initResult = true;
            StreamUtils.closeStream(null, (InputStream)is);
        }
        catch (IOException e) {
            log.error("init xml parser error,the file is : {}", (Object)xmlFile);
            this.initResult = false;
        }
        catch (RuntimeException e) {
            log.error("init xml parser error,the file is : {}", (Object)xmlFile);
            this.initResult = false;
        }
        catch (Exception e) {
            log.error("init xml parser error,the file is : {}", (Object)xmlFile);
            this.initResult = false;
        }
        finally {
            StreamUtils.closeStream(null, is);
        }
    }

    public void init(InputStream inputStream) {
        try {
            this.document = XmlUtils.parseDocument((InputStream)inputStream);
            this.initResult = true;
        }
        catch (RuntimeException e) {
            log.error("init xml parser error", (Throwable)e);
            this.initResult = false;
        }
        catch (Exception e) {
            log.error("init xml parser error", (Throwable)e);
            this.initResult = false;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isInitResult() {
        return this.initResult;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setInitResult(boolean initResult) {
        this.initResult = initResult;
    }

    public Path getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(Path xmlPath) {
        this.xmlPath = xmlPath;
    }

    @NotNull
    public String getRsesourceByKey(String key) {
        if (this.getResourceBundle() == null) {
            log.info("getResourceBundle() is null.");
            return "--";
        }
        return this.getResourceBundle().getString(key);
    }
}

