/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.base.context.StartParamContext;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.CollectConfParser;
import com.huawei.ism.tool.infocollect.config.CommandConfParser;
import com.huawei.ism.tool.infocollect.config.ConfKeeper;
import com.huawei.ism.tool.infocollect.config.PackageINIParser;
import com.huawei.ism.tool.infocollect.config.PreConditionParser;
import com.huawei.ism.tool.infocollect.config.SettingConfParser;
import com.huawei.ism.tool.infocollect.config.SysConfParser;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.entity.ProductConf;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.SupportScene;
import com.huawei.ism.tool.infocollect.interf.IGetPackagesPath;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskCons;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateCollectEnvCommand;
import com.huawei.ism.tool.infocollect.util.DStoragePackageUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.infocollect.util.JythonExecuteResult;
import com.huawei.ism.tool.infocollect.util.JythonUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public final class InfoConfiguration
implements IGetPackagesPath {
    private static final Logger log = LoggerFactory.getLogger(InfoConfiguration.class);
    public static final String SYS_CONF_FILE_NAME = "sysconf.xml";
    private static final String COLLECT_CONF_FILE_NAME = "collectconf.xml";
    private static final String CONCURRENT_COLLECT_CONF_FILE_NAME = "collectconf_6.1.3.xml";
    private static final String CONCURRENT_COLLECT_CONF_NO_DISLOG = "collectconf_6.1.3_no_fault_disklog.xml";
    private static final String COLLECT_CONF_BY_UPGRAD_FILE_NAME = "collectconfByUpgradCheck.xml";
    private static final String CLOUDBACKUP_COLLECT_CONF_FILE_NAME = "cloudBackUp-collectconf.xml";
    private static final String CLOUDBACKUP_CONCURRENT_COLLECT_CONF_FILE_NAME = "cloudBackUp-collectconf_concurrent.xml";
    private static final String CLOUDBACKUP_CONCURRENT_COLLECT_CONF_NO_DISLOG = "cloudBackUp-collectconf_concurrent_no_fault_dislog.xml";
    private static final String LICENSE_COLLECT_CONF_BY_UPGRAD__FILE_NAME = "license-collectconfByUpgradChek.xml";
    private static final String COLLECT_CONF_616_FILE_NAME = "collectconf_6.1.6.xml";
    private static final String COLLECT_CONF_616_LICENSE_FILE_NAME = "collectconf_6.1.6_license.xml";
    private static final String COMMAND_CONF_FILE_NAME = "commandconf.xml";
    private static final String SETTING_CONF_FILE_NAME = "SettingConfig.xml";
    private static final String PRE_CONDITION_FILE_NAME = "preconditions.xml";
    private static final String RES_NAME = "resource";
    private static final String RES_FOLDER = "res";
    private static final String FAULT_SCENE_NAME = "faultSceneLogCollect";
    private static final InfoConfiguration INSTANCE = new InfoConfiguration();
    private static final String ITEMSID_SEPARATOR = ",";
    private static final String FULLLOG = "fulllog";
    private static final String BYTIME = "bytime";
    private static final String EMERGENCY_LOG = "log";
    private static final String TROUBLES_SHOOTING = "Troubleshooting";
    private static final String STORAGE_COLLECT = "Storage Collect";
    private static final String ROUTINE_MAINTAIN = "Routine Maintain";
    private static final String DAILY_CHECKS = "Daily Checks";
    private ConfKeeper confKeeper = new ConfKeeper();
    private ConcurrentHashMap<DevNode, Map<String, Boolean>> devSupportModulesByScriptCache = new ConcurrentHashMap();
    private String configPath = "";

    private InfoConfiguration() {
    }

    public static InfoConfiguration getInstance() {
        return INSTANCE;
    }

    public Set<PackageConf> getPackageConfs() {
        return this.confKeeper.getConfs().keySet();
    }

    public String getPackageScriptPath(DevNode devNode) {
        String folder = "";
        PackageConf conf = this.getPackageConf(devNode);
        if (null != conf) {
            folder = conf.getFolder();
        }
        return FilePathUtils.checkFile((String)(this.configPath + File.separator + folder + File.separator + "script"));
    }

    public String getIntegrateScriptPath(DevNode devNode) {
        PackageConf packageConf = this.getPackageConf(devNode);
        if (packageConf == null) {
            return "";
        }
        String scriptFilePath = this.configPath + File.separator + packageConf.getFolder() + File.separator + "script";
        File scriptFile = new File(FilePathUtils.checkFile((String)scriptFilePath));
        if (!scriptFile.exists() || !scriptFile.isDirectory()) {
            return "";
        }
        File[] files = scriptFile.listFiles();
        if (null == files) {
            return "";
        }
        for (File file : files) {
            if (!file.getName().equals("integrate_find.py") && !file.getName().equals("real_integrate_find.py")) continue;
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                log.error("get path error.", (Throwable)e);
                return "";
            }
        }
        return "";
    }

    public void init() {
        this.clear();
        this.configPath = CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath();
        List<File> bizPackageFiles = this.getAllProductPackageFiles();
        for (File bizPackage : bizPackageFiles) {
            PackageConf packageConfig = this.parseBizPackage(bizPackage);
            if (packageConfig == null) continue;
            this.addParseBizPackage(packageConfig);
        }
    }

    public void clear() {
        this.confKeeper.getConfs().clear();
        this.confKeeper.getResourceBundles().clear();
    }

    public ResourceBundle getResourceBundle(DevNode devNode) {
        return this.getResourceBundle(this.getPackageConf(devNode));
    }

    private ResourceBundle getResourceBundle(PackageConf packageConf) {
        if (packageConf == null) {
            return null;
        }
        ResourceBundle bundle = this.confKeeper.getResourceBundles().get(packageConf);
        if (bundle == null) {
            String resFolder = this.getFullPackagePath(packageConf.getFolder()) + RES_FOLDER;
            bundle = this.createResourceBundle(new File(resFolder));
            this.confKeeper.getResourceBundles().put(packageConf, bundle);
        }
        return bundle;
    }

    /*
     * Exception decompiling
     */
    private ResourceBundle createResourceBundle(File propertiesPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CollectConf getCollectConf(DevNode devNode) {
        PackageConf packageConfig = this.getPackageConf(devNode);
        if (packageConfig == null) {
            return null;
        }
        return this.getCollectConf(packageConfig, devNode);
    }

    private CollectConf getCollectConf(PackageConf packageConf, DevNode devNode) {
        CollectConf collectConfTemp;
        if (packageConf == null) {
            return null;
        }
        if (this.isNeedModifyCollectConf(devNode)) {
            this.modifyCollectConf(devNode);
        }
        CollectConf collectConf = null;
        if (this.confKeeper.getConfs().containsKey(packageConf) && this.isConfigurationObject(devNode, collectConfTemp = this.confKeeper.getConfs().get(packageConf))) {
            collectConf = collectConfTemp;
        }
        CollectConfParser parser = null;
        if (collectConf == null || !collectConf.isInited() || InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode)) {
            parser = new CollectConfParser();
            collectConf = this.createCollectConf(parser, packageConf, devNode);
            if (collectConf != null && collectConf.isInited()) {
                this.confKeeper.getConfs().put(packageConf, collectConf);
            } else {
                return null;
            }
        }
        this.changeItemsId(collectConf);
        String productVersion = devNode.getProductVersion();
        if (this.isCreateNewCollectConf(collectConf, productVersion, devNode)) {
            return this.copyCollectConf(collectConf, productVersion, devNode);
        }
        return collectConf;
    }

    private boolean isConfigurationObject(DevNode devNode, CollectConf collectConfTemp) {
        return collectConfTemp.getVersion().equals(devNode.getProductVersion()) && collectConfTemp.getDevType().equals(devNode.getDeviceType().toString()) && InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode) == collectConfTemp.isComputeStorageFcvNode();
    }

    private boolean isNeedModifyCollectConf(DevNode devNode) {
        return !devNode.isDsStorage() && InfoCollectUtil.getDevsList(TaskCons.DATA_BACKUP_PRODUCTS, TaskCons.CLOUD_BACKUP_PRODUCTS, TaskCons.HYPER_DETECT_PRODUCTS).contains(devNode.getDeviceType().toString());
    }

    void modifyCollectConf(DevNode devNode) {
        Map<DevNode, Boolean> devLicenseQueryResultCacheMap = CollectDataContext.getInstance().getDevLicenseQueryResultCacheMap();
        if (devLicenseQueryResultCacheMap.getOrDefault(devNode, false).booleanValue()) {
            return;
        }
        devLicenseQueryResultCacheMap.put(devNode, true);
        CollectDataContext.getInstance().setDevLicenseQueryResultCacheMap(devLicenseQueryResultCacheMap);
        if (CollectDataContext.getInstance().getDevLicenseQueryResultCacheMap().getOrDefault(devNode, false).booleanValue()) {
            InfoCollectUtil.waitCheckLicense(devNode, CollectDataContext.getInstance().getInfoCollectMainDialog());
            return;
        }
        if (!ApplicationContext.getInstance().isWindowsOS() || StartParamContext.isWeb()) {
            InfoCollectUtil.waitCheckLicense(devNode);
        } else {
            InfoCollectUtil.waitCheckLicense(devNode, CollectDataContext.getInstance().getInfoCollectMainDialog());
        }
        devLicenseQueryResultCacheMap.put(devNode, true);
    }

    private void changeItemsId(CollectConf collectConf) {
        String mode = CollectDataContext.getInstance().getMode();
        if (CollectDataContext.getInstance().isBackground() && (FULLLOG.equalsIgnoreCase(mode) || BYTIME.equalsIgnoreCase(mode) || EMERGENCY_LOG.equalsIgnoreCase(mode))) {
            try {
                String[] itemsId = this.getInfoCollectProperItemsId();
                this.modefyItemsIdDefaultValue(collectConf, itemsId);
                this.modifyFullLogItemsIdDefaultValue(collectConf, mode);
            }
            catch (Exception e) {
                log.error("get itemsId failed: {}", (Throwable)e);
            }
        }
    }

    void modifyFullLogItemsIdDefaultValue(CollectConf collectConf, String mode) {
        if (!FULLLOG.equalsIgnoreCase(mode)) {
            log.info("mode is not full log.");
            return;
        }
        log.info("Start modify full log items id default value.");
        collectConf.getAllCollectItems().forEach(collectItem -> {
            if (collectItem.getId().equalsIgnoreCase(EMERGENCY_LOG)) {
                collectItem.setDefaultChoose(false);
            }
            if (collectItem.getId().equalsIgnoreCase("all_log")) {
                collectItem.setDefaultChoose(true);
            }
        });
    }

    private void modefyItemsIdDefaultValue(CollectConf collectConf, String[] itemsId) {
        collectConf.getAllCollectItems().stream().forEach(collectItem -> Arrays.stream(itemsId).forEach(itemid -> {
            if (collectItem.getId().equalsIgnoreCase((String)itemid)) {
                collectItem.setDefaultChoose(true);
            }
        }));
    }

    private String[] getInfoCollectProperItemsId() {
        ResourceBundle sysBundle = ResourceBundle.getBundle("config.infocollect");
        if (sysBundle == null) {
            log.info("can't open infocollect.properties file");
            return new String[0];
        }
        String[] itemsId = sysBundle.getString("itemsId").split(ITEMSID_SEPARATOR);
        if (itemsId == null) {
            log.info("can't get itemsId");
            return new String[0];
        }
        return itemsId;
    }

    String getCollectConfName(PackageConf packageConf, DevNode devNode) {
        String privateCollectListStr = "";
        List<ProductConf> productConfs = packageConf.getProductConfigs();
        for (ProductConf productConf : productConfs) {
            if (!productConf.isContainProduct(devNode)) continue;
            String devRealType = devNode.getDeviceType() + " " + devNode.getProductVersion();
            Map<String, String> priCollectListMap = productConf.getPrivateCollectListMap();
            for (Map.Entry<String, String> priCollectListEntry : priCollectListMap.entrySet()) {
                if (!InfoConfiguration.startsWith(devRealType, priCollectListEntry.getKey())) continue;
                privateCollectListStr = priCollectListEntry.getValue();
                break;
            }
            List<SupportScene> supportScenes = productConf.getSupportScenes();
            for (SupportScene supportScene : supportScenes) {
                if (this.isDorado616NonScenarioBased(devNode) && !this.isDorado616DefaultScene(supportScene)) continue;
                if (this.isDorado616NonScenarioBased(devNode) && this.isDorado616DefaultScene(supportScene)) {
                    return supportScene.getChecklist();
                }
                if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode)) {
                    return supportScene.getFcvList();
                }
                if (!CollectDataContext.getInstance().isScene() && TROUBLES_SHOOTING.equals(supportScene.getMainScene()) && STORAGE_COLLECT.equals(supportScene.getSubScene())) {
                    return supportScene.getChecklist();
                }
                if (!CollectDataContext.getInstance().isSceneSupport(supportScene.getField(), supportScene.getMainScene(), supportScene.getSubScene())) continue;
                return supportScene.getChecklist();
            }
        }
        if (!privateCollectListStr.isEmpty()) {
            return privateCollectListStr;
        }
        return COLLECT_CONF_FILE_NAME;
    }

    boolean isDorado616NonScenarioBased(DevNode devNode) {
        return !CollectDataContext.getInstance().isScene() && InfoCollectUtil.isDevicesCollectedByScene(devNode);
    }

    boolean isDorado616DefaultScene(SupportScene supportScene) {
        return ROUTINE_MAINTAIN.equals(supportScene.getMainScene()) && DAILY_CHECKS.equals(supportScene.getSubScene());
    }

    private static boolean startsWith(String productVersion, String curVer) {
        if (productVersion.contains("Kunpeng") && curVer.contains("Kunpeng")) {
            return productVersion.replace("Kunpeng", "").trim().startsWith(curVer.replace("Kunpeng", "").trim());
        }
        if (productVersion.contains("Kunpeng") && !curVer.contains("Kunpeng") || !productVersion.contains("Kunpeng") && curVer.contains("Kunpeng")) {
            return false;
        }
        return productVersion.trim().startsWith(curVer.trim());
    }

    private String getFullPackagePath(String folder) {
        return FilePathUtils.checkFile((String)(this.configPath + File.separator + folder)) + File.separator;
    }

    public PackageConf getPackageConf(DevNode devNode) {
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.confKeeper.getConfs().keySet()).iterator();
        PackageConf result = null;
        while (iterator.hasNext()) {
            PackageConf current = (PackageConf)iterator.next();
            if (!current.isContainDevNode(devNode)) continue;
            if (result == null) {
                result = current;
                continue;
            }
            if (result.isNew(current)) continue;
            result = current;
        }
        if (null == result && devNode.isMiniSystem()) {
            for (PackageConf current : this.confKeeper.getConfs().keySet()) {
                if (!FAULT_SCENE_NAME.equals(current.getName())) continue;
                result = current;
                break;
            }
        }
        return result;
    }

    public void modifyConfigurationInformation(DevNode devNode) {
        PackageConf result = this.getPackageConf(devNode);
        if (result == null) {
            log.warn("{} get package fail.", (Object)devNode.getIp());
            return;
        }
        this.confKeeper.getConfs().keySet().stream().filter(current -> current.isContainDevNode(devNode)).collect(Collectors.toList()).forEach(this::removeSpecifiedPackageConf);
        result.getProductConfigs().stream().filter(productConf -> devNode.getDeviceType().toString().contains(productConf.getProductName())).forEach(this::modifyProductConf);
        this.addParseBizPackage(result);
    }

    private void removeSpecifiedPackageConf(PackageConf packageConf) {
        this.confKeeper.getConfs().remove(packageConf);
        this.confKeeper.getResourceBundles().remove(packageConf);
    }

    private void modifyProductConf(ProductConf productConf) {
        productConf.getSupportScenes().forEach(this::modifySupportScene);
    }

    void modifySupportScene(SupportScene supportScene) {
        if (CLOUDBACKUP_COLLECT_CONF_FILE_NAME.equals(supportScene.getChecklist())) {
            supportScene.setChecklist(COLLECT_CONF_BY_UPGRAD_FILE_NAME);
            return;
        }
        if (CLOUDBACKUP_CONCURRENT_COLLECT_CONF_FILE_NAME.equals(supportScene.getChecklist())) {
            supportScene.setChecklist(CONCURRENT_COLLECT_CONF_FILE_NAME);
            return;
        }
        if (LICENSE_COLLECT_CONF_BY_UPGRAD__FILE_NAME.equals(supportScene.getChecklist())) {
            supportScene.setChecklist(COLLECT_CONF_BY_UPGRAD_FILE_NAME);
            return;
        }
        if (CLOUDBACKUP_CONCURRENT_COLLECT_CONF_NO_DISLOG.equals(supportScene.getChecklist())) {
            supportScene.setChecklist(CONCURRENT_COLLECT_CONF_NO_DISLOG);
            return;
        }
        if (COLLECT_CONF_616_LICENSE_FILE_NAME.equals(supportScene.getChecklist())) {
            supportScene.setChecklist(COLLECT_CONF_616_FILE_NAME);
        }
    }

    public void addParseBizPackage(PackageConf packageConfig) {
        this.confKeeper.getConfs().remove(packageConfig);
        this.confKeeper.getConfs().put(packageConfig, new CollectConf());
        this.confKeeper.getResourceBundles().put(packageConfig, null);
    }

    public PackageConf parseBizpackage(InputStream is) {
        SysConfParser parser = new SysConfParser();
        parser.init(is);
        return parser.getPackageConfig();
    }

    public PackageConf parseBizPackage(File packageFile) {
        File actualPackageFile = FilePathUtils.checkFile((File)packageFile);
        if (!actualPackageFile.exists() || !actualPackageFile.isDirectory()) {
            log.info("Could not open confile of this tool!");
            return null;
        }
        String packageConfFileName = FilesUtil.getCanonicalPath((File)actualPackageFile) + File.separator + SYS_CONF_FILE_NAME;
        String packageINIFileName = FilesUtil.getCanonicalPath((File)actualPackageFile) + File.separator + "package.ini";
        File packageConfFile = new File(packageConfFileName);
        File packageINIFile = new File(packageINIFileName);
        if (!packageConfFile.exists()) {
            log.info("The file : {} is not exists.", (Object)packageConfFile.getPath());
            return null;
        }
        SysConfParser parser = new SysConfParser();
        parser.init(packageConfFile);
        PackageConf packageConf = parser.getPackageConfig();
        if (packageConf == null) {
            log.info("parse tool's configuration file(sysconf.xml) failed.");
            return null;
        }
        PackageINIParser iniParser = new PackageINIParser(packageINIFile);
        iniParser.parsePackageConf(packageConf);
        return packageConf;
    }

    private List<File> getAllProductPackageFiles() {
        File file = new File(this.configPath);
        ArrayList<File> result = new ArrayList<File>();
        File[] listFiles = file.listFiles();
        if (null != listFiles) {
            result.addAll(Arrays.asList(listFiles));
        }
        return result;
    }

    @Override
    public String getPackagePath() {
        return String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", "collect", "products");
    }

    public String getPackagePath(DevNode devNode) {
        PackageConf packageConfig = this.getPackageConf(devNode);
        if (null == packageConfig) {
            return "";
        }
        return this.getPackagePath() + File.separator + packageConfig.getFolder();
    }

    public boolean hasAdvancedOptions(DevNode devnode) {
        PackageConf packageConfig = this.getPackageConf(devnode);
        if (packageConfig == null) {
            return false;
        }
        String settingFileName = this.getFullPackagePath(packageConfig.getFolder()) + File.separator + SETTING_CONF_FILE_NAME;
        return devnode.isDsStorage() || new File(FilePathUtils.checkFile((String)settingFileName)).exists();
    }

    public SettingConfInfo getSettingConf(DevNode devNode) {
        PackageConf packageConfig = this.getPackageConf(devNode);
        if (packageConfig == null) {
            return null;
        }
        String settingFileName = this.getFullPackagePath(packageConfig.getFolder()) + File.separator + SETTING_CONF_FILE_NAME;
        SettingConfParser parser = new SettingConfParser(devNode);
        parser.setResourceBundle(this.getResourceBundle(packageConfig));
        parser.init(new File(settingFileName));
        return parser.getSettingConfInfo();
    }

    public String getDateScriptPath(DevNode device) {
        File scriptFile;
        PackageConf packageConf = this.getPackageConf(device);
        if (packageConf == null) {
            return "";
        }
        String scriptFilePath = this.configPath + File.separator + packageConf.getFolder() + File.separator + "script" + File.separator + "getdevicedate.py";
        if (ItDeviceType.COMPUTE_STORAGE.equals((Object)device.getStorageDeviceType())) {
            scriptFilePath = String.join((CharSequence)File.separator, this.configPath, packageConf.getFolder(), "script", "common", "get_device_date.py");
        }
        if (!(scriptFile = new File(FilePathUtils.checkFile((String)scriptFilePath))).exists()) {
            return "";
        }
        return scriptFilePath;
    }

    public ProductConf getProductConf(DevNode devNode) {
        PackageConf packageConf = this.getPackageConf(devNode);
        if (packageConf == null) {
            return null;
        }
        List<ProductConf> productConfs = packageConf.getProductConfigs();
        for (ProductConf productConf : productConfs) {
            if (!productConf.isContainProduct(devNode)) continue;
            return productConf;
        }
        return null;
    }

    private CollectConf createCollectConf(CollectConfParser parser, PackageConf packageConf, DevNode devNode) {
        parser.setResourceBundle(this.getResourceBundle(packageConf));
        parser.init(new File(this.getFullPackagePath(packageConf.getFolder()) + this.getCollectConfName(packageConf, devNode)));
        CollectConf collectConf = parser.getCollectConfig(devNode);
        DStoragePackageUtil.loadingExtendedConf(collectConf, devNode);
        if (collectConf == null) {
            return null;
        }
        CommandConfParser commandConfParser = new CommandConfParser();
        commandConfParser.setResourceBundle(this.getResourceBundle(packageConf));
        commandConfParser.init(new File(this.getFullPackagePath(packageConf.getFolder()) + COMMAND_CONF_FILE_NAME));
        collectConf.setComandConf(commandConfParser.getCommandConf());
        PreConditionParser preConditionParser = new PreConditionParser();
        preConditionParser.init(new File(this.getFullPackagePath(packageConf.getFolder()) + PRE_CONDITION_FILE_NAME));
        collectConf.setPreConditions(preConditionParser.parse());
        collectConf.setInited(true);
        if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode)) {
            CollectDataContext.getInstance().addInitCollectInfoComputeStorageDev(devNode);
        }
        return collectConf;
    }

    private boolean isMatchVersion(String matchVersions, String productVersion) {
        if (StringUtils.isNULLStr((String)matchVersions)) {
            return true;
        }
        try {
            if (productVersion.matches(matchVersions)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            log.error("Matcheing product version error, because pattern error." + patternSyntaxException.toString());
            return true;
        }
        return false;
    }

    private boolean isCreateNewCollectConf(CollectConf collectConf, String productVersion, DevNode devNode) {
        List<CollectModule> collectModules = collectConf.getModules();
        for (CollectModule module : collectModules) {
            String moduleVersions = module.getVersions();
            if (!this.isMatchVersion(moduleVersions, productVersion)) {
                return true;
            }
            List<CollectItem> collectItems = module.getItems();
            for (CollectItem item : collectItems) {
                String itemVersions = item.getVersions();
                if (this.isMatchVersion(itemVersions, productVersion)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isModuleSupportByScript(CollectModule module, DevNode devNode) {
        if (StringUtils.isNULLStr((String)module.getModuleSupportQueryScript())) {
            return true;
        }
        Map devModuleSupportMap = this.getDevSupportModulesByScriptCache().getOrDefault(devNode, new HashMap());
        this.getDevSupportModulesByScriptCache().putIfAbsent(devNode, devModuleSupportMap);
        Boolean moduleSupportByScript = (Boolean)devModuleSupportMap.get(module.getModuleId());
        if (null != moduleSupportByScript) {
            return moduleSupportByScript;
        }
        IntegrateCollectInfo ici = new IntegrateCollectInfo(devNode);
        CreateCollectEnvCommand basicEnvCmd = new CreateCollectEnvCommand(ici, false);
        basicEnvCmd.basicEnvInit();
        String itemSupportQueryScript = module.getModuleSupportQueryScript();
        if (null == itemSupportQueryScript || CollectDataContext.getInstance().isDebugHostInfoCollect()) {
            return true;
        }
        JythonExecuteResult result = JythonUtil.executeOneBooleanReturnValueScript(itemSupportQueryScript, "is_support", basicEnvCmd.getCollectEnv());
        if (!result.isExecuteSuccess()) {
            log.warn("Module {} support script {} executed exception.", (Object)module.getName(), (Object)module.getModuleSupportQueryScript());
            devModuleSupportMap.put(module.getModuleId(), false);
            return false;
        }
        devModuleSupportMap.put(module.getModuleId(), result.isReturnTrue());
        return result.isReturnTrue();
    }

    private CollectConf copyCollectConf(CollectConf collectConf, String productVersion, DevNode devNode) {
        ArrayList<CollectModule> newCollectModules = new ArrayList<CollectModule>();
        for (CollectModule module : collectConf.getModules()) {
            String moduleVersions = module.getVersions();
            if (!this.isMatchVersion(moduleVersions, productVersion)) {
                log.info("collection model configuration version does not match product version.");
                continue;
            }
            if (!this.isModuleSupportByScript(module, devNode)) continue;
            ArrayList<CollectItem> newCollectItems = new ArrayList<CollectItem>();
            for (CollectItem item : module.getItems()) {
                String itemVersions = item.getVersions();
                if (!this.isMatchVersion(itemVersions, productVersion)) {
                    log.info("collection item configuration version does not match product version.");
                    continue;
                }
                CollectItem newItem = (CollectItem)item.clone();
                newCollectItems.add(newItem);
            }
            CollectModule newModule = (CollectModule)module.clone();
            newModule.setItems(newCollectItems);
            newCollectModules.add(newModule);
        }
        CollectConf newCollectConf = (CollectConf)collectConf.clone();
        newCollectConf.setModules(newCollectModules);
        return newCollectConf;
    }

    public ConcurrentHashMap<DevNode, Map<String, Boolean>> getDevSupportModulesByScriptCache() {
        return this.devSupportModulesByScriptCache;
    }
}

