/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.ConfigParser;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IntegrateParser
extends ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(IntegrateParser.class);
    private static final String ROOT_NODE = "<devices>";
    private static final String ROOT_END_NODE = "</devices>";
    private static final String DEVICE_ELEMENT = "device";
    private static final String IP_ELEMENT = "ip";
    private static final String USERNAME_ELEMENT = "username";
    private static final String PWD_ELEMENT = "password";
    private DevNode dev;

    public IntegrateParser(DevNode devNode) {
        this.dev = devNode;
    }

    public boolean init(String xmlString) {
        String xml = xmlString;
        try {
            int index = xml.indexOf(ROOT_NODE);
            if (index == -1) {
                throw new ToolException("invaliable xml string");
            }
            if ((index = (xml = xml.substring(index)).indexOf(ROOT_END_NODE)) == -1) {
                throw new ToolException("invaliable xml string");
            }
            xml = xml.substring(0, index + ROOT_END_NODE.length()).replaceAll("\r", "").replaceAll("\n", "").replaceAll(" ", "");
            this.setDocument(XmlUtils.parseDocument((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            this.setInitResult(true);
        }
        catch (ToolException e) {
            log.error("invalid xml string.");
            this.setInitResult(false);
        }
        catch (RuntimeException e) {
            log.error("init xml parser error,the file from integrate_find.py");
            this.setInitResult(false);
        }
        return this.isInitResult();
    }

    public List<DevNode> getIntegrateInfoes() {
        ArrayList<DevNode> results = new ArrayList<DevNode>();
        if (!this.isInitResult()) {
            return results;
        }
        Element root = this.getDocument().getDocumentElement();
        NodeList deviceList = root.getElementsByTagName(DEVICE_ELEMENT);
        if (deviceList.getLength() == 0) {
            return results;
        }
        for (int index = 0; index < deviceList.getLength(); ++index) {
            DevNode devNode = this.parseDevNode((Element)deviceList.item(index));
            if (devNode == null) continue;
            results.add(devNode);
        }
        return results;
    }

    private DevNode parseDevNode(Element deviceElement) {
        try {
            Element ipElement = (Element)deviceElement.getElementsByTagName(IP_ELEMENT).item(0);
            Element userNameElement = (Element)deviceElement.getElementsByTagName(USERNAME_ELEMENT).item(0);
            Element passwordElement = (Element)deviceElement.getElementsByTagName(PWD_ELEMENT).item(0);
            String ip = ipElement.getTextContent();
            String userName = userNameElement.getTextContent();
            String password = passwordElement.getTextContent();
            DevNode devNode = new DevNode();
            devNode.setIp(ip);
            devNode.setLoginUser(new User(userName, password));
            this.setConnectionPolicy(devNode);
            DevNode targetDevNode = CollectDataContext.getInstance().getContainDevNodebyIP(ip);
            if (targetDevNode != null) {
                return targetDevNode;
            }
            ArrayList<DeviceType> supportDevTypes = new ArrayList<DeviceType>();
            supportDevTypes.add(DeviceType.ALL);
            DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(supportDevTypes, ShowSysConstans.getShowSysCmds());
            TaskResult taskResult = nodeTypeQuery.queryNodeInfo(devNode, DeviceOpr.OTHERS);
            if (!taskResult.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
                log.error("query integrate info error!!!!");
                return null;
            }
            return devNode;
        }
        catch (Exception e) {
            log.error("parse integrate info error!!!!", (Throwable)e);
            return null;
        }
    }

    private void setConnectionPolicy(DevNode node) {
        node.setSocks5Proxy(this.dev.getSocks5Proxy());
        node.setSshForwardList(this.dev.getSshForwardList());
    }
}

