/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageINIParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageINIParser.class);
    private static final String PACKAGE_NAME_KEY = "package.name";
    private static final String VERSION_KEY = "package.version";
    private static final String PACKAGE_COMPRESSION = "package.compression";
    private static final String DATE_KEY = "date";
    private File iniFile;

    public PackageINIParser(File iniFile) {
        this.iniFile = iniFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsePackageConf(PackageConf packageConf) {
        if (!this.iniFile.exists() || this.iniFile.isDirectory()) {
            return;
        }
        InputStream is = null;
        Path path = this.iniFile.toPath();
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (!attr.isRegularFile()) {
                LOGGER.error("Not a regular file");
                return;
            }
            is = Files.newInputStream(path, new OpenOption[0]);
            Properties properties = new Properties();
            properties.load(is);
            packageConf.setFolder(properties.getProperty(PACKAGE_NAME_KEY));
            packageConf.setVersion(properties.getProperty(VERSION_KEY));
            packageConf.setCompression(properties.getProperty(PACKAGE_COMPRESSION));
            String dateString = properties.getProperty(DATE_KEY);
            if (!StringUtils.isNULLStr((String)dateString)) {
                Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateString);
                packageConf.setPublishDate(date);
            }
        }
        catch (Exception e) {
            LOGGER.error("no package.ini file!!!!", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    LOGGER.error("the inputStream is not closed!", (Throwable)e);
                }
            }
        }
    }
}

