/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infocollect.config.ConfigParser;
import com.huawei.ism.tool.infocollect.entity.PreCondition;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PreConditionParser
extends ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(PreConditionParser.class);
    private static final String CONDITION_NODE = "condition";
    private static final String SCRIPT_ATTRIBUTE = "file";
    private static final String EXECUTE_ATTRIBUTE = "method";
    private static final String REFER_ITEM_ID = "refer_item_id";
    private Element root;

    @Override
    public void init(File xmlFile) {
        if (xmlFile == null || !xmlFile.exists()) {
            log.info("precondition.xml is not exists.");
            return;
        }
        super.init(xmlFile);
        this.root = this.getDocument().getDocumentElement();
    }

    public List<PreCondition> parse() {
        if (!this.isInitResult()) {
            return null;
        }
        ArrayList<PreCondition> allPreConditions = new ArrayList<PreCondition>();
        try {
            Collection cliNodes = XmlUtils.getChildren((Element)this.root, (String)CONDITION_NODE);
            for (Element child : cliNodes) {
                PreCondition preCondition = new PreCondition();
                String script = child.getAttribute(SCRIPT_ATTRIBUTE);
                String method = child.getAttribute(EXECUTE_ATTRIBUTE);
                String referItemId = child.getAttribute(REFER_ITEM_ID);
                if (StringUtils.isNULLStr((String)script) || StringUtils.isNULLStr((String)referItemId)) {
                    log.info("Lack of necessary properties");
                    continue;
                }
                preCondition.setFileName(script);
                preCondition.setReferItemId(referItemId);
                if (!StringUtils.isNULLStr((String)method)) {
                    preCondition.setMethod(method);
                } else {
                    preCondition.setMethod(EXECUTE_ATTRIBUTE);
                }
                allPreConditions.add(preCondition);
            }
        }
        catch (RuntimeException e) {
            log.error("parse precondition.xml error!", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error("parse precondition.xml error!", (Throwable)e);
            return null;
        }
        return allPreConditions;
    }
}

