/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.infocollect.entity.command.ProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.SFTPProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.SshProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.TlvProtocolItem;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.StringUtils;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ProtocolParser {
    private static final String SFTP_NAME = "SFTP";
    private static final String SSH_NAME = "SSH";
    private static final String TLV_NAME = "TLV";

    public ProtocolItem parseProtocolItem(Element protocolElement) {
        try {
            String name = protocolElement.getAttribute("name");
            if (name.equals(SSH_NAME)) {
                return this.parseSSHProtocolItem(protocolElement);
            }
            if (name.equals(SFTP_NAME)) {
                return this.parseSFTPProtocolItem(protocolElement);
            }
            if (name.equals(TLV_NAME)) {
                return this.parseTlvProtocolItem(protocolElement);
            }
            return null;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ProtocolParser.class).error("parse protocolItem error!!!", (Throwable)e);
            return null;
        }
    }

    private SshProtocolItem parseSSHProtocolItem(Element protocolElement) {
        SshProtocolItem item = new SshProtocolItem();
        String portString = protocolElement.getAttribute("port");
        if (!StringUtils.isNULLStr((String)portString)) {
            item.setPort(Integer.parseInt(portString));
        }
        return item;
    }

    private SFTPProtocolItem parseSFTPProtocolItem(Element protocolElement) {
        SFTPProtocolItem item = new SFTPProtocolItem();
        String portString = protocolElement.getAttribute("port");
        if (!StringUtils.isNULLStr((String)portString)) {
            item.setPort(Integer.parseInt(portString));
        }
        String sftpUserName = protocolElement.getAttribute("tool_param");
        String sftpPwd = protocolElement.getAttribute("tool_config");
        if (!StringUtils.isNULLStr((String)sftpUserName)) {
            User user = new User(sftpUserName, sftpPwd);
            item.setUser(user);
        }
        return item;
    }

    private TlvProtocolItem parseTlvProtocolItem(Element protocolElement) {
        TlvProtocolItem item = new TlvProtocolItem();
        String portString = protocolElement.getAttribute("port");
        if (!StringUtils.isNULLStr((String)portString)) {
            item.setPort(Integer.parseInt(portString));
        }
        return item;
    }
}

