/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.infocollect.config.ConfigParser;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.SettingParserInfo;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SettingConfParser
extends ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(SettingConfParser.class);
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String TITLE = "title";
    private static final String FORMAT = "format";
    private static final String FILE = "file";
    private static final String METHOD = "method";
    private static final String SSH_KEY = "SSH";
    private SshConnection sshcon;
    private JythonExecuter executer;
    private String packageFolder = "";
    private DevNode devNode;
    private Boolean initSSHSucc = true;
    private Boolean initPy = true;

    public SettingConfParser(DevNode devNode) {
        this.devNode = devNode;
    }

    @Override
    public void init(File xmlFile) {
        this.packageFolder = xmlFile.getParentFile().toString();
        super.init(xmlFile);
    }

    public SettingConfInfo getSettingConfInfo() {
        ArrayList<SettingParserInfo> list = new ArrayList<SettingParserInfo>();
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        NodeList nodeList = this.getDocument().getElementsByTagName("item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element ele = (Element)nodeList.item(i);
            list.add(this.parserItemInfo(ele));
            String key = ele.getAttribute(KEY);
            keyMap.put(key, new Object());
            String value = ele.getAttribute(FORMAT);
            keyMap.put(key, value);
        }
        this.clearPyEnv();
        if (!this.initSSHSucc.booleanValue() || !this.initPy.booleanValue()) {
            return null;
        }
        SettingConfInfo conf = new SettingConfInfo();
        conf.setSettingInfo(keyMap);
        conf.setParserList(list);
        return conf;
    }

    private SettingParserInfo parserItemInfo(Element ele) {
        String method;
        SettingParserInfo info = new SettingParserInfo();
        info.setKey(ele.getAttribute(KEY));
        info.setType(ele.getAttribute(TYPE));
        info.setTitle(this.getRsesourceByKey(ele.getAttribute(TITLE)));
        info.setFormat(ele.getAttribute(FORMAT));
        String file = ele.getAttribute(FILE);
        if (StringUtils.isNULLStr((String)file)) {
            return info;
        }
        if (null == this.sshcon) {
            this.createPyEnv(new File(this.getAbsoluteScriptPath(file)).getParentFile());
        }
        if (StringUtils.isNULLStr((String)(method = ele.getAttribute(METHOD)))) {
            method = "execute";
        }
        if (this.needEnclosure() || InfoCollectUtil.isNewOceanStor9000(this.devNode)) {
            info.setNodesList(this.executePythonQueryNodes(this.getAbsoluteScriptPath(file), method));
            return info;
        }
        info.setResultList(this.executePython(this.getAbsoluteScriptPath(file), method));
        return info;
    }

    private void createPyEnv(File file2) {
        this.executer = new JythonExecuter(file2);
        try {
            this.sshcon = (SshConnection)SshConnectionManager.getSshConnection((DevNode)this.devNode, null, (boolean)true, (boolean)false);
        }
        catch (ToolException e) {
            this.initSSHSucc = false;
            log.error("create pyenv failed.", (Throwable)e);
        }
    }

    private void clearPyEnv() {
        if (null != this.sshcon) {
            this.sshcon.close();
        }
        if (null != this.executer) {
            this.executer.cleanup();
        }
    }

    private List<String> executePython(String absluteScriptPath, String method) {
        List result;
        try {
            HashMap<String, SshConnection> env = new HashMap<String, SshConnection>();
            env.put(SSH_KEY, this.sshcon);
            this.executer.compileScript(new File(absluteScriptPath));
            List pyResult = this.executer.invokeFunction(method, env);
            Boolean succ = Boolean.valueOf(pyResult.get(0).toString());
            if (!succ.booleanValue()) {
                this.initPy = false;
                return null;
            }
            Object obj = pyResult.get(1);
            result = (List)obj;
        }
        catch (RuntimeException e) {
            log.error("execute python failed. path = {}", (Object)absluteScriptPath, (Object)e);
            this.initPy = false;
            return null;
        }
        catch (Exception e) {
            log.error("execute python failed. path = {}", (Object)absluteScriptPath, (Object)e);
            this.initPy = false;
            return null;
        }
        return result;
    }

    private List<Map<String, String>> executePythonQueryNodes(String absluteScriptPath, String method) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(SSH_KEY, this.sshcon);
        env.put("logger", log);
        env.put("needEnclosure", true);
        env.put("result", result);
        try {
            File file = new File(absluteScriptPath);
            log.info("execute python path = {}", (Object)file.getName());
            this.executer.compileScript(file);
            List pyResult = this.executer.invokeFunction(method, env);
            boolean isSuccess = Boolean.parseBoolean(pyResult.get(0).toString());
            if (!isSuccess) {
                this.initPy = false;
            }
        }
        catch (Exception e) {
            log.error("execute python failed.", (Throwable)e);
            this.initPy = false;
        }
        return result;
    }

    private boolean needEnclosure() {
        return !this.devNode.isDsStorage() && InfoCollectUtil.isSupportCollectedByScene(this.devNode);
    }

    private String getAbsoluteScriptPath(String fileName) {
        return this.packageFolder + File.separator + "script" + File.separator + fileName;
    }
}

