/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.infocollect.config.ConfigParser;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.entity.ProductConf;
import com.huawei.ism.tool.infocollect.entity.SupportScene;
import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SysConfParser
extends ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(SysConfParser.class);
    private static final String PACKAGE_NODE_NAME = "package";
    private static final String VERSIONS_NODE_NAME = "supportLogic";
    private static final String VERSION_NODE_NAME = "type";
    private static final String PRODUCTS_NODE_NAME = "products";
    private static final String PRODUCT_NODE_NAME = "product";
    private static final String PRODUCTS_FOLDER = ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "collect" + File.separator + "products";

    public PackageConf getPackageConfig() {
        if (!this.isInitResult()) {
            return null;
        }
        try {
            PackageConf packageConfig = new PackageConf("");
            String folder = null;
            Element root = this.getDocument().getDocumentElement();
            NodeList packageList = root.getElementsByTagName(PACKAGE_NODE_NAME);
            if (packageList.getLength() != 0) {
                Element packageElement = (Element)packageList.item(0);
                packageConfig = new PackageConf(this.getElementContent(packageElement, "name"));
                packageConfig.setVersion(this.getElementContent(packageElement, "version"));
                folder = this.getElementContent(packageElement, "folder");
                if (StringUtils.isNULLStr((String)folder)) {
                    folder = packageConfig.getName();
                }
                packageConfig.setFolder(folder);
                String dataString = this.getElementContent(packageElement, "date");
                if (!StringUtils.isNULLStr((String)dataString)) {
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                    packageConfig.setPublishDate(dateformat.parse(dataString));
                }
            }
            packageConfig.setVersionConfigs(this.parseVersionConfigurations(root, folder));
            packageConfig.setProductConfigs(this.getProductConfigurations(root));
            return packageConfig;
        }
        catch (RuntimeException e) {
            log.error("parse package config error!", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error("parse package config error!", (Throwable)e);
            return null;
        }
    }

    private List<SupportVersionConf> parseVersionConfigurations(Element rootNode, String folder) throws IOException {
        ArrayList<SupportVersionConf> versionConfigurations = new ArrayList<SupportVersionConf>();
        NodeList nodeList = null;
        Element parentNode = (Element)rootNode.getElementsByTagName(VERSIONS_NODE_NAME).item(0);
        if (null != parentNode) {
            nodeList = parentNode.getElementsByTagName(VERSION_NODE_NAME);
            int length = nodeList.getLength();
            for (int index = 0; index < length; ++index) {
                Node node = nodeList.item(index);
                Element element = (Element)node;
                try {
                    SupportVersionConf versionConfig = new SupportVersionConf();
                    String scriptName = XmlUtils.getAttribute((Element)parentNode, (String)"script");
                    versionConfig.setScript(PRODUCTS_FOLDER + File.separator + folder + File.separator + scriptName);
                    versionConfig.setModel(XmlUtils.getAttribute((Element)element, (String)"name"));
                    versionConfig.setVersion(XmlUtils.getAttribute((Element)element, (String)"version"));
                    versionConfig.setDescZh(XmlUtils.getAttribute((Element)element, (String)"descZh"));
                    versionConfig.setDescEn(XmlUtils.getAttribute((Element)element, (String)"descEn"));
                    versionConfigurations.add(versionConfig);
                    continue;
                }
                catch (RuntimeException e) {
                    log.error("xml parse error,the element is:{}", (Object)element, (Object)e);
                    return null;
                }
                catch (Exception e) {
                    log.error("xml parse error,the element is:{}", (Object)element, (Object)e);
                    return null;
                }
            }
        }
        return versionConfigurations;
    }

    private List<ProductConf> getProductConfigurations(Element rootNode) throws IOException {
        NodeList nodeList = null;
        int length = 0;
        Element productsNode = (Element)rootNode.getElementsByTagName(PRODUCTS_NODE_NAME).item(0);
        nodeList = productsNode.getElementsByTagName(PRODUCT_NODE_NAME);
        length = nodeList.getLength();
        ArrayList<ProductConf> productConfigurations = new ArrayList<ProductConf>();
        for (int index = 0; index < length; ++index) {
            Node node = nodeList.item(index);
            ProductConf productConfig = this.parseProductionConfiguration((Element)node);
            if (productConfig == null) continue;
            productConfigurations.add(productConfig);
        }
        return productConfigurations;
    }

    private ProductConf parseProductionConfiguration(Element element) {
        try {
            ProductConf productConfig = new ProductConf();
            productConfig.setProductName(this.getElementContent(element, "productname"));
            productConfig.setShowVersion(this.getElementContent(element, "showVersion"));
            String versionStrings = this.getElementContent(element, "supporttypes");
            ArrayList<String> versions = new ArrayList<String>();
            versions.addAll(Arrays.asList(versionStrings.split(",")));
            productConfig.setVersions(versions);
            String shutdownHook = this.getElementContent(element, "shutdownHook");
            productConfig.setShutdownHook(shutdownHook);
            String privateCollectListStr = this.getElementContent(element, "privateCollectList");
            for (String version : versions) {
                String devTypeTmp = productConfig.getProductName() + " " + version;
                if (privateCollectListStr.isEmpty()) continue;
                productConfig.getPrivateCollectListMap().put(devTypeTmp, privateCollectListStr);
            }
            Element childElement = XmlUtils.getChild((Element)element, (String)"supporttypes");
            String excludeTypes = XmlUtils.getAttribute((Element)childElement, (String)"exclude");
            if (!StringUtils.isNULLStr((String)excludeTypes)) {
                ArrayList<String> excludeVersions = new ArrayList<String>();
                excludeVersions.addAll(Arrays.asList(excludeTypes.split(",")));
                productConfig.setExcludeVersions(excludeVersions);
            }
            productConfig.setSupportScenes(this.parseSupportList(element));
            return productConfig;
        }
        catch (Exception e) {
            log.error("xml parse error,the element is:{}", (Object)element, (Object)e);
            return null;
        }
    }

    private List<SupportScene> parseSupportList(Element element) {
        ArrayList<SupportScene> supportScenes = new ArrayList<SupportScene>();
        Collection supportLists = XmlUtils.getChildren((Element)element, (String)"supportList");
        if (supportLists.isEmpty()) {
            return supportScenes;
        }
        for (Element supportLis : supportLists) {
            SupportScene supportscene = new SupportScene();
            Element supportScene = XmlUtils.getChild((Element)supportLis, (String)"supportscene");
            String field = XmlUtils.getChild((Element)supportScene, (String)"field").getTextContent();
            supportscene.setField(field);
            String mainScene = XmlUtils.getChild((Element)supportScene, (String)"mainScene").getTextContent();
            supportscene.setMainScene(mainScene);
            String subScene = XmlUtils.getChild((Element)supportScene, (String)"subScene").getTextContent();
            supportscene.setSubScene(subScene);
            String checklist = XmlUtils.getChild((Element)supportScene, (String)"checklist").getTextContent();
            supportscene.setChecklist(checklist);
            Element fcvList = XmlUtils.getChild((Element)supportScene, (String)"fcvList");
            supportscene.setFcvList(fcvList != null ? fcvList.getTextContent() : "");
            supportScenes.add(supportscene);
        }
        return supportScenes;
    }

    private String getElementContent(Element parent, String elementName) {
        NodeList nodeList = parent.getElementsByTagName(elementName);
        if (nodeList.getLength() == 0) {
            return "";
        }
        return nodeList.item(0).getTextContent();
    }
}

