/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.config;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlParser {
    private static final Logger log = LoggerFactory.getLogger(YamlParser.class);
    private static final String INSPECT_COLLECT_CONFIG_PATH = Stream.of(ApplicationContext.getInstance().getWorkPath(), "packages", "collect", "products", "DStorageExtend", "inspect_collect.yaml").collect(Collectors.joining(File.separator));
    private static volatile YamlParser instance;
    private Map<String, List<String>> collectItems = new HashMap<String, List<String>>();

    private YamlParser() {
        this.initInspectCollectItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YamlParser getInstance() {
        if (instance != null) return instance;
        Class<YamlParser> clazz = YamlParser.class;
        synchronized (YamlParser.class) {
            if (instance != null) return instance;
            instance = new YamlParser();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initInspectCollectItems() {
        try (FileInputStream fis = new FileInputStream(INSPECT_COLLECT_CONFIG_PATH);){
            Yaml yamlConfig = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            this.collectItems = (Map)yamlConfig.load((InputStream)fis);
        }
        catch (IOException e) {
            log.error("Parse config error.");
        }
    }

    public List<String> getItemsById(String moduleId) {
        return this.collectItems.getOrDefault(moduleId, Collections.emptyList());
    }
}

