/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.dpc.service;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.infocollect.dpc.entity.ConfigParam;
import com.huawei.ism.tool.infocollect.dpc.entity.ConfigProgressResponse;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcErrorResponse;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcQueryNodesParam;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcStartCollectParam;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcsResponse;
import com.huawei.ism.tool.infocollect.dpc.entity.TaskDetail;
import com.huawei.ism.tool.infocollect.dpc.entity.TaskIdResponse;
import com.huawei.ism.tool.infocollect.dpc.enums.DpcRestResponseCode;
import com.huawei.ism.tool.infocollect.dpc.service.CollectException;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectRestApi;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpcCollectConvertService {
    private static final Logger log = LoggerFactory.getLogger(DpcCollectConvertService.class);
    private static final DpcCollectConvertService CONVERT_SERVICE = new DpcCollectConvertService();

    public static DpcCollectConvertService getInstance() {
        return CONVERT_SERVICE;
    }

    public DpcsResponse queryDpcNodes(AiDevNode aiDevNode, DpcQueryNodesParam queryNodesParam) throws ToolException {
        ResponseInfo responseInfo = DpcCollectRestApi.queryDpcNodes(aiDevNode, queryNodesParam);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine()) || responseInfo.getStatusLine().getStatusCode() != DpcRestResponseCode.QUERY_DOWNLOAD_SUCCESS.getCode()) {
            log.error("query dpc nodes fail for dme ip:{}", (Object)aiDevNode.getIp());
            throw new ToolException("query dpc nodes fail");
        }
        return (DpcsResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcsResponse.class);
    }

    public TaskIdResponse startCollectJob(AiDevNode aiDevNode, DpcStartCollectParam param) throws ToolException, CollectException {
        ResponseInfo responseInfo = DpcCollectRestApi.startCollectJob(aiDevNode, param);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("responseInfo is null or statusLine is null.");
            throw new ToolException("Start dpc collect job fail.");
        }
        if (responseInfo.getStatusLine().getStatusCode() == DpcRestResponseCode.ACTION_FAIL.getCode()) {
            log.error("Start dpc collect job fail because the DPC log file is being collected or downloaded.");
            DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
            throw new CollectException(responseInfo.getStatusLine().getStatusCode(), dpcError.getErrorCode(), ResourceUtil.getString((String)"dpc.collect.request.is.collecting.error"));
        }
        if (responseInfo.getStatusLine().getStatusCode() != DpcRestResponseCode.START_JOB_SUCCESS.getCode()) {
            DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
            log.error("start dpc collect job fail for dme ip:{}, dpc ids:{}, error_code:{}, error_msg:{}", new Object[]{aiDevNode.getIp(), param.getDpcIps(), dpcError.getErrorCode(), dpcError.getErrorMsg()});
            throw new CollectException(responseInfo.getStatusLine().getStatusCode(), dpcError.getErrorCode(), dpcError.getErrorMsg());
        }
        log.info("start dpc collect job success for dme ip:{},dpc ids:{}", (Object)aiDevNode.getIp(), param.getDpcIps());
        return (TaskIdResponse)JSONObject.parseObject((String)responseInfo.getContent(), TaskIdResponse.class);
    }

    public List<TaskDetail> queryCollectJobDetail(AiDevNode aiDevNode, String taskId) throws ToolException, CollectException {
        ResponseInfo responseInfo = DpcCollectRestApi.queryCollectJobDetail(aiDevNode, taskId);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("responseInfo is null or statusLine is null.");
            throw new ToolException("Query dpc collect job detail fail.");
        }
        if (responseInfo.getStatusLine().getStatusCode() != DpcRestResponseCode.QUERY_DOWNLOAD_SUCCESS.getCode()) {
            DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
            log.error("Query dpc collect job detail fail for dme ip:{}, taskId:{}", (Object)aiDevNode.getIp(), (Object)taskId);
            throw new CollectException(responseInfo.getStatusLine().getStatusCode(), dpcError.getErrorCode(), dpcError.getErrorMsg());
        }
        log.info("Query dpc collect job detail success for dme ip:{}, taskId:{}", (Object)aiDevNode.getIp(), (Object)taskId);
        return JSONObject.parseArray((String)responseInfo.getContent(), TaskDetail.class);
    }

    public boolean downloadCollectFile(AiDevNode aiDevNode, String taskId, String downloadDir) throws ToolException, CollectException {
        ResponseInfo responseInfo = DpcCollectRestApi.downloadCollectFile(aiDevNode, taskId, downloadDir);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("responseInfo is null or statusLine is null.");
            throw new ToolException("Download dpc collect file fail.");
        }
        if (responseInfo.getStatusLine().getStatusCode() == DpcRestResponseCode.ACTION_FAIL.getCode()) {
            log.error("Download dpc collect file fail because the DPC log file is being collected or downloaded.");
            DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
            throw new CollectException(responseInfo.getStatusLine().getStatusCode(), dpcError.getErrorCode(), ResourceUtil.getString((String)"dpc.collect.request.is.collecting.error"));
        }
        if (responseInfo.getStatusLine().getStatusCode() != DpcRestResponseCode.QUERY_DOWNLOAD_SUCCESS.getCode()) {
            DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
            log.error("download dpc collect file fail for dme ip:{},taskId:{}", (Object)aiDevNode.getIp(), (Object)taskId);
            throw new CollectException(responseInfo.getStatusLine().getStatusCode(), dpcError.getErrorCode(), dpcError.getErrorMsg());
        }
        log.info("download dpc collect file success for dme ip:{},taskId:{}", (Object)aiDevNode.getIp(), (Object)taskId);
        return true;
    }

    public boolean packConfig(AiDevNode aiDevNode, ConfigParam param) throws ToolException, CollectException {
        ResponseInfo responseInfo = DpcCollectRestApi.packConfig(aiDevNode, param);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is returned when the config file collection task is created.");
            throw new ToolException("Failed to pack the config file.");
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == DpcRestResponseCode.QUERY_DOWNLOAD_SUCCESS.getCode()) {
            log.info("The task for collecting config files is created successfully.");
            return true;
        }
        DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
        if (statusCode == DpcRestResponseCode.ACTION_FAIL.getCode()) {
            log.error("A config file collection task is being executed. Status code is :{}.", (Object)statusCode);
            throw new CollectException(statusCode, dpcError.getErrorCode(), dpcError.getErrorMsg());
        }
        log.error("Failed to create the task for collecting the config file. Status code is :{}.", (Object)statusCode);
        throw new CollectException(statusCode, dpcError.getErrorCode(), dpcError.getErrorMsg());
    }

    public ConfigProgressResponse queryConfigTask(AiDevNode aiDevNode, ConfigParam param) throws ToolException, CollectException {
        ResponseInfo responseInfo = DpcCollectRestApi.queryConfigTask(aiDevNode, param);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("No response is returned when you query the configuration file collection progress.");
            throw new ToolException("Failed to query the packing progress of the config file.");
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == DpcRestResponseCode.QUERY_DOWNLOAD_SUCCESS.getCode()) {
            log.info("Succeeded in querying the configuration file collection progress.");
            return (ConfigProgressResponse)JSONObject.parseObject((String)responseInfo.getContent(), ConfigProgressResponse.class);
        }
        DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
        if (statusCode == DpcRestResponseCode.FAILED.getCode()) {
            log.error("The configuration file collection task does not exist. Status code is :{}.", (Object)statusCode);
            throw new CollectException(statusCode, dpcError.getErrorCode(), dpcError.getErrorMsg());
        }
        log.error("Failed to query the configuration file collection progress. Status code is :{}.", (Object)statusCode);
        throw new CollectException(statusCode, dpcError.getErrorCode(), dpcError.getErrorMsg());
    }

    public boolean downloadConfig(AiDevNode aiDevNode, ConfigParam param, String downloadDir) throws ToolException, CollectException {
        ResponseInfo responseInfo = DpcCollectRestApi.downloadConfig(aiDevNode, param, downloadDir);
        if (Objects.isNull(responseInfo) || Objects.isNull(responseInfo.getStatusLine())) {
            log.error("Failed to downloThe system does not respond when downloading the configuration file.");
            throw new ToolException("Failed to download the packing progress of the config file.");
        }
        int statusCode = responseInfo.getStatusLine().getStatusCode();
        if (statusCode == DpcRestResponseCode.QUERY_DOWNLOAD_SUCCESS.getCode()) {
            log.info("The configuration file is downloaded successfully.");
            return true;
        }
        DpcErrorResponse dpcError = (DpcErrorResponse)JSONObject.parseObject((String)responseInfo.getContent(), DpcErrorResponse.class);
        if (statusCode == DpcRestResponseCode.COLLECTION_NOT_COMPLETED.getCode()) {
            log.error("The configuration file collection task does not exist. Status code is :{}.", (Object)statusCode);
            throw new CollectException(statusCode, dpcError.getErrorCode(), dpcError.getErrorMsg());
        }
        log.error("Failed to download the configuration file. Status code is :{}.", (Object)statusCode);
        throw new CollectException(statusCode, dpcError.getErrorCode(), dpcError.getErrorMsg());
    }

    private DpcCollectConvertService() {
    }
}

