/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.dpc.service;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.infocollect.dpc.entity.ConfigParam;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcQueryNodesParam;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcStartCollectParam;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DpcCollectRestApi {
    private static final String SELECT_DPC_NODES_URL = "%s/rest/dpc-mgmt/v1/dpcs/query";
    private static final String START_COLLECT_JOB_URL = "%s/rest/dpc-mgmt/v1/dpc-logs/collect";
    private static final String QUERY_COLLECT_DETAIL_URL = "%s/rest/taskmgmt/v1/tasks/%s";
    private static final String DOWNLOAD_COLLECT_FILE_URL = "%s/rest/dpc-mgmt/v1/dpc-logs/download?task_id=%s";
    private static final String PACK_CONFIG_URL = "%s/rest/storagemgmt/v1/storage-config/collection-task";
    private static final String DOWNLOAD_CONFIG_URL = "%s/rest/storagemgmt/v1/storage-config/download";

    public static ResponseInfo queryDpcNodes(AiDevNode aiDevNode, DpcQueryNodesParam queryNodesParam) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        String url = String.format(SELECT_DPC_NODES_URL, RestUtil.getBaseUri((DevNode)aiDevNode));
        return queryNodesParam == null ? restConnection.execPost(url, "") : restConnection.execPost(url, JSON.toJSONString((Object)queryNodesParam));
    }

    public static ResponseInfo startCollectJob(AiDevNode aiDevNode, DpcStartCollectParam startParam) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        String url = String.format(START_COLLECT_JOB_URL, RestUtil.getBaseUri((DevNode)aiDevNode));
        return restConnection.execPost(url, JSON.toJSONString((Object)startParam));
    }

    public static ResponseInfo queryCollectJobDetail(AiDevNode aiDevNode, String taskId) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        String url = String.format(QUERY_COLLECT_DETAIL_URL, RestUtil.getBaseUri((DevNode)aiDevNode), taskId);
        return restConnection.execGet(url);
    }

    public static ResponseInfo downloadCollectFile(AiDevNode aiDevNode, String taskId, String downloadDir) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        String url = String.format(DOWNLOAD_COLLECT_FILE_URL, RestUtil.getBaseUri((DevNode)aiDevNode), taskId);
        return restConnection.execGetFile(url, Collections.emptyMap(), downloadDir);
    }

    public static ResponseInfo packConfig(AiDevNode aiDevNode, ConfigParam param) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        String url = String.format(PACK_CONFIG_URL, RestUtil.getBaseUri((DevNode)aiDevNode));
        return restConnection.execPost(url, JSON.toJSONString((Object)param));
    }

    public static ResponseInfo queryConfigTask(AiDevNode aiDevNode, ConfigParam param) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        String url = String.format(PACK_CONFIG_URL, RestUtil.getBaseUri((DevNode)aiDevNode));
        return restConnection.execGet(url, JSON.toJSONString((Object)param));
    }

    public static ResponseInfo downloadConfig(AiDevNode aiDevNode, ConfigParam param, String downloadDir) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)aiDevNode);
        String url = String.format(DOWNLOAD_CONFIG_URL, RestUtil.getBaseUri((DevNode)aiDevNode));
        return restConnection.execGetFile(url, DpcCollectRestApi.getParam(param), downloadDir);
    }

    private static Map<String, String> getParam(ConfigParam configParam) {
        String storageId;
        HashMap<String, String> reqParam = new HashMap<String, String>();
        String storageSn = configParam.getStorageSn();
        if (!StringUtils.isNULLStr((String)storageSn)) {
            reqParam.put("storage_sn", storageSn);
        }
        if (!StringUtils.isNULLStr((String)(storageId = configParam.getStorageId()))) {
            reqParam.put("storage_id", storageId);
        }
        return reqParam;
    }
}

