/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.dpc.service;

import com.google.common.collect.Lists;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcClusterNode;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcStartCollectParam;
import com.huawei.ism.tool.infocollect.dpc.entity.TaskDetail;
import com.huawei.ism.tool.infocollect.dpc.enums.TaskDetailStatus;
import com.huawei.ism.tool.infocollect.dpc.service.CollectException;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectConvertService;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectUtil;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResultUtils;
import com.huawei.ism.tool.infocollect.interf.ICollectTask;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.infocollect.service.logic.command.ClearCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.DescCommand;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboUtil;
import com.huawei.ism.tool.infocollect.util.FilesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONObject;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.ThreadUtils;

public class DpcCollectTask
implements ICollectTask {
    private static final Logger log = LoggerFactory.getLogger(DpcCollectTask.class);
    private static final int QUERY_TASK_SLEEP_SECONDS = 5;
    private static final int MAX_ONE_BATCH_COLLECT_NODE_SIZE = 10;
    private static final long QUERY_DETAIL_OVERTIME_MILLS = TimeUnit.MINUTES.toMillis(90L);
    private static final String PACKAGE_INFO = "pkginfo";
    private static final String LOG = "log";
    private static final String DATA_COLLECT = "DataCollect";
    private static final int BUFFER_SIZE = 5120;
    private DpcCollectConvertService convertService = DpcCollectConvertService.getInstance();
    private AiDevNode aiDevNode;
    private DpcCollectNode dpcCollectNode;
    private final DevNode devNode;
    private final CollectInfo collectInfo;
    private UIProgressObserver uiProgress;
    private String collectRetDir;
    private CollectItem dpcItem;
    private boolean allSuccess = true;
    private CollectStatus nowStatus = CollectStatus.COLLECTING;
    private int totalBatch;
    private int successBatch;
    private int failBatch;
    private int partSuccessBatch;
    private String collectTimePath;
    private StringJoiner errorMsg = new StringJoiner(System.lineSeparator());

    public DpcCollectTask(CollectInfo collectInfo, DevNode devNode) {
        this.collectInfo = collectInfo;
        this.devNode = devNode;
        this.uiProgress = new UIProgressObserver(devNode);
    }

    @Override
    public boolean init() {
        ExecuteResult result = ExecuteResultUtils.newExeResult(2, null, ResourceUtil.getString((String)"infocollect.detail.check.set.command"));
        if (Objects.isNull(this.devNode)) {
            log.error("Init dpc collect task error. DataTurbo devNode is null.");
            result.setResult(false);
            return false;
        }
        Optional<AiDevNode> aiDevNodeOpt = DpcCollectUtil.getAiDevNode(this.devNode);
        if (!aiDevNodeOpt.isPresent()) {
            log.error("Init dpc collect task error. AiDevNode is null.");
            result.setResult(false);
            return false;
        }
        this.aiDevNode = aiDevNodeOpt.get();
        DpcCollectNode dpcNode = CollectDataContext.getInstance().getCollectNodeMap().get(this.devNode.getIp());
        if (Objects.isNull(dpcNode) || !dpcNode.isSetFinish()) {
            log.error("Init dpc collect task error. DpcCollectNode is null or not set.");
            result.setResult(false);
            return false;
        }
        if (!this.checkCollectInfo(result)) {
            return false;
        }
        this.dpcCollectNode = dpcNode;
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        this.observeExecuteResult(result);
        this.collectInfo.setCollecting();
        return true;
    }

    private boolean checkCollectInfo(ExecuteResult result) {
        if (Objects.isNull(this.collectInfo) || Objects.isNull(this.collectInfo.getCollectConfInfo()) || Objects.isNull(this.collectInfo.getCollectConfInfo().getSelectItems())) {
            log.error("Init dpc collect task error. collectInfo is null.");
            result.setResult(false);
            return false;
        }
        Optional<CollectItem> collectItem = this.collectInfo.getCollectConfInfo().getSelectItems().stream().filter(item -> item.getId().equals("dpc_log")).findFirst();
        if (!collectItem.isPresent()) {
            log.error("collect dpc log item is null.");
            result.setResult(false);
            return false;
        }
        this.dpcItem = collectItem.get();
        return true;
    }

    private void observeExecuteResult(ExecuteResult result) {
        if (Objects.isNull(result)) {
            return;
        }
        result.setDevNode(this.devNode);
        CollectDataContext.getInstance().getCollectInfo(this.devNode).addExecuteResult(result);
        CollectDataContext.getInstance().getIuiCallBack().uiCallBack(this.devNode);
    }

    @Override
    public JSONObject getFailedMsg() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean collectResult = true;
        boolean createCollectEnvResult = true;
        CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(false);
        try {
            ExecuteResult initEnvResult = this.initCollectEnv();
            if (!initEnvResult.isSuccess()) {
                log.error("Init dpc collect task environment failed.");
                createCollectEnvResult = false;
                this.observeExecuteResult(initEnvResult);
                return;
            }
            this.doCollect();
            collectResult = this.successBatch != 0 || this.partSuccessBatch != 0;
        }
        catch (Exception e) {
            log.error("execute dpc collect error.", (Throwable)e);
            ExecuteResult result = this.createExecuteResult(false, ResourceUtil.getString((String)"infocollect.detail.postCollect"), CollectStatus.COLLECT_FAILED);
            result.setDetail(ResourceUtil.getString((String)"infocollect.detail.postCollect.remind"));
            this.observeExecuteResult(result);
            this.nowStatus = CollectStatus.COLLECT_FAILED;
        }
        finally {
            this.doCleanJob(createCollectEnvResult, collectResult);
            CollectDataContext.getInstance().getCollectNodeMap().put(this.devNode.getIp(), this.dpcCollectNode);
            if (CollectUIContext.getInstance().getMainDialog() != null) {
                CollectUIContext.getInstance().getMainDialog().getThreads().remove(this.devNode.getDeviceSerialNumber());
            }
        }
    }

    void doCollect() {
        ExecuteResult result = this.createExecuteResult(null, this.dpcItem.getNameKey(), CollectStatus.COLLECTING);
        int devProgress = 10;
        result.setProgress(devProgress);
        result.setSingleProgress(5);
        this.observeExecuteResult(result);
        List dpcPartitions = Lists.partition(DataTurboUtil.dpcSelectNodes(this.dpcCollectNode), (int)10);
        this.totalBatch = dpcPartitions.size();
        log.info("start to dpc collect job,total batch number is:{}", (Object)dpcPartitions.size());
        this.createCollectTimeDir();
        for (int i = 0; i < dpcPartitions.size(); ++i) {
            this.executeCollect(dpcPartitions, i);
            this.uiProgress.updateProgress(5 + 90 / this.totalBatch * (i + 1), "");
            devProgress = this.getDevProgress(i + 1, devProgress);
            CollectDataContext.getInstance().getIuiCallBack().upgradeProgress(this.devNode, devProgress);
        }
        this.handleDpcLogResult(result);
        this.compressResultFile();
    }

    private int getDevProgress(int batch, int currentProgress) {
        int progress = 10 + 80 / this.totalBatch * batch;
        return Math.max(progress, currentProgress);
    }

    private void handleDpcLogResult(ExecuteResult result) {
        this.failBatch = this.totalBatch - this.successBatch - this.partSuccessBatch;
        this.allSuccess = this.successBatch == this.totalBatch;
        log.info("failBatch is {}, successBatch is {}, partSuccessBatch is {}", new Object[]{this.failBatch, this.successBatch, this.totalBatch});
        if (this.failBatch == this.totalBatch || this.successBatch == 0 && this.partSuccessBatch == 0) {
            result.setResult(false);
            result.setNowStatus(CollectStatus.COLLECT_FAILED);
            result.setDetail(this.errorMsg.toString());
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            log.error("collect dpc task failed.");
        } else {
            this.nowStatus = CollectStatus.COLLECT_FINISHED;
            result.setResult(true);
            if (this.successBatch == this.totalBatch) {
                result.setNowStatus(CollectStatus.COLLECT_FINISHED);
                result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
                log.info("collect dpc task success.");
            } else {
                result.setCollectAllInfo(false);
                result.setNowStatus(CollectStatus.COLLECT_FINISHED_NOTALL);
                result.setDetail(this.errorMsg.toString());
                log.warn("collect dpc task part success.");
            }
        }
        result.setProgress(90);
        this.observeExecuteResult(result);
    }

    void compressResultFile() {
        ExecuteResult result = this.addCompressDetail();
        this.createPkginfoDir();
        this.createLogDir();
        this.executeCompress(result);
    }

    private ExecuteResult addCompressDetail() {
        ExecuteResult result = this.createExecuteResult(null, ResourceUtil.getString((String)"infocollect.detail.compressed.file"), CollectStatus.COLLECTING);
        result.setProgress(95);
        result.setSingleProgress(10);
        this.observeExecuteResult(result);
        return result;
    }

    private void executeCompress(ExecuteResult result) {
        String compressFileName = this.collectTimePath + ".7z";
        String dataCollectPath = String.join((CharSequence)File.separator, this.collectTimePath, DATA_COLLECT);
        String pkginfoPath = String.join((CharSequence)File.separator, this.collectTimePath, PACKAGE_INFO);
        String logPath = String.join((CharSequence)File.separator, this.collectTimePath, LOG);
        boolean compressResult = FileAssistant.compressFile7zByMX0((String)compressFileName, (String[])new String[]{dataCollectPath, pkginfoPath, logPath});
        log.info("execute compress file result is:{}", (Object)compressResult);
        File compressFile = new File(compressFileName);
        if (compressResult && compressFile.exists() && compressFile.isFile()) {
            FilesUtil.deleteFileAfterReleased(new File(this.collectTimePath), TimeUnit.MINUTES.toMillis(1L));
            result.setResult(true);
            result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        } else {
            result.setResult(false);
            result.setNowStatus(CollectStatus.COLLECT_FAILED);
            result.setDetail(ResourceUtil.getString((String)"infocollect.detail.compressed.file.failed"));
            this.nowStatus = CollectStatus.COLLECT_FAILED;
        }
    }

    private void createLogDir() {
        String logInfoPath = String.join((CharSequence)File.separator, this.collectTimePath, LOG);
        File logInfoDir = new File(logInfoPath);
        if (!logInfoDir.exists() && !logInfoDir.mkdirs()) {
            log.error("Create log directory fail. fail path is {}", (Object)logInfoPath);
            return;
        }
        if (AbstractUserOpDataSev.isSourceLogExists()) {
            AbstractUserOpDataSev.copyLogInfo((File)logInfoDir);
        }
        this.createDpcNodesInfoFile(logInfoPath);
    }

    private void createDpcNodesInfoFile(String logInfoPath) {
        String filePath = String.join((CharSequence)File.separator, logInfoPath, "dpc_nodes_info.text");
        this.dpcCollectNode.getDpcClusterNodes().forEach(node -> DataTurboUtil.writeDpcNodeInfo(filePath, node));
    }

    private void createPkginfoDir() {
        String pkginfoPath = String.join((CharSequence)File.separator, this.collectTimePath, PACKAGE_INFO);
        File pkginfo = new File(pkginfoPath);
        if (!pkginfo.exists() && pkginfo.mkdirs()) {
            this.createDescFile(pkginfo);
            InfoCollectUtil.copyToolIni(pkginfoPath);
        }
    }

    private void createDescFile(File pkginfo) {
        File descFile = new File(pkginfo, "desc");
        try (BufferedWriter csvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(descFile), StandardCharsets.UTF_8), 5120);){
            descFile.createNewFile();
            csvWriter.write("deviceSN=${" + this.aiDevNode.getDeviceSerialNumber() + "}");
            csvWriter.newLine();
            csvWriter.write("fileCreateTime=" + new Date().getTime());
            csvWriter.newLine();
            csvWriter.write("tool-version={" + String.join((CharSequence)"\n", UserOpDataSaveUtil.getAllToolVersion()) + "}");
            csvWriter.newLine();
            csvWriter.flush();
        }
        catch (IOException e) {
            log.error("Create pkginfo desc file error .", (Throwable)e);
        }
    }

    void createCollectTimeDir() {
        File dataCollectDir;
        this.collectTimePath = String.join((CharSequence)File.separator, this.collectRetDir, String.join((CharSequence)"_", "Data", this.devNode.getProductModel(), String.valueOf(new Date().getTime())));
        File collectTimeDir = new File(this.collectTimePath);
        if (!collectTimeDir.exists()) {
            log.info("start to create collect time directory.");
            collectTimeDir.mkdirs();
        }
        if (!(dataCollectDir = new File(String.join((CharSequence)File.separator, this.collectTimePath, DATA_COLLECT))).exists()) {
            log.info("start to create DataCollect directory.");
            dataCollectDir.mkdirs();
        }
    }

    private void dealWithCount(TaskDetailStatus queryStatus, boolean downloadResult, List<String> dpcIps) {
        if (!downloadResult) {
            return;
        }
        this.dpcCollectNode.getDpcClusterNodes().stream().filter(dpc -> dpcIps.contains(dpc.getManagementIp())).forEach(dpc -> dpc.setCollected(true));
        if (queryStatus == TaskDetailStatus.SUCCESS) {
            ++this.successBatch;
        } else {
            ++this.partSuccessBatch;
        }
    }

    ExecuteResult initCollectEnv() {
        ExecuteResult result = this.createExecuteResult(null, ResourceUtil.getString((String)"infocollect.detail.initenv"), CollectStatus.COLLECTING);
        result.setProgress(5);
        this.observeExecuteResult(result);
        if (!CollectDataContext.getInstance().isStartCollect()) {
            result.setResult(false);
            return result;
        }
        if (Utils.isNullList(this.dpcCollectNode.getDpcClusterNodes()) || Utils.isNullList(DataTurboUtil.dpcSelectNodes(this.dpcCollectNode))) {
            log.error("select dpc node is empty, dev ip is {}", (Object)this.devNode.getIp());
            result.setDetail(ResourceUtil.getString((String)"infocollect.detail.init.set.node.error"));
            result.setResult(false);
            return result;
        }
        File file = new File(InfoCollectUtil.getDevCollectDir(this.devNode));
        log.info("dpc collect task save path is {}", (Object)utils.FilesUtil.getCanonicalPath((File)file));
        if (!file.exists() && !file.mkdirs()) {
            log.error("create target folder error!");
            result.setResult(false);
            result.setDetail(ResourceUtil.getString((String)"infocollect.error.infocollect.init.error2"));
            return result;
        }
        this.collectRetDir = utils.FilesUtil.getCanonicalPath((File)file);
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        return result;
    }

    void doCleanJob(boolean createCollectEnvResult, boolean collectResult) {
        if (!CollectDataContext.getInstance().isStartCollect()) {
            log.info("The collection has stopped.");
            return;
        }
        RestConnectionManager.releaseConn((DevNode)this.aiDevNode);
        ClearCollectEnvCommand command = new ClearCollectEnvCommand(this.collectInfo.getDevNode(), this.collectInfo);
        ExecuteResult result = command.process();
        this.observeExecuteResult(result);
        DescCommand descCommand = new DescCommand(ResourceUtil.getString((String)"lld.collect.finished"), createCollectEnvResult && collectResult, this.collectInfo, Color.RED);
        result = descCommand.process();
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        if (CollectStatus.COLLECT_FINISHED.equals((Object)this.nowStatus) && !this.allSuccess) {
            this.nowStatus = CollectStatus.COLLECT_FINISHED_NOTALL;
        }
        result.setNowStatus(this.nowStatus);
        log.info("dpc collect finished.");
        CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(true);
        this.observeExecuteResult(result);
    }

    private ExecuteResult createExecuteResult(Boolean isSuccess, String desString, CollectStatus status) {
        ExecuteResult result = new ExecuteResult();
        result.setResult(isSuccess);
        result.setNowStatus(status);
        result.setDescription(desString);
        return result;
    }

    private void executeCollect(List<List<DpcClusterNode>> dpcPartitions, int index) {
        int currentBatch = index + 1;
        List<String> currentBatchIps = this.getCurrentBatchIps(dpcPartitions, index);
        StringBuilder currentErrorBuilder = new StringBuilder();
        try {
            String taskId = this.startCollectJob(this.aiDevNode, currentBatchIps, this.dpcCollectNode.getBeginTimeToSeconds(), this.dpcCollectNode.getEndTimeToSeconds());
            log.info("start dpc collect job success for DME ip:{},current batch number:{},dpc ips:{},taskId:{}", new Object[]{this.aiDevNode.getIp(), currentBatch, currentBatchIps, taskId});
            TaskDetailStatus queryStatus = this.pollingQueryTaskDetail(this.aiDevNode, taskId, currentErrorBuilder);
            this.uiProgress.updateProgress(5 + 90 / this.totalBatch * index + 80 / this.totalBatch, "");
            if (queryStatus == TaskDetailStatus.SUCCESS || queryStatus == TaskDetailStatus.PART_SUCCESS) {
                log.info("dpc collect success for DME ip:{},current batch number:{},dpc ips:{},taskId:{}", new Object[]{this.aiDevNode.getIp(), currentBatch, currentBatchIps, taskId});
                boolean downloadResult = this.downloadCollectFile(this.aiDevNode, taskId);
                this.dealWithCount(queryStatus, downloadResult, currentBatchIps);
            } else {
                log.error("dpc collect fail for DME ip:{},current batch number:{},dpc ips:{},taskId:{}", new Object[]{this.aiDevNode.getIp(), currentBatch, currentBatchIps, taskId});
            }
        }
        catch (CollectException e) {
            log.error("batch number:{}, dpc ips:{}", new Object[]{currentBatch, currentBatchIps, e});
            currentErrorBuilder.append("error_code:").append(e.getErrorCode()).append(",\nerror_msg:").append(e.getErrorMsg());
        }
        catch (ToolException e) {
            log.error("download dpc collect file error for DME ip:{} batch number:{}, dpc ips:{}", new Object[]{this.aiDevNode.getIp(), currentBatch, currentBatchIps, e});
            currentErrorBuilder.append(ResourceUtil.getString((String)"dpc.collect.request.error"));
        }
        if (currentErrorBuilder.length() > 0) {
            this.saveErrorMsg(currentBatch, dpcPartitions, currentErrorBuilder);
        }
    }

    private List<String> getCurrentBatchIps(List<List<DpcClusterNode>> dpcPartitions, int index) {
        return dpcPartitions.get(index).stream().map(ClusterNode::getManagementIp).collect(Collectors.toList());
    }

    private List<String> getCurrentBatchIds(List<List<DpcClusterNode>> dpcPartitions, int index) {
        return dpcPartitions.get(index).stream().map(DpcClusterNode::getDpcNodeId).collect(Collectors.toList());
    }

    void saveErrorMsg(int index, List<List<DpcClusterNode>> dpcPartitions, StringBuilder currentErrorBuilder) {
        List<String> currentBatchIds = this.getCurrentBatchIds(dpcPartitions, index - 1);
        List<String> currentBatchIps = this.getCurrentBatchIps(dpcPartitions, index - 1);
        log.warn("The collection is not complete. current batch number:{}, dpc id:{}, dpc ip:{}, errMsg:{}", new Object[]{index, currentBatchIds, currentBatchIps, currentErrorBuilder});
        this.errorMsg.add(String.join((CharSequence)",\n", currentBatchIps));
        this.errorMsg.add(currentErrorBuilder.toString());
    }

    private boolean downloadCollectFile(AiDevNode aiDevNode, String taskId) throws ToolException, CollectException {
        return this.convertService.downloadCollectFile(aiDevNode, taskId, String.join((CharSequence)File.separator, this.collectTimePath, DATA_COLLECT));
    }

    private String startCollectJob(AiDevNode aiDevNode, List<String> dpcIps, long beginTime, long endTime) throws ToolException, CollectException {
        DpcStartCollectParam collectParam = new DpcStartCollectParam(dpcIps, beginTime, endTime);
        return this.convertService.startCollectJob(aiDevNode, collectParam).getTaskId();
    }

    TaskDetailStatus pollingQueryTaskDetail(AiDevNode aiDevNode, String taskId, StringBuilder currentErrorBuilder) throws ToolException, CollectException {
        TaskDetail taskDetail;
        block3: {
            long lastUpdateTime = System.currentTimeMillis();
            int lastProgress = 0;
            while (true) {
                ThreadUtils.sleepSeconds((long)5L);
                Optional<TaskDetail> taskDetailOpt = this.convertService.queryCollectJobDetail(aiDevNode, taskId).stream().filter(detail -> taskId.equals(detail.getId())).findAny();
                if (!taskDetailOpt.isPresent()) {
                    log.error("dpc query task detail error,there is no current task result for DME ip:{},taskId:{}", (Object)aiDevNode.getIp(), (Object)taskId);
                    currentErrorBuilder.append(ResourceUtil.getString((String)"dpc.collect.query.detail.fail"));
                    return TaskDetailStatus.FAIL;
                }
                log.info("dpc query collect task detail response is running for DME ip:{}, taskId:{}, progress:{}", new Object[]{aiDevNode.getIp(), taskId, taskDetailOpt.get().getProgress()});
                taskDetail = taskDetailOpt.get();
                int queryStatus = taskDetail.getStatus();
                if (queryStatus != TaskDetailStatus.INIT.getStatus() && queryStatus != TaskDetailStatus.RUNNING.getStatus()) break block3;
                if (taskDetail.getProgress() != lastProgress) {
                    lastProgress = taskDetail.getProgress();
                    lastUpdateTime = System.currentTimeMillis();
                    continue;
                }
                if (System.currentTimeMillis() - lastUpdateTime >= QUERY_DETAIL_OVERTIME_MILLS) break;
            }
            log.error("dpc query task detail overtime,for DME ip:{},taskId:{}", (Object)aiDevNode.getIp(), (Object)taskId);
            currentErrorBuilder.append(ResourceUtil.getString((String)"dpc.collect.query.detail.overtime"));
            return TaskDetailStatus.FAIL;
        }
        return this.dealTaskDetailStatus(aiDevNode, taskId, currentErrorBuilder, taskDetail);
    }

    private TaskDetailStatus dealTaskDetailStatus(AiDevNode aiDevNode, String taskId, StringBuilder currentErrorBuilder, TaskDetail taskDetail) {
        int queryStatus = taskDetail.getStatus();
        if (queryStatus == TaskDetailStatus.SUCCESS.getStatus()) {
            log.info("dpc query collect task detail response is success for status code:{}, DME ip:{}, taskId:{}", new Object[]{queryStatus, aiDevNode.getIp(), taskId});
            return TaskDetailStatus.SUCCESS;
        }
        if (queryStatus == TaskDetailStatus.PART_SUCCESS.getStatus()) {
            log.info("dpc query collect task detail response is part success for status code:{}, DME ip:{}, taskId:{}", new Object[]{queryStatus, aiDevNode.getIp(), taskId});
            currentErrorBuilder.append(taskDetail.getDetail());
            return TaskDetailStatus.PART_SUCCESS;
        }
        log.error("dpc query collect task detail response is fail for status code:{}, DME ip:{}, taskId:{}, reason:{}", new Object[]{queryStatus, aiDevNode.getIp(), taskId, taskDetail.getDetail()});
        currentErrorBuilder.append(taskDetail.getDetail());
        return TaskDetailStatus.FAIL;
    }
}

