/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.dpc.service;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcClusterNode;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcQueryNodesParam;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcResponse;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcsResponse;
import com.huawei.ism.tool.infocollect.dpc.enums.DpcNodeStatus;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectConvertService;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.util.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpcCollectUtil {
    private static final Logger log = LoggerFactory.getLogger(DpcCollectUtil.class);
    private static final DpcCollectConvertService CONVERT_SERVICE = DpcCollectConvertService.getInstance();
    private static final int DPC_MAX_PAGE_SIZE = NumberUtils.parseIntDefault((String)ResourceBundle.getBundle("config.infocollect").getString("query.dpc.node.max.page.size"), (int)1000);

    public static Optional<DpcCollectNode> getDpcCollectNode(DevNode devNode) throws ToolException {
        if (Objects.isNull(devNode) || !(devNode instanceof DmeNode)) {
            log.error("om node is null or is not om node,can not get DpcCollectNode");
            return Optional.empty();
        }
        Optional<AiDevNode> aiDevNodeOpt = DpcCollectUtil.getAiDevNode(devNode);
        if (!aiDevNodeOpt.isPresent()) {
            log.error("can not get AiDevNode for current om node");
            return Optional.empty();
        }
        String dmeIp = aiDevNodeOpt.get().getIp();
        DpcCollectNode dpcCollectNode = CollectDataContext.getInstance().getCollectNodeMap().get(dmeIp);
        if (Objects.nonNull(dpcCollectNode)) {
            return Optional.of(dpcCollectNode);
        }
        log.info("start to init dpcCollectNode for DME ip:{}", (Object)dmeIp);
        dpcCollectNode = DpcCollectUtil.initCollectNode(aiDevNodeOpt.get());
        CollectDataContext.getInstance().getCollectNodeMap().put(dmeIp, dpcCollectNode);
        return Optional.ofNullable(dpcCollectNode);
    }

    public static Optional<AiDevNode> getAiDevNode(DevNode devNode) {
        if (Objects.isNull(devNode) || !(devNode instanceof DmeNode)) {
            return Optional.empty();
        }
        String omIp = devNode.getIp();
        Map<String, AiDevNode> aiDevNodeMap = CollectDataContext.getInstance().getAiDevNodeMap();
        AiDevNode aiDevNode = aiDevNodeMap.get(omIp);
        if (Objects.isNull(aiDevNode)) {
            aiDevNode = DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).filter(aiDevNode1 -> aiDevNode1.getOmNodes().stream().map(DevNode::getIp).anyMatch(ip -> ip.equals(omIp))).findAny().orElse(null);
            aiDevNodeMap.put(omIp, aiDevNode);
        }
        return Optional.ofNullable(aiDevNode);
    }

    private static DpcCollectNode initCollectNode(AiDevNode aiDevNode) throws ToolException {
        log.info("start to init dpc collect node for DME ip:{}", (Object)aiDevNode.getIp());
        DpcCollectNode dpcCollectNode = new DpcCollectNode();
        List<DpcResponse> dpcResponses = DpcCollectUtil.queryAllDpcNodes(aiDevNode);
        dpcCollectNode.setDpcClusterNodes(DpcCollectUtil.convertToClusterNodes(dpcResponses));
        log.info("init dpc collect node end for DME ip:{}", (Object)aiDevNode.getIp());
        return dpcCollectNode;
    }

    private static List<DpcResponse> queryAllDpcNodes(AiDevNode aiDevNode) throws ToolException {
        DpcsResponse dpcsResponse = CONVERT_SERVICE.queryDpcNodes(aiDevNode, DpcQueryNodesParam.builder().build());
        log.info("first query dpc nodes success, the nodes count is {} for DME ip:{}", (Object)dpcsResponse.getTotal(), (Object)aiDevNode.getIp());
        if (dpcsResponse.getTotal() <= DPC_MAX_PAGE_SIZE) {
            return dpcsResponse.getDatas();
        }
        return DpcCollectUtil.batchQueryAllDpcNodes(aiDevNode, dpcsResponse.getTotal());
    }

    private static List<DpcResponse> batchQueryAllDpcNodes(AiDevNode aiDevNode, int totalCount) throws ToolException {
        ArrayList<DpcResponse> resultList = new ArrayList<DpcResponse>();
        DpcQueryNodesParam queryNodesParam = DpcQueryNodesParam.builder().pageSize(DPC_MAX_PAGE_SIZE).build();
        int maxPageNum = totalCount / DPC_MAX_PAGE_SIZE + (totalCount % DPC_MAX_PAGE_SIZE == 0 ? 0 : 1);
        for (int pageNo = 1; pageNo <= maxPageNum; ++pageNo) {
            queryNodesParam.setPageNo(pageNo);
            DpcsResponse dpcsResponse = CONVERT_SERVICE.queryDpcNodes(aiDevNode, queryNodesParam);
            List<DpcResponse> datas = dpcsResponse.getDatas();
            if (CollectionUtils.isEmpty(datas)) {
                log.error("query dpc nodes error for DME ip:{},the total dpc count is {}, expected total page num is {}, but has no data in page:{}", new Object[]{aiDevNode.getIp(), totalCount, maxPageNum, pageNo});
                break;
            }
            resultList.addAll(datas);
            log.info("the dpc nodes ids query result of batch number:{} for DME ip:{} is: {}", new Object[]{pageNo + 1, aiDevNode.getIp(), datas.stream().map(DpcResponse::getId).collect(Collectors.toList())});
        }
        return resultList;
    }

    private static List<DpcClusterNode> convertToClusterNodes(List<DpcResponse> dpcResponses) {
        if (CollectionUtils.isEmpty(dpcResponses)) {
            return Collections.emptyList();
        }
        AtomicInteger idIndex = new AtomicInteger(0);
        return dpcResponses.stream().map(dpcResponse -> DpcCollectUtil.convertToClusterNode(dpcResponse, idIndex)).collect(Collectors.toList());
    }

    private static DpcClusterNode convertToClusterNode(DpcResponse dpcResponse, AtomicInteger idIndex) {
        DpcClusterNode dpcClusterNode = new DpcClusterNode();
        dpcClusterNode.setId(idIndex.getAndIncrement());
        dpcClusterNode.setDpcNodeId(dpcResponse.getId());
        dpcClusterNode.setManagementIp(dpcResponse.getIp());
        dpcClusterNode.setOmNodeIp(dpcResponse.getAssociatedDpcOm().getIp());
        dpcClusterNode.setSerialNumber(dpcResponse.getSn());
        dpcClusterNode.setName(dpcResponse.getHostname());
        dpcClusterNode.setManageStatus(DpcNodeStatus.of(dpcResponse.getMgmtStatus()));
        dpcClusterNode.setServiceStatus(DpcNodeStatus.of(dpcResponse.getStatus()));
        dpcClusterNode.setSelected(false);
        return dpcClusterNode;
    }

    private DpcCollectUtil() {
    }
}

