/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConfDebufMod;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.PreCondition;
import com.huawei.ism.tool.infocollect.entity.command.CommandConf;
import com.huawei.ism.tool.infocollect.util.ApplyRange;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public class CollectConf
implements Cloneable {
    public static final String ONE_DAY = "oneDay";
    public static final String ONE_WEEK = "oneWeek";
    public static final String ONE_MOUTH = "oneMouth";
    public static final String ID = "id";
    public static final String ITEM = "item";
    public static final String D_STORAGE = "DStorage";
    public static final String STORAGE = "Storage";
    private static final String ITEMSID_SEPARATOR = ",";
    private static final String FULLLOG = "fulllog";
    private static final String BYTIME = "bytime";
    private static final String EMERGENCY_LOG = "log";
    private static final String LOG_SIMPLE_COLLECT = "log";
    private static final List<String> SILENCE_MODULE_LIST = Collections.singletonList("perf");
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CollectConf.class);
    private boolean enableDate = false;
    private String defaultDuration = "oneDay";
    private CollectConfDebufMod debugMode = null;
    private ApplyRange applyRange;
    private List<CollectModule> modules = new ArrayList<CollectModule>();
    private CommandConf comandConf = null;
    private List<PreCondition> preConditions = new ArrayList<PreCondition>();
    private boolean isInited = false;
    private boolean isComputeStorageFcvNode = false;
    private String version = "";
    private String devType = "";

    public boolean isInited() {
        return this.isInited;
    }

    public void setInited(boolean inited) {
        this.isInited = inited;
    }

    public List<CollectItem> getAllCollectItems() {
        ArrayList<CollectItem> result = new ArrayList<CollectItem>();
        if (this.modules == null) {
            return result;
        }
        for (CollectModule module : this.modules) {
            result.addAll(module.getItems());
        }
        return result;
    }

    public CollectDuration gainDefaultCollectDuration() {
        if (this.defaultDuration.equals(ONE_DAY)) {
            return CollectDuration.LASTDAY;
        }
        if (this.defaultDuration.equals(ONE_WEEK)) {
            return CollectDuration.LASTWEEK;
        }
        if (this.defaultDuration.equals(ONE_MOUTH)) {
            return CollectDuration.LASTMONTH;
        }
        return CollectDuration.INVALIDD;
    }

    public List<CollectItem> getIncludeSilenceCollectItems(Map<String, String> idMaps, DevNode devNode) throws Exception {
        ArrayList<CollectItem> result = new ArrayList<CollectItem>();
        String mode = CollectDataContext.getInstance().getMode();
        LOGGER.info("collect mode is : {}", (Object)mode);
        if (this.modules == null || StringUtils.isNULLStr((String)mode)) {
            return result;
        }
        if (FULLLOG.equalsIgnoreCase(mode) || BYTIME.equalsIgnoreCase(mode)) {
            return this.getDefaultCollectItems();
        }
        if ("log".equalsIgnoreCase(mode)) {
            return this.getClientEmergencyCollectItems();
        }
        return this.getCollectItems(idMaps, devNode, mode);
    }

    private List<CollectItem> getCollectItems(Map<String, String> idMaps, DevNode devNode, String mode) throws Exception {
        Map<String, String> itemMaps = this.getTtemMap(devNode);
        if (itemMaps.containsKey(mode) && itemMaps.get(mode) != null) {
            String[] recvItems = itemMaps.get(mode).split(ITEMSID_SEPARATOR);
            if (devNode.isDsStorage()) {
                if (SILENCE_MODULE_LIST.contains(mode)) {
                    return this.getCollectItemsByModule(recvItems);
                }
                return this.getCollectItemsByItem(recvItems);
            }
            return this.getCollectItemsByMode(recvItems, idMaps);
        }
        String[] recvItems = mode.split(ITEMSID_SEPARATOR);
        return this.getCollectItemsByMode(recvItems, idMaps);
    }

    public Map<String, String> getTtemMap(DevNode devNode) throws Exception {
        HashMap<String, String> itemMaps;
        block4: {
            File idMapFile = new File(CollectDataContext.COLLECTMAPPATH);
            itemMaps = new HashMap<String, String>();
            if (!idMapFile.exists()) break block4;
            SAXReader saxReader = XmlUtils.getSaxReader();
            Document doc = saxReader.read(idMapFile);
            Element root = doc.getRootElement();
            if (devNode.isDsStorage()) {
                Element taskMapList = root.element(D_STORAGE);
                Iterator itr = taskMapList.elementIterator();
                while (itr.hasNext()) {
                    Element ele = (Element)itr.next();
                    itemMaps.put(ele.attributeValue(ID).toLowerCase(Locale.ENGLISH), ele.attributeValue(ITEM));
                }
            } else {
                Element taskMapList = root.element(STORAGE);
                Iterator itr = taskMapList.elementIterator();
                while (itr.hasNext()) {
                    Element ele = (Element)itr.next();
                    itemMaps.put(ele.attributeValue(ID).toLowerCase(Locale.ENGLISH), ele.attributeValue(ITEM));
                }
            }
        }
        return itemMaps;
    }

    public List<CollectItem> getCollectItemsByItem(String[] recvItems) {
        LinkedList<CollectItem> tempSelectItems = new LinkedList<CollectItem>();
        for (CollectModule module : this.modules) {
            List<CollectItem> items = module.getItems();
            for (String recvItem : recvItems) {
                for (CollectItem collectItem : items) {
                    if (!collectItem.getId().equalsIgnoreCase(recvItem) || collectItem.getMode() == ModeType.MOVE) continue;
                    collectItem.setDefaultChoose(true);
                    tempSelectItems.add(collectItem);
                }
            }
        }
        return tempSelectItems;
    }

    public List<CollectItem> getCollectItemsByModule(String[] receiveModules) {
        return this.modules.stream().filter(module -> Arrays.asList(receiveModules).contains(module.getModuleId())).map(CollectModule::getItems).flatMap(Collection::stream).filter(item -> item.getMode() != ModeType.MOVE).peek(item -> item.setDefaultChoose(true)).collect(Collectors.toList());
    }

    public List<CollectItem> getCollectItemsByMode(String[] recvItems, Map<String, String> idMaps) {
        LinkedList<CollectItem> tempSelectItems = new LinkedList<CollectItem>();
        for (CollectModule module : this.modules) {
            List<CollectItem> items = module.getItems();
            for (String recvItem : recvItems) {
                for (CollectItem collectItem : items) {
                    if (!collectItem.getId().equalsIgnoreCase(idMaps.get(recvItem.toLowerCase(Locale.ENGLISH)))) continue;
                    collectItem.setDefaultChoose(true);
                    tempSelectItems.add(collectItem);
                }
            }
        }
        return tempSelectItems;
    }

    private List<CollectItem> getClientEmergencyCollectItems() {
        ArrayList<CollectItem> result = new ArrayList<CollectItem>();
        if (this.modules == null) {
            return result;
        }
        String[] itemsId = this.getInfoCollectProperItemsId();
        this.addItemToResult(result, itemsId);
        return result;
    }

    private void addItemToResult(List<CollectItem> result, String[] itemsId) {
        for (CollectModule module : this.modules) {
            List<CollectItem> items = module.getItems();
            for (CollectItem item : items) {
                Arrays.stream(itemsId).forEach(itemid -> {
                    if (item.getId().equalsIgnoreCase((String)itemid)) {
                        result.add(item);
                    }
                });
            }
        }
    }

    private String[] getInfoCollectProperItemsId() {
        ResourceBundle sysBundle = ResourceBundle.getBundle("config.infocollect");
        if (sysBundle == null) {
            LOGGER.info("can't open infocollect.properties file");
            return new String[0];
        }
        String[] itemsId = sysBundle.getString("client_emergency_log_collect").split(ITEMSID_SEPARATOR);
        if (itemsId == null) {
            LOGGER.info("can't get itemsId");
            return new String[0];
        }
        return itemsId;
    }

    public List<CollectItem> getDefaultCollectItems() {
        ArrayList<CollectItem> result = new ArrayList<CollectItem>();
        if (this.modules == null) {
            return result;
        }
        for (CollectModule module : this.modules) {
            List<CollectItem> items = module.getItems();
            for (CollectItem item : items) {
                if (!item.isDefaultChoose()) continue;
                result.add(item);
            }
        }
        return result;
    }

    public List<CollectModule> getSimpleCollectModules() {
        return this.modules.stream().filter(module -> ModeType.of(module.getMode()) == ModeType.SIMPLE_COLLECT).collect(Collectors.toList());
    }

    public List<CollectModule> getAllSimpleCollectModuleAndSort() {
        return this.modules.stream().filter(module -> ModeType.of(module.getMode()) == ModeType.SIMPLE_COLLECT || module.isModuleAddInSimple()).sorted(Comparator.comparingInt(CollectModule::getIndexInSimple)).collect(Collectors.toList());
    }

    public List<CollectItem> getDefaultCollectItemsForSimpleCollect() {
        List<CollectItem> simpleCollectModules = this.getSimpleCollectModules().stream().map(CollectModule::getItems).flatMap(Collection::stream).filter(CollectItem::isDefaultChoose).collect(Collectors.toList());
        List itemAddInFault = this.modules.stream().filter(module -> module.isModuleAddInSimple() && module.isModuleSelectInSimple()).map(CollectModule::getItems).flatMap(Collection::stream).collect(Collectors.toList());
        simpleCollectModules.addAll(itemAddInFault);
        return simpleCollectModules;
    }

    public List<CollectModule> getDefaultModules() {
        return this.modules.stream().filter(module -> ModeType.of(module.getMode()) != ModeType.SIMPLE_COLLECT).collect(Collectors.toList());
    }

    public List<CollectItem> getDefaultCollectItemsForNotSimpleCollect() {
        return this.getDefaultModules().stream().map(CollectModule::getItems).flatMap(Collection::stream).filter(CollectItem::isDefaultChoose).collect(Collectors.toList());
    }

    public List<CollectModule> buildCommonSimpleCollectModule(List<CollectItem> selectItems) {
        ArrayList<CollectModule> collectModules = new ArrayList<CollectModule>();
        List<CollectItem> simpleCollectItems = this.getAllSimpleCollectItems();
        if (selectItems.stream().anyMatch(simpleCollectItems::contains)) {
            collectModules.add(this.getSimpleCollectModule());
        }
        this.modules.stream().filter(CollectModule::isModuleAddInSimple).forEach(newAddModule -> {
            for (CollectItem item : selectItems) {
                if (StringUtils.isNULLStr((String)item.getModuleId()) || !newAddModule.getModuleId().equalsIgnoreCase(item.getModuleId())) continue;
                collectModules.add((CollectModule)newAddModule);
                break;
            }
        });
        return collectModules;
    }

    private CollectModule getSimpleCollectModule() {
        CollectModule module = new CollectModule();
        module.setNameKey(ResourceUtil.getString((String)"collect.module.simple.collect"));
        module.setModuleId("log");
        module.setMode(ModeType.POLL.toString());
        module.setItems(this.getAllSimpleCollectItems());
        return module;
    }

    private List<CollectItem> getAllSimpleCollectItems() {
        return this.getSimpleCollectModules().stream().map(CollectModule::getItems).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isEnableDate() {
        return this.enableDate;
    }

    public void setEnableDate(boolean enableDate) {
        this.enableDate = enableDate;
    }

    public String getDefaultDuration() {
        return this.defaultDuration;
    }

    public void setDefaultDuration(String defaultDuration) {
        this.defaultDuration = defaultDuration;
    }

    public CollectConfDebufMod getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(CollectConfDebufMod debugMode) {
        this.debugMode = debugMode;
    }

    public List<CollectModule> getModules() {
        return this.modules;
    }

    public void setModules(List<CollectModule> modules) {
        this.modules = modules;
    }

    public CommandConf getComandConf() {
        return this.comandConf;
    }

    public void setComandConf(CommandConf comandConf) {
        this.comandConf = comandConf;
    }

    public List<PreCondition> getPreConditions() {
        return this.preConditions;
    }

    public void setPreConditions(List<PreCondition> preConditions) {
        this.preConditions = preConditions;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDevType() {
        return this.devType;
    }

    public ApplyRange getApplyRange() {
        return this.applyRange;
    }

    public void setApplyRange(ApplyRange applyRange) {
        this.applyRange = applyRange;
    }

    public Object clone() {
        CollectConf collectConf = null;
        try {
            collectConf = (CollectConf)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOGGER.error("Clone object error." + cloneNotSupportedException.toString());
        }
        return collectConf;
    }

    public List<CollectModule> getSpecifiedModules(ModeType modeType) {
        return this.modules.stream().filter(module -> ModeType.of(module.getMode()) == modeType).collect(Collectors.toList());
    }

    public List<CollectItem> getDefaultSpecifiedCollectItems(ModeType modeType) {
        return this.getSpecifiedModules(modeType).stream().map(CollectModule::getItems).flatMap(Collection::stream).filter(CollectItem::isDefaultChoose).collect(Collectors.toList());
    }

    public List<CollectModule> buildSpecifiedCollectModule(ModeType modeType) {
        CollectModule module = new CollectModule();
        module.setNameKey(ResourceUtil.getString((String)"collect.module.simple.collect"));
        module.setModuleId("log");
        module.setMode(ModeType.POLL.toString());
        module.setItems(this.getAllSpecifiedCollectItems(modeType));
        return Collections.singletonList(module);
    }

    private List<CollectItem> getAllSpecifiedCollectItems(ModeType modeType) {
        return this.getSpecifiedModules(modeType).stream().map(CollectModule::getItems).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isComputeStorageFcvNode() {
        return this.isComputeStorageFcvNode;
    }

    public void setComputeStorageFcvNode(boolean isComputeStorageFcvNode) {
        this.isComputeStorageFcvNode = isComputeStorageFcvNode;
    }
}

