/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.ItemConditionTag;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.TransmitStrategy;
import com.huawei.ism.tool.infocollect.util.DStoragePackageUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.table.TableRow;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectConfInfo {
    private static final Logger log = LoggerFactory.getLogger(CollectConfInfo.class);
    private static final String ID = "id";
    private static final String ID_MAP_XML = "IDMap.xml";
    private static final String VALUE = "value";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CollectConfInfo.class);
    private CollectDuration duration = null;
    private String receiveAddrs = null;
    private List<CollectItem> selectItems = new ArrayList<CollectItem>();
    private TransmitStrategy transmitStrategy = TransmitStrategy.NO_TRANSMIT;
    private Map<String, Object> collectProperties = new HashMap<String, Object>();
    private String selectedIntegrateNode = "";
    private int volumnSize = 0;
    private List<CollectItem> defaultSelectItems = new ArrayList<CollectItem>();
    private List<CollectItem> simpleCollectSelectItems = new ArrayList<CollectItem>();
    private boolean isSimpleCollect = false;
    private boolean isCompleteParamSetting = false;
    private List<CollectItem> customCollectSelectItems = new ArrayList<CollectItem>();
    private List<CollectItem> quicklyCollectSelectItems = new ArrayList<CollectItem>();
    private List<CollectItem> depthCollectSelectItems = new ArrayList<CollectItem>();
    private boolean isCustomCollect = false;
    private boolean isQuicklyCollect = false;
    private boolean isDepthCollect = false;
    private boolean isCompleteStorageParamSetting = false;
    private boolean isCollectByNodes = false;
    private List<String> selectedControllerNodeIds = new ArrayList<String>();
    private List<String> selectedExpansionModuleIds = new ArrayList<String>();
    private List<TableRow> selectNodes = new ArrayList<TableRow>();

    public static CollectConfInfo createDefaultInstance(CollectConf conf, DevNode devNode) {
        boolean isForeground;
        if (conf == null) {
            return null;
        }
        CollectConfInfo collectConfInfo = new CollectConfInfo();
        if (conf.isEnableDate()) {
            collectConfInfo.setDuration(conf.gainDefaultCollectDuration());
        } else {
            collectConfInfo.setDuration(CollectDuration.INVALIDD);
        }
        List<Object> selectItems = new ArrayList();
        String mode = System.getenv("startMode");
        boolean bl = isForeground = null == mode || !"1".equals(mode);
        if (!isForeground) {
            try {
                Map<String, String> inCludeIDs = CollectConfInfo.generateIncludeIDs(devNode);
                selectItems = conf.getIncludeSilenceCollectItems(inCludeIDs, devNode);
            }
            catch (Exception e) {
                LOGGER.error("Exception happened in timeming infoCollect", (Throwable)e);
            }
        } else {
            selectItems = conf.getDefaultCollectItems();
        }
        if (selectItems.isEmpty() && isForeground) {
            LOGGER.error("selectItems is empty");
            selectItems = conf.getAllCollectItems();
        }
        collectConfInfo.setSelectItems(selectItems, devNode);
        CollectConfInfo.setDefaultSelectItems(conf, collectConfInfo);
        CollectConfInfo.setSceneSelectItems(conf, collectConfInfo);
        if (conf.getDebugMode().isEnableDebug()) {
            String debugPwd = devNode.getDeveloperPwd();
            collectConfInfo.getCollectProperties().put("debug_password", debugPwd);
        }
        collectConfInfo.setSimpleCollect(DStoragePackageUtil.isSupportReduceCollect(devNode));
        collectConfInfo.setQuicklyCollect(InfoCollectUtil.isSupportCollectedByScene(devNode));
        return collectConfInfo;
    }

    private static void setSceneSelectItems(CollectConf conf, CollectConfInfo collectConfInfo) {
        collectConfInfo.setCustomCollectSelectItems(conf.getDefaultSpecifiedCollectItems(ModeType.CUSTOM_COLLECT));
        collectConfInfo.setQuicklyCollectSelectItems(conf.getDefaultSpecifiedCollectItems(ModeType.QUICKLY_COLLECT));
        collectConfInfo.setDepthCollectSelectItems(conf.getDefaultSpecifiedCollectItems(ModeType.DEPTH_COLLECT));
    }

    private static void setDefaultSelectItems(CollectConf conf, CollectConfInfo collectConfInfo) {
        collectConfInfo.setSimpleCollectSelectItems(conf.getDefaultCollectItemsForSimpleCollect());
        collectConfInfo.setDefaultSelectItems(conf.getDefaultCollectItemsForNotSimpleCollect());
    }

    private static Map<String, String> generateIncludeIDs(DevNode devNode) throws Exception {
        HashMap<String, String> idMaps = new HashMap<String, String>();
        String procisPath = FilePathUtils.checkFile((String)InfoConfiguration.getInstance().getPackagePath(devNode));
        File idMapFile = new File(procisPath + File.separator + ID_MAP_XML);
        if (idMapFile.exists()) {
            SAXReader saxReader = XmlUtils.getSaxReader();
            Document doc = saxReader.read(idMapFile);
            Element root = doc.getRootElement();
            Iterator itr = root.elementIterator();
            while (itr.hasNext()) {
                Element ele = (Element)itr.next();
                idMaps.put(ele.attributeValue(VALUE).toLowerCase(Locale.ENGLISH), ele.attributeValue(ID));
            }
        }
        return idMaps;
    }

    public boolean isNotSelectItem() {
        return this.selectItems.isEmpty();
    }

    public Date getStartDate() {
        return this.duration.getStartDate();
    }

    public Date getEndDate() {
        return this.duration.getEndDate();
    }

    public static CollectConfInfo createDefaultInstance(CollectConf conf, DevNode devNode, List<CollectItem> collectItems) {
        if (conf == null) {
            return null;
        }
        CollectConfInfo collectConfInfo = new CollectConfInfo();
        if (conf.isEnableDate()) {
            collectConfInfo.setDuration(conf.gainDefaultCollectDuration());
        } else {
            collectConfInfo.setDuration(CollectDuration.INVALIDD);
        }
        collectConfInfo.setSelectItems(collectItems, devNode);
        if (conf.getDebugMode().isEnableDebug()) {
            String debugPwd = devNode.getDeveloperPwd();
            collectConfInfo.getCollectProperties().put("debug_password", debugPwd);
        }
        collectConfInfo.setSimpleCollect(DStoragePackageUtil.isSupportReduceCollect(devNode));
        return collectConfInfo;
    }

    public CollectDuration getDuration() {
        return this.duration;
    }

    public void setDuration(CollectDuration duration) {
        this.duration = duration;
    }

    public String getReceiveAddrs() {
        return this.receiveAddrs;
    }

    public void setReceiveAddrs(String receiveAddrs) {
        this.receiveAddrs = receiveAddrs;
    }

    public List<CollectItem> getSelectItems() {
        return this.selectItems;
    }

    public void setSelectItems(List<CollectItem> selectItems, DevNode node) {
        Iterator<CollectItem> iter = selectItems.iterator();
        while (iter.hasNext()) {
            CollectItem item = iter.next();
            if (!ItemConditionTag.checkItemTag(item.getItemConditionTag(), node)) continue;
            if (null != node) {
                String log = "Dev %s item %s is meet tag %s ";
                LOGGER.info(String.format(Locale.ROOT, log, node.getIp(), item.getId(), item.getItemConditionTag()));
            }
            iter.remove();
        }
        this.selectItems = selectItems;
    }

    public void setSelectItems(List<CollectItem> selectItems) {
        log.info("select items is {}", (Object)selectItems.stream().map(CollectItem::getId).collect(Collectors.joining(",")));
        this.selectItems = selectItems;
    }

    public TransmitStrategy getTransmitStrategy() {
        return this.transmitStrategy;
    }

    public void setTransmitStrategy(TransmitStrategy transmitStrategy) {
        this.transmitStrategy = transmitStrategy;
    }

    public Map<String, Object> getCollectProperties() {
        return this.collectProperties;
    }

    public void setCollectProperties(Map<String, Object> collectProperties) {
        this.collectProperties = collectProperties;
    }

    public String getSelectedIntegrateNode() {
        return this.selectedIntegrateNode;
    }

    public void setSelectedIntegrateNode(String selectedIntegrateNode) {
        this.selectedIntegrateNode = selectedIntegrateNode;
    }

    public int getVolumnSize() {
        return this.volumnSize;
    }

    public void setVolumnSize(int volumnSize) {
        this.volumnSize = volumnSize;
    }

    public void setDefaultSelectItems(List<CollectItem> defaultSelectItems) {
        this.defaultSelectItems = defaultSelectItems;
    }

    public List<CollectItem> getDefaultSelectItems() {
        return this.defaultSelectItems;
    }

    public void setSimpleCollectSelectItems(List<CollectItem> simpleCollectSelectItems) {
        this.simpleCollectSelectItems = simpleCollectSelectItems;
    }

    public List<CollectItem> getSimpleCollectSelectItems() {
        return this.simpleCollectSelectItems;
    }

    public void setSimpleCollect(boolean isSimpleCollect) {
        this.isSimpleCollect = isSimpleCollect;
    }

    public boolean isSimpleCollect() {
        return this.isSimpleCollect;
    }

    public void setCompleteParamSetting(boolean isCompleteParamSetting) {
        this.isCompleteParamSetting = isCompleteParamSetting;
    }

    public boolean isCompleteParamSetting() {
        return this.isCompleteParamSetting;
    }

    public List<CollectItem> getCustomCollectSelectItems() {
        return this.customCollectSelectItems;
    }

    public void setCustomCollectSelectItems(List<CollectItem> customCollectSelectItems) {
        this.customCollectSelectItems = customCollectSelectItems;
    }

    public List<CollectItem> getQuicklyCollectSelectItems() {
        return this.quicklyCollectSelectItems;
    }

    public void setQuicklyCollectSelectItems(List<CollectItem> quicklyCollectSelectItems) {
        this.quicklyCollectSelectItems = quicklyCollectSelectItems;
    }

    public List<CollectItem> getDepthCollectSelectItems() {
        return this.depthCollectSelectItems;
    }

    public void setDepthCollectSelectItems(List<CollectItem> depthCollectSelectItems) {
        this.depthCollectSelectItems = depthCollectSelectItems;
    }

    public void setCustomCollect(boolean isCustomCollect) {
        this.isCustomCollect = isCustomCollect;
    }

    public boolean isCustomCollect() {
        return this.isCustomCollect;
    }

    public void setQuicklyCollect(boolean isQuicklyCollect) {
        this.isQuicklyCollect = isQuicklyCollect;
    }

    public boolean isQuicklyCollect() {
        return this.isQuicklyCollect;
    }

    public void setDepthCollect(boolean isDepthCollect) {
        this.isDepthCollect = isDepthCollect;
    }

    public boolean isDepthCollect() {
        return this.isDepthCollect;
    }

    public void setCompleteStorageParamSetting(boolean isCompleteStorageParamSetting) {
        this.isCompleteStorageParamSetting = isCompleteStorageParamSetting;
    }

    public boolean isCompleteStorageParamSetting() {
        return this.isCompleteStorageParamSetting;
    }

    public void setCollectByNodes(boolean isCollectByNodes) {
        this.isCollectByNodes = isCollectByNodes;
    }

    public boolean isCollectByNodes() {
        return this.isCollectByNodes;
    }

    public List<String> getSelectedControllerNodeIds() {
        return this.selectedControllerNodeIds;
    }

    public void setSelectedControllerNodeIds(List<String> selectedControllerNodeIds) {
        this.selectedControllerNodeIds = selectedControllerNodeIds;
    }

    public List<String> getSelectedExpansionModuleIds() {
        return this.selectedExpansionModuleIds;
    }

    public void setSelectedExpansionModuleIds(List<String> selectedExpansionModuleIds) {
        this.selectedExpansionModuleIds = selectedExpansionModuleIds;
    }

    public List<TableRow> getSelectNodes() {
        return this.selectNodes;
    }

    public void setSelectNodes(List<TableRow> selectNodes) {
        this.selectNodes = selectNodes;
    }
}

