/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.infocollect.service.backgroud.ComputeStorageCons;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectDuration {
    private static final Logger log = LoggerFactory.getLogger(CollectDuration.class);
    public static final CollectDuration LASTDAY = new CollectDuration(0);
    public static final CollectDuration LASTWEEK = new CollectDuration(1);
    public static final CollectDuration LASTMONTH = new CollectDuration(2);
    public static final CollectDuration INVALIDD = new CollectDuration(-1);
    private static final int A_WEEK_AGO = -7;
    private static final int LAST_DAY = 0;
    private static final int LAST_WEEK = 1;
    private static final int LAST_MONTH = 2;
    private static final int CUSTOM_TIME = 3;
    private static final int INVALID = -1;
    private Date startDate = null;
    private Date endDate = null;
    private int index;
    private Date deviceDate = null;

    public CollectDuration() {
        this.index = 3;
    }

    private CollectDuration(int index) {
        this.index = index;
    }

    public Date getDeviceDate() {
        return this.deviceDate != null ? (Date)this.deviceDate.clone() : null;
    }

    public void setDeviceDate(Date deviceDate) {
        this.deviceDate = deviceDate != null ? (Date)deviceDate.clone() : null;
    }

    public int ordinal() {
        return this.index;
    }

    public Date getStartDate() {
        Calendar startTime = Calendar.getInstance();
        if (this.deviceDate != null) {
            startTime.setTime(this.deviceDate);
        }
        if (this.ordinal() == 0) {
            startTime.add(5, -1);
            return startTime.getTime();
        }
        if (this.ordinal() == 1) {
            startTime.add(6, -7);
            return (Date)startTime.getTime().clone();
        }
        if (this.ordinal() == 2) {
            startTime.add(2, -1);
            return startTime.getTime();
        }
        if (this.ordinal() == -1) {
            return null;
        }
        return this.startDate != null ? (Date)this.startDate.clone() : null;
    }

    public Date getEndDate() {
        if (this.ordinal() == 3) {
            return this.endDate == null ? new Date() : (Date)this.endDate.clone();
        }
        if (this.ordinal() == -1) {
            return null;
        }
        return null == this.deviceDate ? new Date() : (Date)this.deviceDate.clone();
    }

    public boolean isValid() {
        Date startD = this.getStartDate();
        Date endD = this.getEndDate();
        if (startD != null && endD != null) {
            return startD.before(endD);
        }
        return false;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate != null ? (Date)startDate.clone() : null;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate != null ? (Date)endDate.clone() : null;
    }

    public void setDeviceDate(String devicedate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNULLStr((String)devicedate)) {
            return;
        }
        try {
            this.deviceDate = format.parse(devicedate);
        }
        catch (ParseException e) {
            log.error("format date failed.", (Throwable)e);
        }
    }

    public boolean isValid(String devicedate, boolean needCheckEndTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startd = this.getStartDate();
        Date endd = null;
        try {
            endd = format.parse(devicedate);
        }
        catch (ParseException e) {
            log.error("format date failed.", (Throwable)e);
        }
        if (needCheckEndTime) {
            return this.isValidTime(endd);
        }
        if (startd != null && endd != null) {
            return startd.before(endd);
        }
        return false;
    }

    private boolean isValidTime(Date deviceDate) {
        Date endTime;
        Date startTime = this.getStartDate();
        if (ObjectUtils.allNotNull((Object[])new Object[]{startTime, deviceDate, endTime = this.getEndDate()})) {
            return !startTime.after(deviceDate) && !endTime.after(deviceDate);
        }
        return false;
    }

    public boolean isLessSevenDays() {
        long startTime = this.getStartDate().getTime();
        long endTime = this.getEndDate().getTime();
        return endTime - startTime < ComputeStorageCons.COMPUTE_NODE_MAX_TIME_SETTING;
    }
}

