/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectProcessInfo;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.TransmitStrategy;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectInfo
implements ICollectInfo {
    private DevNode devNode;
    private CollectConfInfo collectConfInfo = null;
    private SettingConfInfo settingConfInfo = null;
    private CollectProcessInfo processInfo = new CollectProcessInfo();
    private String collectRetFilePath = null;
    private boolean processFinished = false;

    public CollectInfo(DevNode devNode) {
        this.devNode = devNode;
    }

    @Override
    public Map<DevNode, CollectInfo> getCollectInfoes() {
        HashMap<DevNode, CollectInfo> collectInfoes = new HashMap<DevNode, CollectInfo>();
        collectInfoes.put(this.devNode, this);
        return collectInfoes;
    }

    @Override
    public DevNode getDevNode() {
        return this.devNode;
    }

    @Override
    public void cashExecuteResult(List<ExecuteResult> results) {
        this.processInfo.addResults(results);
    }

    @Override
    public int getCurrentProgress() {
        return this.processInfo.getCurrentProgress();
    }

    @Override
    public void resetProcessInfo() {
        this.processInfo.reset();
    }

    @Override
    public void setCollecting() {
        this.processInfo.setCollectStatus(CollectStatus.COLLECTING);
    }

    @Override
    public List<ExecuteResult> getExecuteResults() {
        return this.processInfo.getExecuteResults();
    }

    @Override
    public void addExecuteResult(ExecuteResult executeResult) {
        this.processInfo.addExecuteResults(executeResult);
    }

    public void setOnlyRunningMode(boolean onlyRunningMode) {
        this.processInfo.setOnlyRunningMode(onlyRunningMode);
    }

    @Override
    public boolean isCollecting() {
        return this.processInfo != null && this.processInfo.isCollecting();
    }

    @Override
    public boolean isCollecting(DevNode dv) {
        if (this.devNode.equals((Object)dv)) {
            return this.isCollecting();
        }
        return false;
    }

    @Override
    public CollectStatus getCollectStatus() {
        return this.processInfo.getCollectStatus();
    }

    @Override
    public CollectConfInfo getCollectConfInfo() {
        return this.collectConfInfo;
    }

    @Override
    public void setCollectConfInfo(CollectConfInfo collectConfInfo) {
        this.collectConfInfo = collectConfInfo;
    }

    @Override
    public CollectConfInfo getCollectConfInfo(DevNode dev) {
        if (dev.equals((Object)this.devNode)) {
            return this.getCollectConfInfo();
        }
        return null;
    }

    @Override
    public void setSendMode(String receiveAddrs, TransmitStrategy strategy, int valueNum) {
        this.collectConfInfo.setReceiveAddrs(receiveAddrs);
        this.collectConfInfo.setTransmitStrategy(strategy);
        this.collectConfInfo.setVolumnSize(valueNum);
    }

    @Override
    public String getCollectRetFilePath() {
        return this.collectRetFilePath;
    }

    public void setCollectRetFilePath(String collectRetFilePath) {
        this.collectRetFilePath = collectRetFilePath;
    }

    public SettingConfInfo getSettingConfInfo() {
        return this.settingConfInfo;
    }

    public void setSettingConfInfo(SettingConfInfo settingConfInfo) {
        this.settingConfInfo = settingConfInfo;
    }

    @Override
    public boolean isProcessFinished() {
        return this.processFinished;
    }

    @Override
    public void setProcessFinished(boolean processFinished) {
        this.processFinished = processFinished;
    }

    @Override
    public void updateLastExecuteResult(int progress, String remainTime) {
        this.processInfo.updateLastExecuteResult(progress, remainTime);
    }

    @Override
    public void updateExecuteResult(int progress, String remainTime) {
        this.processInfo.updateExecuteResult(progress, remainTime);
    }

    @Override
    public void updateDepthCollectExecuteResult(int progress, String remainTime) {
        this.processInfo.updateDepthCollectExecuteResult(progress, remainTime);
    }

    @Override
    public int getLatestProgress() {
        return this.processInfo.getLatestProgress();
    }

    @Override
    public int getProgress() {
        return this.processInfo.getProgress();
    }

    @Override
    public int getDepthCollectProgress() {
        return this.processInfo.getDepthCollectProgress();
    }
}

