/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectProcessInfo {
    private static final Logger log = LoggerFactory.getLogger(CollectProcessInfo.class);
    private volatile CollectStatus status = CollectStatus.NOT_COLLECT;
    private List<ExecuteResult> executeResults = Collections.synchronizedList(new ArrayList());
    private CollectStatus collectProcess = CollectStatus.NOT_COLLECT;
    private boolean onlyRunningMode = true;

    public void setCollectStatus(CollectStatus sts) {
        this.status = sts;
    }

    int getCurrentProgress() {
        int progress = 0;
        if (this.executeResults == null) {
            return 0;
        }
        if (!this.executeResults.isEmpty()) {
            for (int lastIndex = this.executeResults.size() - 1; lastIndex >= 0; --lastIndex) {
                ExecuteResult lastResult = this.executeResults.get(lastIndex);
                if (lastResult.isProcessing()) {
                    continue;
                }
                progress = lastResult.getProgress();
                break;
            }
        }
        return progress;
    }

    public void addResults(List<ExecuteResult> exeResults) {
        this.executeResults.addAll(exeResults);
    }

    public final void reset() {
        this.status = CollectStatus.NOT_COLLECT;
        this.executeResults.clear();
    }

    public CollectStatus getCollectStatus() {
        return this.status;
    }

    public boolean isCollecting() {
        return this.status.equals((Object)CollectStatus.COLLECTING);
    }

    public List<ExecuteResult> getExecuteResults() {
        return this.executeResults;
    }

    public void addExecuteResults(ExecuteResult executeResult) {
        int index;
        ExecuteResult lastResult = this.getLastExecuteResult();
        if (this.isChangeLastResult(lastResult)) {
            lastResult.setResult(true);
        }
        if ((index = this.executeResults.indexOf(executeResult)) == -1) {
            this.executeResults.add(executeResult);
        } else {
            this.executeResults.set(index, executeResult);
        }
        if (!executeResult.isSuccess() && !executeResult.isPyResult()) {
            this.status = CollectStatus.COLLECT_FAILED;
            return;
        }
        if (!executeResult.isProcessing() && executeResult.getProgress() == 100) {
            this.status = null != executeResult.getNowStatus() ? executeResult.getNowStatus() : CollectStatus.COLLECT_FINISHED;
        }
    }

    private boolean isChangeLastResult(ExecuteResult lastResult) {
        return Objects.nonNull(lastResult) && lastResult.isProcessing() && this.onlyRunningMode && !lastResult.isConcurrentDepthCollect();
    }

    private ExecuteResult getLastExecuteResult() {
        if (this.executeResults == null || this.executeResults.isEmpty()) {
            return null;
        }
        return this.executeResults.get(this.executeResults.size() - 1);
    }

    public void updateLastExecuteResult(int progress, String remainTime) {
        ExecuteResult result = this.getLastExecuteResult();
        if (null == result) {
            return;
        }
        if (result.isConcurrentDepthCollect() && progress <= 50 && progress > 0) {
            result.setSingleProgress(progress);
        }
        if (!result.isConcurrentDepthCollect() && this.isEffectiveProgress(progress)) {
            result.setSingleProgress(progress);
        }
        if (!StringUtils.isNULLStr((String)remainTime)) {
            result.setRemainTime(remainTime);
        }
    }

    boolean isEffectiveProgress(int progress) {
        return progress > 0 && progress <= 100;
    }

    public void updateExecuteResult(int progress, String remainTime) {
        ExecuteResult result = this.getExecuteResult();
        if (result == null) {
            return;
        }
        result.setSingleProgress(progress);
        result.setRemainTime(remainTime);
    }

    public void updateDepthCollectExecuteResult(int progress, String remainTime) {
        this.executeResults.stream().filter(ExecuteResult::isConcurrentDepthCollect).forEach(result -> {
            result.setSingleProgress(progress);
            result.setRemainTime(remainTime);
        });
    }

    private ExecuteResult getExecuteResult() {
        return this.executeResults.stream().filter(executeResult -> executeResult.getItem() != null && executeResult.getItem().getStep().equals("cli")).findFirst().orElse(null);
    }

    public int getLatestProgress() {
        ExecuteResult result = this.getLastExecuteResult();
        if (result == null) {
            return 0;
        }
        return result.getSingleProgress();
    }

    public int getProgress() {
        ExecuteResult result = this.getExecuteResult();
        return result == null ? 0 : result.getSingleProgress();
    }

    public int getDepthCollectProgress() {
        return this.executeResults.stream().filter(ExecuteResult::isConcurrentDepthCollect).map(ExecuteResult::getSingleProgress).findFirst().orElse(0);
    }

    public CollectStatus getCollectProcess() {
        return this.collectProcess;
    }

    public void setCollectProcess(CollectStatus collectProcess) {
        this.collectProcess = collectProcess;
    }

    public void setOnlyRunningMode(boolean onlyRunningMode) {
        this.onlyRunningMode = onlyRunningMode;
    }
}

