/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExtendeItemConfig {
    private static final String SEPARATOR = ",";
    private List<String> supportVersion = new ArrayList<String>();
    private List<String> supportDeviceType = new ArrayList<String>();
    private Set<String> itemXmlList = new HashSet<String>();

    public ExtendeItemConfig(String deviceConfig, String versionConfig) {
        if (!StringUtils.isNULLStr((String)deviceConfig)) {
            this.supportDeviceType.addAll(Arrays.asList(deviceConfig.split(SEPARATOR)));
        }
        if (!StringUtils.isNULLStr((String)versionConfig)) {
            this.supportVersion.addAll(Arrays.asList(versionConfig.split(SEPARATOR)));
        }
    }

    public void addItemXml(String xmlname) {
        this.itemXmlList.add(xmlname);
    }

    public boolean isSupport(DevNode devNode) {
        return this.devTypeSupport(devNode.getDeviceType().toString()) && this.versionSupport(devNode.getProductVersion());
    }

    private boolean devTypeSupport(String devType) {
        return this.supportDeviceType.stream().anyMatch(devType::equals);
    }

    private boolean versionSupport(String devVersion) {
        return this.supportVersion.stream().anyMatch(devVersion::contains);
    }

    public List<String> getSupportVersion() {
        return this.supportVersion;
    }

    public List<String> getSupportDeviceType() {
        return this.supportDeviceType;
    }

    public Set<String> getItemXmlList() {
        return this.itemXmlList;
    }
}

