/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.TransmitStrategy;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResultUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrateCollectInfo
implements ICollectInfo {
    private static final Logger log = LoggerFactory.getLogger(IntegrateCollectInfo.class);
    private DevNode dev;
    private Map<DevNode, CollectInfo> collectInfos = new HashMap<DevNode, CollectInfo>();
    private List<ExecuteResult> allResults = new ArrayList<ExecuteResult>();
    private boolean processFinished = false;

    public IntegrateCollectInfo(DevNode devNode) {
        this.dev = devNode;
    }

    public IntegrateCollectInfo(CollectInfo collectInfo) {
        this.dev = collectInfo.getDevNode();
        this.collectInfos.put(this.dev, collectInfo);
        this.allResults.addAll(collectInfo.getExecuteResults());
    }

    @Override
    public Map<DevNode, CollectInfo> getCollectInfoes() {
        return this.collectInfos;
    }

    @Override
    public DevNode getDevNode() {
        return this.dev;
    }

    @Override
    public void cashExecuteResult(List<ExecuteResult> results) {
        this.allResults.addAll(results);
    }

    public void initIntergrateCollectInfoes(Map<DevNode, CollectInfo> collectInfoes) {
        this.collectInfos = collectInfoes;
    }

    @Override
    public boolean isCollecting() {
        return this.collectInfos.values().stream().anyMatch(collectInfo -> collectInfo != null && collectInfo.isCollecting());
    }

    @Override
    public boolean isCollecting(DevNode devNode) {
        CollectInfo collectInfo = this.collectInfos.get(devNode);
        if (collectInfo != null) {
            return collectInfo.isCollecting(devNode);
        }
        return false;
    }

    @Override
    public void addExecuteResult(ExecuteResult executeResult) {
        CollectInfo collectInfo;
        DevNode devNode = executeResult.getDevNode();
        if (devNode == null) {
            devNode = this.dev;
        }
        if ((collectInfo = this.collectInfos.get(devNode)) != null) {
            if (executeResult.isConcurrentDepthCollect()) {
                this.addDepthItemResults(executeResult, collectInfo);
                return;
            }
            collectInfo.addExecuteResult(executeResult);
            int index = this.allResults.indexOf(executeResult);
            if (index == -1) {
                this.allResults.add(executeResult);
            } else {
                log.info("update result:{}", (Object)executeResult);
                this.allResults.set(index, executeResult);
            }
        }
    }

    private void addDepthItemResults(ExecuteResult executeResult, CollectInfo collectInfo) {
        ExecuteResultUtils.createDepthCollectItemResult(executeResult).forEach(result -> this.upgradeAllResults((ExecuteResult)result, collectInfo));
    }

    private void upgradeAllResults(ExecuteResult result, CollectInfo collectInfo) {
        collectInfo.addExecuteResult(result);
        int index = this.allResults.indexOf(result);
        if (index == -1) {
            log.info("add depth result : {}", (Object)result);
            this.allResults.add(result);
            return;
        }
        log.info("refresh depth result : {}", (Object)result);
        this.allResults.set(index, result);
    }

    @Override
    public void updateLastExecuteResult(int progress, String remainTime) {
        CollectInfo collectInfo = this.collectInfos.get(this.dev);
        if (collectInfo != null) {
            collectInfo.updateLastExecuteResult(progress, remainTime);
        }
    }

    @Override
    public void updateExecuteResult(int progress, String remainTime) {
        CollectInfo collectInfo = this.collectInfos.get(this.dev);
        if (collectInfo != null) {
            collectInfo.updateExecuteResult(progress, remainTime);
        }
    }

    @Override
    public void updateDepthCollectExecuteResult(int progress, String remainTime) {
        Optional.ofNullable(this.collectInfos.get(this.dev)).ifPresent(collectInfo -> collectInfo.updateDepthCollectExecuteResult(progress, remainTime));
    }

    @Override
    public int getLatestProgress() {
        CollectInfo collectInfo = this.collectInfos.get(this.dev);
        if (collectInfo != null) {
            return collectInfo.getLatestProgress();
        }
        return 0;
    }

    @Override
    public int getProgress() {
        CollectInfo collectInfo = this.collectInfos.get(this.dev);
        if (collectInfo != null) {
            return collectInfo.getProgress();
        }
        return 0;
    }

    @Override
    public int getDepthCollectProgress() {
        CollectInfo collectInfo = this.collectInfos.get(this.dev);
        if (collectInfo != null) {
            return collectInfo.getDepthCollectProgress();
        }
        return 0;
    }

    @Override
    public CollectConfInfo getCollectConfInfo() {
        return this.getCollectConfInfo(this.dev);
    }

    @Override
    public void setCollectConfInfo(CollectConfInfo collectConfInfo) {
        CollectInfo collectInfo = this.collectInfos.get(this.dev);
        if (collectInfo != null) {
            collectInfo.setCollectConfInfo(collectConfInfo);
        }
    }

    public void clearIntegrateInfo() {
        CollectInfo collectInfo = this.collectInfos.get(this.dev);
        this.collectInfos.clear();
        if (collectInfo != null) {
            collectInfo.resetProcessInfo();
            this.collectInfos.put(this.dev, collectInfo);
        }
    }

    @Override
    public CollectConfInfo getCollectConfInfo(DevNode devNode) {
        CollectInfo info = this.collectInfos.get(devNode);
        if (info == null) {
            return null;
        }
        return info.getCollectConfInfo();
    }

    private CollectStatus parFinalStatus(boolean hasSuc, boolean hasFail) {
        CollectStatus status = CollectStatus.COLLECT_FINISHED;
        if (hasSuc && hasFail) {
            status = CollectStatus.COLLECT_FINISHED_NOTALL;
        } else if (hasFail) {
            status = CollectStatus.COLLECT_FAILED;
        }
        return status;
    }

    @Override
    public CollectStatus getCollectStatus() {
        boolean hasSuc = false;
        boolean hasFail = false;
        Collection<CollectInfo> collectInfoesValue = this.collectInfos.values();
        for (CollectInfo collectInfo : collectInfoesValue) {
            if (collectInfo == null) continue;
            CollectStatus currentStatus = collectInfo.getCollectStatus();
            if (CollectStatus.COLLECTING.equals((Object)currentStatus) || CollectStatus.NOT_COLLECT.equals((Object)currentStatus)) {
                return currentStatus;
            }
            if (CollectStatus.COLLECT_FAILED.equals((Object)currentStatus)) {
                hasFail = true;
            }
            if (CollectStatus.COLLECT_FINISHED.equals((Object)currentStatus)) {
                hasSuc = true;
            }
            if (!CollectStatus.COLLECT_FINISHED_NOTALL.equals((Object)currentStatus)) continue;
            hasSuc = true;
            hasFail = true;
        }
        return this.parFinalStatus(hasSuc, hasFail);
    }

    @Override
    public int getCurrentProgress() {
        int result = 0;
        if (this.collectInfos == null || this.collectInfos.isEmpty()) {
            return result;
        }
        Collection<CollectInfo> collectInfoesValue = this.collectInfos.values();
        int index = 0;
        for (CollectInfo collectInfo : collectInfoesValue) {
            if (collectInfo == null) continue;
            ++index;
            result += collectInfo.getCurrentProgress();
        }
        if (index == 0) {
            return 0;
        }
        return result /= index;
    }

    @Override
    public void resetProcessInfo() {
        this.collectInfos.values().stream().filter(Objects::nonNull).forEach(CollectInfo::resetProcessInfo);
        this.allResults.clear();
    }

    @Override
    public List<ExecuteResult> getExecuteResults() {
        return this.allResults;
    }

    @Override
    public void setCollecting() {
        this.collectInfos.values().stream().filter(Objects::nonNull).forEach(CollectInfo::setCollecting);
    }

    @Override
    public void setSendMode(String receiveAddrs, TransmitStrategy strategy, int valueNum) {
        Collection<CollectInfo> collectInfoValues = this.collectInfos.values();
        for (CollectInfo current : collectInfoValues) {
            current.setSendMode(receiveAddrs, strategy, valueNum);
        }
    }

    @Override
    public String getCollectRetFilePath() {
        if (null == this.collectInfos.get(this.dev)) {
            return "";
        }
        return this.collectInfos.get(this.dev).getCollectRetFilePath();
    }

    @Override
    public boolean isProcessFinished() {
        return this.processFinished;
    }

    @Override
    public void setProcessFinished(boolean processFinished) {
        this.processFinished = processFinished;
    }
}

