/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectScene;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.tool.framwork.util.func.LocalHostUtil;

public enum ItemConditionTag {
    NO_SVP{

        @Override
        public boolean condition(DevNode devNode) {
            return LocalHostUtil.isRunInSvp();
        }
    }
    ,
    ONLY_SVP{

        @Override
        public boolean condition(DevNode devNode) {
            if (devNode == null) {
                return !LocalHostUtil.isRunInSvp();
            }
            if (!DeviceTypeUtil.hasSVPModule((DevNode)devNode)) {
                return false;
            }
            return !devNode.isIpListAreInnerIp();
        }
    }
    ,
    NO_OEMOUT{

        @Override
        public boolean condition(DevNode devNode) {
            return ApplicationContext.getInstance().isOEM();
        }
    }
    ,
    SIMPLE_COLLECT_ITEM{

        @Override
        public boolean condition(DevNode devNode) {
            return CollectDataContext.getInstance().getDevNodeCollectSceneMap().get(devNode) != CollectScene.SIMPLE_COLLECT;
        }
    }
    ,
    DEFAULT;


    public static boolean checkItemTag(String tagStrs, DevNode devNode) {
        String[] tags;
        for (String tag : tags = tagStrs.split(",")) {
            ItemConditionTag[] itemConditionTags;
            for (ItemConditionTag itemConditionTag : itemConditionTags = ItemConditionTag.values()) {
                if (!itemConditionTag.name().equalsIgnoreCase(tag) || !ItemConditionTag.isTagCondition(tag, devNode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean condition(DevNode devNode) {
        return false;
    }

    private static boolean isTagCondition(String tag, DevNode devNode) {
        return ItemConditionTag.valueOf(tag).condition(devNode);
    }
}

