/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.infocollect.entity.ProductConf;
import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageConf {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageConf.class);
    public static final String INTERGRATE_PY_NAME = "integrate_find.py";
    public static final String REAL_INTERGRATE_PY_NAME = "real_integrate_find.py";
    public static final String DATA_PY_NAME = "getdevicedate.py";
    public static final String SCRIPT_PATH = "script";
    public static final String COMMON = "common";
    public static final String COMPUTE_STORAGE_DATA_PY_NAME = "get_device_date.py";
    private String name = "";
    private Date publishDate = null;
    private String version = "";
    private String folder = "";
    private boolean compression = true;
    private List<ProductConf> productConfigs = new ArrayList<ProductConf>();
    private List<SupportVersionConf> versionConfigs = new ArrayList<SupportVersionConf>();

    public PackageConf(String name) {
        this.name = name;
    }

    public List<String> getExcludeProductsVersion() {
        ArrayList<String> results = new ArrayList<String>();
        for (ProductConf productConf : this.productConfigs) {
            results.addAll(productConf.getExcludeProductVersion());
        }
        return results;
    }

    public List<String> getSupportProductsVersion() {
        ArrayList<String> results = new ArrayList<String>();
        for (ProductConf productConf : this.productConfigs) {
            results.addAll(productConf.getSupportProductVersion());
        }
        return results;
    }

    public boolean isNew(PackageConf target) {
        Date tarDate = target.getPublishDate();
        Date sourDate = this.getPublishDate();
        if (null == tarDate || null == sourDate) {
            LOGGER.error("Could not get PublishDate!");
            return false;
        }
        return sourDate.getTime() > tarDate.getTime();
    }

    public boolean isContainDevNode(DevNode devNode) {
        if (devNode.isDsStorage()) {
            if (devNode.isFusionCube() || InfoCollectUtil.isA800Om(devNode)) {
                return this.folder.contains(devNode.getProductModel());
            }
            return this.folder.contains(devNode.getDeviceSerialNumber());
        }
        for (ProductConf productConfig : this.productConfigs) {
            if (!productConfig.isContainProduct(devNode)) continue;
            return true;
        }
        return false;
    }

    public Date getPublishDate() {
        if (null != this.publishDate) {
            return (Date)this.publishDate.clone();
        }
        return null;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = null != publishDate ? (Date)publishDate.clone() : null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public List<ProductConf> getProductConfigs() {
        return this.productConfigs;
    }

    public void setProductConfigs(List<ProductConf> productConfigs) {
        this.productConfigs = productConfigs;
    }

    public List<SupportVersionConf> getVersionConfigs() {
        return this.versionConfigs;
    }

    public void setVersionConfigs(List<SupportVersionConf> versionConfigs) {
        this.versionConfigs = versionConfigs;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PackageConf)) {
            return false;
        }
        PackageConf target = (PackageConf)object;
        return this.name.equals(target.getName());
    }

    public int hashCode() {
        return 17 + "PackageConfig".hashCode() + this.name.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        if (StringUtils.isNULLStr((String)compression)) {
            return;
        }
        this.compression = Boolean.valueOf(compression);
    }
}

