/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infocollect.entity.SupportScene;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import utils.Products;

public class ProductConf {
    private String productName = "";
    private List<String> versions = new ArrayList<String>();
    private Map<String, String> privateCollectListMap = new HashMap<String, String>();
    private List<String> excludeVersions = new ArrayList<String>();
    private List<SupportScene> supportScenes = new ArrayList<SupportScene>();
    private String shutdownHook = "";
    private String showVersion = "";

    public List<String> getSupportProductVersion() {
        List<String> showVersions = StringUtils.isNULLStr((String)this.showVersion) ? this.versions : Arrays.asList(this.showVersion.split(","));
        ArrayList<String> result = new ArrayList<String>();
        showVersions.forEach(version -> result.add(String.join((CharSequence)" ", this.productName, version)));
        return result;
    }

    public List<String> getExcludeProductVersion() {
        ArrayList<String> result = new ArrayList<String>();
        for (String version : this.excludeVersions) {
            result.add(this.productName + " " + version.trim());
        }
        return result;
    }

    public boolean isContainProduct(DevNode devNode) {
        if (ItDeviceType.T3000.equals((Object)devNode.getItDeviceType())) {
            String tempType = devNode.getDeviceType() + " " + devNode.getProductVersion();
            for (String version : this.versions) {
                if (!tempType.contains(this.checkSpace(this.productName) + " " + version)) continue;
                return true;
            }
            return false;
        }
        if (!this.productName.equalsIgnoreCase(devNode.getDeviceType().toString())) {
            return false;
        }
        String targetVersion = devNode.getProductVersion();
        for (String version : this.versions) {
            if (!Products.contains((String)version, (String)targetVersion) && !Products.contains((String)targetVersion, (String)version)) continue;
            return true;
        }
        return false;
    }

    private String checkSpace(String model) {
        byte[] tempByte = new byte[model.length()];
        int i = 0;
        int findCount = 0;
        int modelLen = model.getBytes(Charset.defaultCharset()).length;
        for (int index = 0; index < modelLen; ++index) {
            byte b = model.getBytes(Charset.defaultCharset())[index];
            if (b != 92) {
                tempByte[i] = b;
            } else if (index < modelLen && 115 == model.getBytes(Charset.defaultCharset())[index + 1]) {
                tempByte[i] = 32;
                ++index;
                ++findCount;
            }
            ++i;
        }
        return new String(tempByte, 0, tempByte.length - findCount, Charset.defaultCharset());
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public Map<String, String> getPrivateCollectListMap() {
        return this.privateCollectListMap;
    }

    public void setPrivateCollectListMap(Map<String, String> privateCollectListMap) {
        this.privateCollectListMap = privateCollectListMap;
    }

    public List<String> getExcludeVersions() {
        return this.excludeVersions;
    }

    public void setExcludeVersions(List<String> excludeVersions) {
        this.excludeVersions = excludeVersions;
    }

    public List<SupportScene> getSupportScenes() {
        return this.supportScenes;
    }

    public void setSupportScenes(List<SupportScene> supportScenes) {
        this.supportScenes = supportScenes;
    }

    public String getShutdownHook() {
        return this.shutdownHook;
    }

    public void setShutdownHook(String shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    public void setShowVersion(String showVersion) {
        this.showVersion = showVersion;
    }

    public String getShowVersion() {
        return this.showVersion;
    }
}

