/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity.command;

import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.command.ProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.entity.command.ScriptType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandConf {
    private static final Logger log = LoggerFactory.getLogger(CommandConf.class);
    private ScriptItem preScriptItem = null;
    private ScriptItem postScriptItem = null;
    private List<ScriptItem> scriptItems = new ArrayList<ScriptItem>();
    private List<ProtocolItem> protocolItems = new ArrayList<ProtocolItem>();

    public List<ScriptItem> getSelectScriptItems(List<CollectItem> collectItems) {
        ArrayList<ScriptItem> selectItems = new ArrayList<ScriptItem>();
        if (this.preScriptItem != null) {
            selectItems.add(this.preScriptItem);
        }
        for (ScriptItem scriptItem : this.scriptItems) {
            if (!this.filtrateCollectItem(scriptItem, collectItems)) continue;
            selectItems.add(scriptItem);
        }
        if (this.postScriptItem != null) {
            selectItems.add(this.postScriptItem);
        }
        return selectItems;
    }

    private boolean filtrateCollectItem(ScriptItem scriptItem, List<CollectItem> collectItems) {
        if (this.isCommonItem(scriptItem)) {
            return true;
        }
        for (CollectItem item : collectItems) {
            if (!scriptItem.getStep().equals(item.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isCommonItem(ScriptItem item) {
        return !this.isDataCollectItem(item) && !this.isFcvCollectDataItem(item) && !this.isFcvCommonItem(item);
    }

    private boolean isDataCollectItem(ScriptItem scriptItem) {
        return scriptItem.getType().equals((Object)ScriptType.DATA_COLLECT);
    }

    public List<ScriptItem> getFcvSelectScriptItems() {
        return this.scriptItems.stream().filter(this::filterFcvCollectItem).collect(Collectors.toList());
    }

    private boolean filterFcvCollectItem(ScriptItem item) {
        if (this.isFcvCommonItem(item)) {
            log.info("Add common item is {}", (Object)item.getDescriptionKey());
            return true;
        }
        if ("collect_compute_nodes".equals(item.getStep())) {
            log.info("Add collect data item is {}", (Object)item.getDescriptionKey());
            return true;
        }
        return false;
    }

    private boolean isFcvCommonItem(ScriptItem scriptItem) {
        return ScriptType.FCV_COMMON.equals((Object)scriptItem.getType());
    }

    private boolean isFcvCollectDataItem(ScriptItem scriptItem) {
        return ScriptType.FCV_DATA_COLLECT.equals((Object)scriptItem.getType());
    }

    public ScriptItem getPreScriptItem() {
        return this.preScriptItem;
    }

    public void setPreScriptItem(ScriptItem preScriptItem) {
        this.preScriptItem = preScriptItem;
    }

    public ScriptItem getPostScriptItem() {
        return this.postScriptItem;
    }

    public void setPostScriptItem(ScriptItem postScriptItem) {
        this.postScriptItem = postScriptItem;
    }

    public List<ScriptItem> getScriptItems() {
        return this.scriptItems;
    }

    public void setScriptItems(List<ScriptItem> scriptItems) {
        this.scriptItems = scriptItems;
    }

    public List<ProtocolItem> getProtocolItems() {
        return this.protocolItems;
    }

    public void setProtocolItems(List<ProtocolItem> protocolItems) {
        this.protocolItems = protocolItems;
    }
}

