/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class ExecuteResult {
    public static final int OVER_PROGRESS = 100;
    private static final int HASH_CODE_NUM = 37;
    private Date executeTime;
    private String description = null;
    private Color color = null;
    private int progress = 0;
    private int singleProgress = 0;
    private String remainTime = "";
    private Boolean result = null;
    @JsonIgnore
    private DevNode devNode = null;
    private String detail = ResourceUtil.getString((String)"infocollect.sus.info");
    private CollectStatus nowStatus = null;
    private boolean pyResult = false;
    private boolean unableSupport = false;
    private ScriptItem item;
    private boolean collectAllInfo = true;
    private ImageIcon icon = null;
    private String progressExtrasInfo = "";
    private boolean connectSshFail = false;
    private boolean isConcurrentDepthCollect = false;
    private List<String> depthCollectConcurrentItemNames = new ArrayList<String>();
    private Map<String, Map<String, Object>> resultInfoMap;

    public ExecuteResult() {
        this.executeTime = new Date();
    }

    public ExecuteResult(String description, int progress) {
        this();
        this.description = description;
        this.progress = progress;
    }

    public boolean isProcessing() {
        return this.result == null;
    }

    public boolean isStopping() {
        return this.nowStatus == CollectStatus.COLLECT_STOPPING;
    }

    public boolean isStopped() {
        return this.nowStatus == CollectStatus.COLLECT_STOPPED;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExecuteResult)) {
            return false;
        }
        ExecuteResult exResult = (ExecuteResult)object;
        return this.description.equals(exResult.getDescription()) && this.devNode.equals((Object)exResult.getDevNode());
    }

    public int hashCode() {
        return 37 + this.description.hashCode() + this.devNode.hashCode();
    }

    public Date getExecuteTime() {
        if (null != this.executeTime) {
            return (Date)this.executeTime.clone();
        }
        return null;
    }

    public String getStartDateString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.executeTime);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getResult() {
        return this.result;
    }

    public void setResult(Boolean result) {
        this.result = result;
        if (result != null && result.booleanValue()) {
            this.singleProgress = 100;
        }
    }

    public boolean isSuccess() {
        if (this.result != null) {
            return this.result;
        }
        return true;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public void appendDetail(String newDetail) {
        this.detail = this.detail == null ? newDetail : this.detail + newDetail;
    }

    public boolean getUnableSupport() {
        return this.unableSupport;
    }

    public void setUnableSupport(boolean unableSupport) {
        this.unableSupport = unableSupport;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public CollectStatus getNowStatus() {
        return this.nowStatus;
    }

    public void setNowStatus(CollectStatus nowStatus) {
        this.nowStatus = nowStatus;
    }

    public boolean isPyResult() {
        return this.pyResult;
    }

    public void setPyResult(boolean pyResult) {
        this.pyResult = pyResult;
    }

    public boolean isCollectAllInfo() {
        return this.collectAllInfo;
    }

    public void setCollectAllInfo(boolean collectAllInfo) {
        this.collectAllInfo = collectAllInfo;
    }

    public ScriptItem getItem() {
        return this.item;
    }

    public void setItem(ScriptItem item) {
        this.item = item;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getSingleProgress() {
        return this.singleProgress;
    }

    public void setSingleProgress(int singleProgress) {
        this.singleProgress = singleProgress;
    }

    public String getRemainTime() {
        return this.remainTime;
    }

    public void setRemainTime(String remainTime) {
        this.remainTime = remainTime;
    }

    public String toString() {
        return "Execute result:" + this.getResult() + "; all success: " + this.collectAllInfo;
    }

    public String getProgressExtrasInfo() {
        return this.progressExtrasInfo;
    }

    public void setProgressExtrasInfo(String progressExtrasInfo) {
        this.progressExtrasInfo = progressExtrasInfo;
    }

    public void setExecuteTime(Date executeTime) {
        this.executeTime = executeTime;
    }

    public void setConnectSshFail(boolean connectSshFail) {
        this.connectSshFail = connectSshFail;
    }

    public boolean isConnectSshFail() {
        return this.connectSshFail;
    }

    public void setConcurrentDepthCollect(boolean isConcurrentDepthCollect) {
        this.isConcurrentDepthCollect = isConcurrentDepthCollect;
    }

    public boolean isConcurrentDepthCollect() {
        return this.isConcurrentDepthCollect;
    }

    public void setDepthCollectConcurrentItemNames(List<String> depthCollectConcurrentItemNames) {
        this.depthCollectConcurrentItemNames = depthCollectConcurrentItemNames;
    }

    public List<String> getDepthCollectConcurrentItemNames() {
        return this.depthCollectConcurrentItemNames;
    }

    public void setResultInfoMap(Map<String, Map<String, Object>> resultInfoMap) {
        this.resultInfoMap = resultInfoMap;
    }

    public Map<String, Map<String, Object>> getResultInfoMap() {
        return this.resultInfoMap;
    }
}

