/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity.command;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskCons;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteResultUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecuteResultUtils.class);
    public static final int INIT_ENV_PROGRESS = 2;

    public static ExecuteResult newExeResult(int progress, Boolean isSuccess, String desString) {
        ExecuteResult result = new ExecuteResult();
        result.setNowStatus(CollectStatus.COLLECTING);
        result.setUnableSupport(false);
        result.setProgress(progress);
        result.setResult(isSuccess);
        result.setDescription(desString);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        return result;
    }

    public static List<ExecuteResult> createDepthCollectItemResult(ExecuteResult executeResult) {
        return executeResult.getDepthCollectConcurrentItemNames().stream().map(name -> ExecuteResultUtils.createExeResult(executeResult, TaskCons.DEPTH_COLLECT_ITEMS_DESCRIPTION.get(name), name)).collect(Collectors.toList());
    }

    private static ExecuteResult createExeResult(ExecuteResult executeResult, String desc, String itemName) {
        ExecuteResult result = new ExecuteResult();
        result.setDevNode(executeResult.getDevNode());
        result.setDescription(ResourceUtil.getString((String)desc));
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        result.setResult(executeResult.getResult());
        result.setProgress(executeResult.getProgress());
        result.setConcurrentDepthCollect(executeResult.isConcurrentDepthCollect());
        result.setDepthCollectConcurrentItemNames(executeResult.getDepthCollectConcurrentItemNames());
        result.setExecuteTime(executeResult.getExecuteTime());
        ExecuteResultUtils.saveCollectResult(executeResult, result, itemName);
        return result;
    }

    private static void saveCollectResult(ExecuteResult executeResult, ExecuteResult result, String itemName) {
        Map<String, Map<String, Object>> resultInfoMap = executeResult.getResultInfoMap();
        if (VerifyUtil.isEmpty(resultInfoMap)) {
            log.info("resultInfoMap is empty...");
            return;
        }
        Map<String, Object> resultMap = resultInfoMap.get(itemName);
        String errMsg = resultMap.getOrDefault("err_msg", ResourceUtil.getString((String)"infocollect.error.infocollectdetail")).toString();
        boolean isCollectSuccess = (Boolean)resultMap.getOrDefault("is_success", false);
        if (isCollectSuccess && Utils.isNullStr((String)errMsg)) {
            log.info("{} collect success.", (Object)itemName);
            return;
        }
        result.setResult(isCollectSuccess);
        result.setCollectAllInfo(false);
        result.setDetail(errMsg);
    }
}

