/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.entity.command;

import com.huawei.ism.tool.infocollect.entity.command.ProtocolItem;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPProtocolItem
extends ProtocolItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(SFTPProtocolItem.class);
    private User user = null;
    private SshConnection connection = null;

    public SFTPProtocolItem() {
        this.setProtocolName("SFTP");
    }

    public void setConnection(SshConnection connection) {
        this.connection = connection;
    }

    @Override
    public Object createProtocolObject(DevNode devNode) {
        SftpTransporter transfer = this.createSftpTransporterByConfigUser(devNode);
        if (transfer != null) {
            return transfer;
        }
        try {
            transfer = this.connection != null ? new SftpTransporter((ICliConnection)this.connection) : new SftpTransporter(devNode.getIp(), devNode.getLoginUser());
            return transfer;
        }
        catch (ToolException e) {
            LOGGER.error("init sftp object error!!!", (Throwable)e);
            return null;
        }
    }

    private SftpTransporter createSftpTransporterByConfigUser(DevNode devNode) {
        try {
            SftpTransporter transfer = null;
            if (this.user != null) {
                transfer = this.connection != null ? new SftpTransporter((ICliConnection)this.connection) : new SftpTransporter(SshConnectionManager.getSshConnection((DevNode)devNode, null, (boolean)true, (boolean)false));
            }
            return transfer;
        }
        catch (ToolException e) {
            LOGGER.error("init sftp object by config user error!!!", (Throwable)e);
            return null;
        }
    }

    public void setUser(User user) {
        this.user = user;
    }
}

