/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.export;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.export.OpenHelpCallBack;
import com.huawei.ism.tool.infocollect.service.backgroud.CollectTaskSchedule;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.util.DStoragePatchUtil;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.ToolsUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoCollectEnterAction
implements IStartAction {
    static FileOutputStream os = null;
    static FileLock lock = null;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoCollectEnterAction.class);
    private static final String BACKEND_FLAG = "backFlag";
    private static final String TOOL_RUNNING_FLAG = "runningFlag";
    private Window parent = null;
    private InfoCollectMainDialog dialog;

    public InfoCollectEnterAction(Window parentFrame) {
        this.parent = parentFrame;
    }

    public Window getParent() {
        return this.parent;
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public void actionPerformed(Window window, ActionEvent actionEvent) {
        this.loadInfo();
        if (CollectDataContext.getInstance().isForeground()) {
            this.startForegroundProcess(window);
        } else {
            this.startBackgroundProcess();
        }
    }

    public static void addBackgroundLock() {
        block20: {
            try {
                if (ApplicationContext.getInstance().isWindowsOS()) {
                    os = new FileOutputStream(BACKEND_FLAG);
                    lock = os.getChannel().tryLock();
                    break block20;
                }
                try (FileChannel channel = InfoCollectEnterAction.lockInLinuxAndGetChannel();){
                    ToolsUtils.writeParentPidToBackFlagFileOnLinux((FileChannel)channel);
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error("Get channel failed...");
                }
            }
            catch (FileNotFoundException | RuntimeException e) {
                LOGGER.error("Obtained back lock failed...");
            }
            catch (IOException e) {
                LOGGER.error("Could not lock on this channel.");
                try {
                    lock.release();
                }
                catch (IOException e1) {
                    LOGGER.error("Release lock fail.");
                }
            }
        }
    }

    private static FileChannel lockInLinuxAndGetChannel() throws IOException, InterruptedException {
        FileChannel channel = new RandomAccessFile(new File(BACKEND_FLAG), "rw").getChannel();
        while (lock == null) {
            lock = channel.tryLock();
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return channel;
    }

    private void loadInfo() {
        String mode = System.getenv("startMode");
        LOGGER.info("The start mode is {}", (Object)StringUtils.getCleanMessage((String)mode));
        CollectDataContext.getInstance().setForeground(null == mode || !"1".equals(mode));
        CollectDataContext.getInstance().setFoolkitZhCn(Boolean.valueOf(System.getenv("toolkit.app.zh.version")));
        DStoragePatchUtil.initPatchConfig();
    }

    private void startBackgroundProcess() {
        try {
            LOGGER.info("Start the backgound process...");
            CollectDataContext.getInstance().setBackground(true);
            this.releaseForegroundLock();
            InfoCollectEnterAction.addBackgroundLock();
            InfoConfiguration.getInstance().init();
            new CollectTaskSchedule().startSchedule();
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            Runtime.getRuntime().exit(20);
        }
    }

    private void startForegroundProcess(Window window) {
        File file = new File(BACKEND_FLAG);
        if (!file.exists() || file.exists() && file.delete()) {
            LOGGER.info("Start the foregound process...");
            if (!CollectDataContext.getInstance().isToolkitEnv()) {
                InfoConfiguration.getInstance().init();
                CollectTaskSchedule schedule = new CollectTaskSchedule();
                schedule.startSchedule();
            }
            this.openUI();
        } else {
            LOGGER.info("Backgound process is running, cannot start the tool");
            DialogUtils.showInfoDialog((Window)(window == null ? new JDialog() : window), (String)ResourceUtil.getString((String)"inspector.background.process.running"));
            CollectDataContext.getInstance().fireToolStopped();
        }
    }

    private void openUI() {
        this.dialog = new InfoCollectMainDialog(this.parent);
        this.dialog.setHelpActionCallBack(new OpenHelpCallBack(this.dialog));
        CollectUIContext.getInstance().setMainDialog(this.dialog);
        this.dialog.setVisible(true);
    }

    public void releaseForegroundLock() {
        try (FileOutputStream fos = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getToolLockStream();){
            LOGGER.info("Start to release lock {}", (Object)fos.getFD());
        }
        catch (IOException e) {
            LOGGER.error("Release lock error", (Throwable)e);
        }
        File file = new File(TOOL_RUNNING_FLAG);
        if (file.exists()) {
            boolean result = file.delete();
            LOGGER.info("Release front lock {}", (Object)result);
        }
    }

    public void releaseBackgroundLock() {
        try {
            if (null != lock) {
                lock.release();
            }
        }
        catch (IOException e) {
            LOGGER.error("Release Lock fail.");
        }
        finally {
            StreamUtils.closeStream((OutputStream)os, null);
        }
    }
}

