/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginManager;
import com.huawei.fitframework.runtime.PluginActivator;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.fit.task.DevNodeManager;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.sdk.unified.log.UnifiedLogConfigurator;
import com.huawei.ism.tool.sdk.unified.log.exception.UnifiedLogException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

@Fitable
public class PluginActivatorImpl
implements PluginActivator {
    private static final Logger log = LoggerFactory.getLogger(PluginActivatorImpl.class);
    private static final String PLUGIN_ID = "collect";
    @Fit
    PluginManager manager;
    @Fit
    DevNodeManager devNodeManager;

    public void start() {
        try {
            UnifiedLogConfigurator.initializeWithDefaultConfig();
        }
        catch (UnifiedLogException exception) {
            log.error("initialize unified log config failed", (Throwable)exception);
        }
        Optional opt = this.manager.get(PLUGIN_ID);
        if (!opt.isPresent()) {
            throw new FitException("can not find plugin collect");
        }
        File file = ((Plugin)opt.get()).getBaseDirectory();
        try {
            FrameworkInitiator.init((String)file.getCanonicalPath());
            LanguageManager.getInstance().setCurrentLanguage(PluginActivatorImpl.getLan(System.getenv("language")));
            InfoConfiguration.getInstance().init();
            FrameworkInitiator.loadServiceFromCfg();
            this.devNodeManager.loadDeviceFromToolBox();
        }
        catch (IOException e) {
            throw new FitException("collect init failed.", (Throwable)e);
        }
    }

    private static Locale getLan(String language) {
        Locale lan = Locale.ENGLISH;
        if (!StringUtils.isNULLStr((String)language) && language.startsWith("zh")) {
            lan = Locale.SIMPLIFIED_CHINESE;
        }
        return lan;
    }

    public void stop() {
        log.info("Exit plugin {}", (Object)PLUGIN_ID);
        CollectDataContext.getInstance().clear();
        InfoConfiguration.getInstance().clear();
        this.clearDistributedStorageResource();
    }

    private void clearDistributedStorageResource() {
        CollectDeviceService.getDeviceHasDownResFile().stream().map(sn -> Paths.get(BizPackageService.PACKAGE_PRODUCTS_DIR, "Dstorage_", sn).toFile()).forEach(FilesUtil::clearFolder);
    }
}

