/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.hardwareinfo.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.GeneralTask;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.HardwareInfoCollectTask;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.TaskProvider;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.CollectLldInfo;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryCollectDetail;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryTaskOverView;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectDevDetailDTO;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectDevOverViewDTO;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectItemDetailDTO;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectLldDevParam;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.MultiCollectDevOverViewDTO;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class CollectInfoFitImpl {
    private static final Logger log = LoggerFactory.getLogger(CollectInfoFitImpl.class);
    @Fit
    private TaskProvider taskProvider;

    @Fitable(generic=CollectLldInfo.class, id="152926b78b654b108e0f94a77f107457")
    public Response<String> collectLldInfo(CollectLldDevParam collectLldDevParam) {
        try {
            this.taskProvider.collectHardwareInfo(collectLldDevParam);
            return ResponseUtil.success((Object)"");
        }
        catch (ToolException e) {
            log.error("collectLldInfo fail.", (Throwable)e);
            return ResponseUtil.failed((String)e.getErrorLocaleDescription(), (String)"");
        }
    }

    @Fitable(generic=QueryCollectDetail.class, id="85177609544346eaad90828a8c7ac4d8")
    public Response<CollectDevDetailDTO> queryCollectDetail(String taskId, String devId) {
        Optional<HardwareInfoCollectTask> task = this.taskProvider.findTask(taskId, devId);
        if (!task.isPresent()) {
            return ResponseUtil.failed((String)ResourceUtil.getString((String)"hardware.collect.task.not.exist"), (String)"");
        }
        return ResponseUtil.success((Object)CollectDevDetailDTO.builder().collectItemDetailDTO(Collections.singletonList(this.convertItem(task.get()))).build());
    }

    @Fitable(generic=QueryTaskOverView.class, id="c6377529286e4f09a349ae9c78a20ca5")
    public Response<MultiCollectDevOverViewDTO> queryTaskOverView(String taskId) {
        List<HardwareInfoCollectTask> tasks = this.taskProvider.findTasks(taskId);
        TaskStatistics taskStatistics = this.convertStatistics(tasks);
        List collectDevOverViewDTO = tasks.stream().map(this::convertDev).collect(Collectors.toList());
        return ResponseUtil.success((Object)MultiCollectDevOverViewDTO.builder().taskStatistics(taskStatistics).collectDevOverViewDTO(collectDevOverViewDTO).build());
    }

    private CollectItemDetailDTO convertItem(HardwareInfoCollectTask hardwareInfoCollectTask) {
        return CollectItemDetailDTO.builder().startTime(hardwareInfoCollectTask.getStartTimeString()).name(ResourceUtil.getString((String)"hardware.collect.task.name")).progress(Double.valueOf(hardwareInfoCollectTask.getProgress())).result(Boolean.valueOf(hardwareInfoCollectTask.isSuccess())).detail(hardwareInfoCollectTask.getErrorMessage()).status(hardwareInfoCollectTask.getState().name()).build();
    }

    private TaskStatistics convertStatistics(List<HardwareInfoCollectTask> tasks) {
        return TaskStatistics.builder().successNum(Integer.valueOf(Math.toIntExact(tasks.stream().filter(GeneralTask::isSuccess).count()))).failedNum(Integer.valueOf(Math.toIntExact(tasks.stream().filter(GeneralTask::isError).count()))).noExecutedNum(Integer.valueOf(Math.toIntExact(tasks.stream().filter(GeneralTask::isNotStart).count()))).runningNum(Integer.valueOf(Math.toIntExact(tasks.stream().filter(GeneralTask::isRunning).count()))).build();
    }

    private CollectDevOverViewDTO convertDev(HardwareInfoCollectTask hardwareInfoCollectTask) {
        Server server = hardwareInfoCollectTask.getServer();
        return CollectDevOverViewDTO.builder().name(server == null ? "--" : server.getProductName()).model(server == null ? "--" : server.getModel()).version("").ip(server == null ? "--" : server.getBmcIp()).progress(Double.valueOf(hardwareInfoCollectTask.getProgress())).status(hardwareInfoCollectTask.getState().name()).sn("").build();
    }
}

