/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.hardwareinfo.task;

import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.State;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public class GeneralTask {
    private State state = State.WAITED;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private String errorMessage;

    public boolean isNotStart() {
        return Optional.ofNullable(this.state).map(State.WAITED::equals).orElse(false);
    }

    public boolean isError() {
        return Optional.ofNullable(this.state).map(State.FAILED::equals).orElse(false);
    }

    public boolean isRunning() {
        return Optional.ofNullable(this.state).map(State.RUNNING::equals).orElse(false);
    }

    public boolean isSuccess() {
        return Optional.ofNullable(this.state).map(State.SUCCESS::equals).orElse(false);
    }

    public void start() {
        this.startTime = LocalDateTime.now();
        this.state = State.RUNNING;
    }

    public void success() {
        this.endTime = LocalDateTime.now();
        this.state = State.SUCCESS;
    }

    public void error(String errorMessage) {
        this.endTime = LocalDateTime.now();
        this.state = State.FAILED;
        this.errorMessage = errorMessage;
    }

    public String getStartTimeString() {
        return this.startTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public double getProgress() {
        return this.isSuccess() ? 100.0 : 0.0;
    }

    public State getState() {
        return this.state;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

