/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.hardwareinfo.task;

import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.base.IpAddress;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.raid.RaidBoardInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.ChassisInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.DeviceMaxNum;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.disk.DiskInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.memory.MemoryInformation;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.Controller;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.NetCardHuawei;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.NetCardInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.netport.NetPortInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.netrelateport.NetRelatedPortInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.pcie.PcieInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.pcie.function.PcieFunctionHuawei;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.pcie.function.PcieFunctionInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.processer.ProcessorInformation;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.raid.RaidHuawei;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.raid.StorageController;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.detail.SystemDetailInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.manager.ManagerDetailInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Chassis;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Disk;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Memory;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.NetCard;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Pcie;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Processor;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Raid;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface HardwareAssembler {
    public Processor toExlData(ProcessorInformation var1);

    @Mapping(target="name", source="id")
    public Memory toExlData(MemoryInformation var1);

    @Mappings(value={@Mapping(target="deviceBdfFunction", source="huawei.deviceBDF.function"), @Mapping(target="deviceBdfDevice", source="huawei.deviceBDF.device"), @Mapping(target="deviceBdfBus", source="huawei.deviceBDF.bus"), @Mapping(target="deviceLocator", source="pcieInfo.oem.huawei.deviceLocator"), @Mapping(target="position", source="pcieInfo.oem.huawei.position"), @Mapping(target="functionType", source="pcieInfo.oem.huawei.functionType"), @Mapping(target="state", source="pcieInfo.status.state"), @Mapping(target="health", source="pcieInfo.status.health")})
    public Pcie toExlData(PcieInfo var1, PcieFunctionInfo var2, PcieFunctionHuawei var3);

    @Mappings(value={@Mapping(target="controllerName", source="storageController.name"), @Mapping(target="manufacturer", source="storageController.manufacturer"), @Mapping(target="supportedRAIDLevels", source="huawei.supportedRAIDLevels")})
    public Raid toExlData(StorageController var1, RaidHuawei var2, String var3, RaidBoardInfo var4);

    @Mappings(value={@Mapping(target="slotNumber", source="diskInfo.oem.huawei.slotNumber"), @Mapping(target="enclosureDeviceId", source="diskInfo.oem.huawei.enclosureDeviceId")})
    public Disk toExlData(DiskInfo var1);

    @Mappings(value={@Mapping(target="portType", source="netPortInfo.oem.huawei.portType"), @Mapping(target="interfaceType", source="netRelatedPortInfo.oem.huawei.interfaceType"), @Mapping(target="firmwarePackageVersion", expression="java(toFirmwarePackageVersion(netCardInfo))"), @Mapping(target="name", source="netCardInfo.name"), @Mapping(target="linkStatus", source="netRelatedPortInfo.linkStatus")})
    public NetCard toExlData(NetCardInfo var1, NetCardHuawei var2, NetPortInfo var3, NetRelatedPortInfo var4);

    @Mappings(value={@Mapping(target="productUniqueID", source="managers.oem.huawei.productUniqueID"), @Mapping(target="productName", source="system.oem.huawei.productName"), @Mapping(target="productAlias", source="system.oem.huawei.productAlias"), @Mapping(target="assetTag", source="system.assetTag"), @Mapping(target="hostName", source="managers.oem.huawei.hostName")})
    public Chassis toExlData(ChassisInfo var1, DeviceMaxNum var2, SystemDetailInfo var3, ManagerDetailInfo var4);

    default public String toStr(List<String> strings) {
        if (CollectionUtil.isEmpty(strings)) {
            return "";
        }
        return String.join((CharSequence)",", strings);
    }

    default public String toIpStr(List<IpAddress> ipAddresses) {
        if (CollectionUtil.isEmpty(ipAddresses)) {
            return "";
        }
        return ipAddresses.stream().map(IpAddress::getAddress).collect(Collectors.joining(","));
    }

    default public String toFirmwarePackageVersion(NetCardInfo netCardInfo) {
        return Optional.ofNullable(netCardInfo.getControllers()).map(controllers -> (Controller)controllers.get(0)).map(Controller::getFirmwarePackageVersion).orElse("");
    }
}

