/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.hardwareinfo.task;

import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.RedFishApi;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.base.IpAddress;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.base.Member;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.base.MemberList;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.BoardHuawei;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.BoardInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.BoardMember;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.BoardOem;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.RaidCard;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.raid.RaidBoardInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.ChassisHuawei;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.ChassisInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.ChassisOem;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.DeviceMaxNum;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.Links;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.ipaddress.EthernetInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.version.BmcVersion;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.version.SpInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.disk.DiskInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.memory.MemoryList;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.Controller;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.NetCardInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.NetworkAdapters;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.netport.NetPordOem;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.netport.NetPortHuawei;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.netport.NetPortInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.netrelateport.NetRelatedPortInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.pcie.Link;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.pcie.PcieInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.pcie.function.PcieFunctionInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.processer.Processor;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.raid.RaidHuawei;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.raid.RaidInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.raid.RaidOem;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.raid.StorageController;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.BmcSystem;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.Managers;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.System;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.SystemChassisInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.detail.SystemDetailInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.manager.ManagerDetailInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.user.BmcUser;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.GeneralTask;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.HardwareAssembler;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Chassis;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.HardwareInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.NetCard;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Pcie;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.Raid;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity.SystemInfo;
import com.huawei.ism.tool.infocollect.util.excel.ExcelUtils;
import com.huawei.ism.tool.infocollect.util.retrofit.RetrofitException;
import com.huawei.ism.tool.infocollect.util.retrofit.RetrofitRequestUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.auth.entity.LoginUser;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class HardwareInfoCollectTask
extends GeneralTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(HardwareInfoCollectTask.class);
    private static final HardwareAssembler ASSEMBLER = (HardwareAssembler)Mappers.getMapper(HardwareAssembler.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String X_AUTH_TOKEN = "X-Auth-Token";
    private final String devId;
    private final Server server;
    private final String resultDir;
    private final String taskId;
    private final Map<String, String> headers = new HashMap<String, String>();
    private RedFishApi redFishApi;
    private HardwareInfo hardwareInfo;
    private BmcVersion activeBmcVersion;
    private BmcVersion backUpBmcVersion;
    private int pcieCount;

    @Override
    public void run() {
        this.start();
        try {
            this.init();
            this.collectInfo();
            this.success();
        }
        catch (ToolException e) {
            log.error("HardwareInfoCollectTask fail.", (Throwable)e);
            this.error(e.getErrorLocaleDescription());
        }
        catch (RetrofitException e) {
            log.error("HardwareInfoCollectTask fail.", (Throwable)e);
            this.error(ResourceUtil.getString((String)e.getMessage()));
        }
    }

    private void init() throws ToolException {
        this.checkServerInfo();
        this.redFishApi = RetrofitRequestUtils.createRequestApi(this.server.getBmcIp(), RedFishApi.class);
        this.headers.put(CONTENT_TYPE, "application/json");
        this.headers.put(X_AUTH_TOKEN, this.getToken());
        this.hardwareInfo = new HardwareInfo();
        this.hardwareInfo.setNodeManagementIP(this.server.getBmcIp());
    }

    private void collectInfo() throws ToolException {
        BmcSystem bmcSystem = (BmcSystem)RetrofitRequestUtils.query(() -> this.redFishApi.getSystemInfo(this.headers));
        this.activeBmcVersion = (BmcVersion)RetrofitRequestUtils.query(() -> this.redFishApi.getActiveBMC(this.headers));
        this.backUpBmcVersion = (BmcVersion)RetrofitRequestUtils.query(() -> this.redFishApi.getBackupBMC(this.headers));
        ArrayList<RaidBoardInfo> raidBoardInfos = new ArrayList<RaidBoardInfo>();
        if (CollectionUtils.isNotEmpty(bmcSystem.getChassis())) {
            bmcSystem.getChassis().forEach(chassis -> {
                ChassisInfo chassisInfo = (ChassisInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getChassis(this.headers, chassis.getId()));
                this.collectPcieInfo(chassisInfo);
                this.collectNetworkAdapter(chassisInfo);
                this.collectDiskInfo(chassisInfo);
                this.collectChassis(chassisInfo, bmcSystem, (SystemChassisInfo)chassis);
                raidBoardInfos.addAll(this.getRiadBoardInfo(chassisInfo));
            });
        }
        ArrayList<RaidInfo> raidStorageInfo = new ArrayList<RaidInfo>();
        ArrayList systemInfos = new ArrayList();
        if (CollectionUtils.isNotEmpty(bmcSystem.getSystems())) {
            bmcSystem.getSystems().forEach(system -> {
                String systemId = system.getId();
                this.collectMemory(systemId);
                this.collectProcessor(systemId);
                systemInfos.add(SystemInfo.builder().systemSerialNumber(system.getSystemSerialNumber()).build());
                raidStorageInfo.addAll(this.getRaidStorageInfo(systemId));
            });
        }
        this.hardwareInfo.getSystems().addAll(systemInfos);
        this.collectRaidInfo(raidBoardInfos, raidStorageInfo);
        ExcelUtils.exportData(this.hardwareInfo.toSheetDataMap(), Paths.get(this.resultDir, String.format("%s_%s.xlsx", "HardwareInfo", this.taskId)), "/config/template/HardwareInfoTemplate.xlsx");
    }

    private void collectChassis(ChassisInfo chassisInfo, BmcSystem bmcSystem, SystemChassisInfo chassis) {
        Optional<System> systemInfo = this.getSystemInfo(chassisInfo, bmcSystem);
        SystemDetailInfo system = systemInfo.map(System::getId).map(id -> (SystemDetailInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getSystemDetail(this.headers, (String)id))).orElse(null);
        Optional<Managers> manager = this.getManagers(chassisInfo, bmcSystem);
        ManagerDetailInfo managers = manager.map(Managers::getId).map(id -> (ManagerDetailInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getManagerDetail(this.headers, (String)id))).orElse(null);
        Chassis chassisData = ASSEMBLER.toExlData(chassisInfo, this.getDeviceMaxNum(chassisInfo), system, managers);
        manager.ifPresent(managerInfo -> chassisData.fillIp(this.getIpV6Address((Managers)managerInfo)));
        chassisData.fillNum(systemInfo.orElse(null), chassis, this.pcieCount);
        this.fillVersion(chassisInfo, managers, chassisData);
        this.hardwareInfo.getChassis().add(chassisData);
    }

    private void fillVersion(ChassisInfo chassisInfo, ManagerDetailInfo managers, Chassis chassisData) {
        RaidBoardInfo boardInfo = (RaidBoardInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getMainBoardInfo(chassisInfo.getId(), this.headers));
        SpInfo spInfo = null;
        try {
            spInfo = Optional.ofNullable(managers).map(ManagerDetailInfo::getId).map(id -> (SpInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getSpInfo(this.headers, (String)id))).orElse(null);
        }
        catch (RetrofitException e) {
            log.error("query sp version info failed.", (Throwable)e);
        }
        chassisData.fillVersion(this.activeBmcVersion, this.backUpBmcVersion, boardInfo, spInfo);
    }

    private void collectRaidInfo(List<RaidBoardInfo> raidBoardInfos, List<RaidInfo> raidInfos) {
        if (CollectionUtils.isEmpty(raidBoardInfos) || CollectionUtils.isEmpty(raidInfos)) {
            return;
        }
        ArrayList raids = new ArrayList();
        raidInfos.stream().filter(raidInfo -> CollectionUtils.isNotEmpty(raidInfo.getStorageControllers())).forEach(raidInfo -> this.createRaids(raidBoardInfos, raids, (RaidInfo)raidInfo));
        this.hardwareInfo.getRaids().addAll(raids);
    }

    private void collectProcessor(String systemId) {
        Processor processor = (Processor)RetrofitRequestUtils.query(() -> this.redFishApi.getProcessors(this.headers, systemId));
        if (CollectionUtils.isEmpty(processor.getInformation())) {
            return;
        }
        this.hardwareInfo.getProcessors().addAll(processor.getInformation().stream().map(ASSEMBLER::toExlData).collect(Collectors.toList()));
    }

    private void collectMemory(String systemId) {
        MemoryList memory = (MemoryList)RetrofitRequestUtils.query(() -> this.redFishApi.getMemory(this.headers, systemId));
        if (CollectionUtils.isEmpty(memory.getInformation())) {
            return;
        }
        MemberList memoryMember = (MemberList)RetrofitRequestUtils.query(() -> this.redFishApi.getMemoryMember(this.headers, systemId));
        if (CollectionUtils.isEmpty(memoryMember.getMembers())) {
            return;
        }
        List memberUrls = memoryMember.getMembers().stream().map(Member::getDataId).collect(Collectors.toList());
        this.hardwareInfo.getMemories().addAll(memory.getInformation().stream().filter(info -> memberUrls.stream().anyMatch(url -> url.contains(info.getId()))).map(ASSEMBLER::toExlData).collect(Collectors.toList()));
    }

    private void collectDiskInfo(ChassisInfo chassisInfo) {
        List drives = Optional.of(chassisInfo).map(ChassisInfo::getLinks).map(Links::getDrives).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(drives)) {
            return;
        }
        this.hardwareInfo.getDisks().addAll(drives.stream().map(drive -> (DiskInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getDiskInfo(drive.getDataId(), this.headers))).map(ASSEMBLER::toExlData).collect(Collectors.toList()));
    }

    private void collectPcieInfo(ChassisInfo chassisInfo) {
        List pcieDevices = Optional.of(chassisInfo).map(ChassisInfo::getLinks).map(Links::getPCIeDevices).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(pcieDevices)) {
            return;
        }
        this.pcieCount = pcieDevices.size();
        ArrayList pcieList = new ArrayList();
        pcieDevices.stream().map(pcieDevice -> (PcieInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getPcieInfo(pcieDevice.getDataId(), this.headers))).forEach(pcieInfo -> this.fillPcie(pcieList, (PcieInfo)pcieInfo));
        this.hardwareInfo.getPcies().addAll(pcieList);
    }

    private void collectNetworkAdapter(ChassisInfo chassisInfo) {
        NetworkAdapters networkAdapters = (NetworkAdapters)RetrofitRequestUtils.query(() -> this.redFishApi.getNetworkAdapters(chassisInfo.getNetworkAdapters().getDataId(), this.headers));
        if (CollectionUtils.isEmpty(networkAdapters.getMembers())) {
            return;
        }
        ArrayList netCards = new ArrayList();
        networkAdapters.getMembers().stream().map(member -> (NetCardInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getNetCardInfo(member.getDataId(), this.headers))).forEach(netCard -> this.fillNetCard(netCards, (NetCardInfo)netCard));
        this.hardwareInfo.getNetCards().addAll(netCards);
    }

    @Nullable
    private DeviceMaxNum getDeviceMaxNum(ChassisInfo chassisInfo) {
        return Optional.of(chassisInfo).map(ChassisInfo::getOem).map(ChassisOem::getHuawei).map(ChassisHuawei::getDeviceMaxNum).orElse(null);
    }

    private List<IpAddress> getIpV6Address(Managers manager) {
        return Optional.ofNullable(manager.getId()).map(id -> (BoardMember)RetrofitRequestUtils.query(() -> this.redFishApi.getEthernetMember((String)id, this.headers))).map(BoardMember::getMembers).orElse(Collections.emptyList()).stream().map(Member::getDataId).map(url -> (EthernetInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getEthernetInfo((String)url, this.headers))).flatMap(ethernetInfo -> ethernetInfo.getIPv6Addresses().stream()).collect(Collectors.toList());
    }

    private void fillPcie(List<Pcie> pcieList, PcieInfo pcieInfo) {
        List functions = Optional.of(pcieInfo).map(PcieInfo::getLinks).map(Link::getPCIeFunctions).orElse(Collections.emptyList());
        if (functions.isEmpty()) {
            pcieList.add(ASSEMBLER.toExlData(pcieInfo, null, null));
            return;
        }
        pcieList.addAll(functions.stream().map(Member::getDataId).filter(Objects::nonNull).map(functionUrl -> (PcieFunctionInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getPcieFunction((String)functionUrl, this.headers))).map(pcieFunctionInfo -> ASSEMBLER.toExlData(pcieInfo, (PcieFunctionInfo)pcieFunctionInfo, pcieFunctionInfo.getOem().getHuawei())).collect(Collectors.toList()));
    }

    private void fillNetCard(List<NetCard> netCards, NetCardInfo netCard) {
        if (CollectionUtils.isEmpty(netCard.getControllers())) {
            netCards.add(ASSEMBLER.toExlData(netCard, netCard.getOem().getHuawei(), null, null));
        }
        netCard.getControllers().stream().map(Controller::getLinks).map(com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.netcard.Links::getNetworkPorts).flatMap(Collection::stream).forEach(link -> netCards.add(this.getNetCardFullInfo(netCard, (Member)link)));
    }

    private NetCard getNetCardFullInfo(NetCardInfo netCard, Member link) {
        NetPortInfo netPortInfo = (NetPortInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getNetPort(link.getDataId(), this.headers));
        String relatedPortUrl = Optional.of(netPortInfo).map(NetPortInfo::getOem).map(NetPordOem::getHuawei).map(NetPortHuawei::getRelatedPort).map(Member::getDataId).orElse("");
        NetRelatedPortInfo netRelatedPortInfo = null;
        if (StringUtils.isNotEmpty((String)relatedPortUrl)) {
            netRelatedPortInfo = (NetRelatedPortInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getNetRelatedPort(relatedPortUrl, this.headers));
        }
        return ASSEMBLER.toExlData(netCard, netCard.getOem().getHuawei(), netPortInfo, netRelatedPortInfo);
    }

    private Optional<Managers> getManagers(ChassisInfo chassisInfo, BmcSystem bmcSystem) {
        if (CollectionUtils.isEmpty(bmcSystem.getManagers())) {
            return Optional.empty();
        }
        return bmcSystem.getManagers().stream().filter(manager -> Objects.equals(manager.getId(), chassisInfo.getId())).findFirst();
    }

    private Optional<System> getSystemInfo(ChassisInfo chassisInfo, BmcSystem bmcSystem) {
        if (CollectionUtils.isEmpty(bmcSystem.getSystems())) {
            return Optional.empty();
        }
        return bmcSystem.getSystems().stream().filter(system -> Objects.equals(system.getId(), chassisInfo.getId())).findFirst();
    }

    private void createRaids(List<RaidBoardInfo> raidBoardInfos, List<Raid> raids, RaidInfo raidInfo) {
        raidInfo.getStorageControllers().forEach(storageController -> {
            String raidCardBoardUrl = this.getRaidCardBoardUrl((StorageController)storageController);
            if (StringUtils.isEmpty((String)raidCardBoardUrl)) {
                return;
            }
            raids.add(ASSEMBLER.toExlData((StorageController)storageController, storageController.getOem().getHuawei(), raidInfo.getName(), this.getRaidBoardInfo(raidBoardInfos, raidCardBoardUrl)));
        });
    }

    @Nullable
    private RaidBoardInfo getRaidBoardInfo(List<RaidBoardInfo> raidBoardInfos, String raidCardBoardUrl) {
        return raidBoardInfos.stream().filter(raidBoardInfo -> raidCardBoardUrl.contains(raidBoardInfo.getId())).findFirst().orElse(null);
    }

    private String getRaidCardBoardUrl(StorageController storageController) {
        return Optional.ofNullable(storageController.getOem()).map(RaidOem::getHuawei).map(RaidHuawei::getAssociatedCard).map(Member::getDataId).orElse("");
    }

    private List<RaidBoardInfo> getRiadBoardInfo(ChassisInfo chassisInfo) {
        BoardMember boardMember = (BoardMember)RetrofitRequestUtils.query(() -> this.redFishApi.getBoardMember(chassisInfo.getId(), this.headers));
        List boardRaids = Optional.of(boardMember).map(BoardMember::getOem).map(BoardOem::getHuawei).map(BoardHuawei::getBoards).map(BoardInfo::getRAIDCard).map(RaidCard::getLinks).orElse(Collections.emptyList());
        return boardRaids.stream().map(boardRaid -> (RaidBoardInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getRaidBoardInfo(boardRaid.getDataId(), this.headers))).collect(Collectors.toList());
    }

    private List<RaidInfo> getRaidStorageInfo(String systemId) {
        MemberList raidMember = (MemberList)RetrofitRequestUtils.query(() -> this.redFishApi.getRaidMember(this.headers, systemId));
        if (CollectionUtils.isEmpty(raidMember.getMembers())) {
            return Collections.emptyList();
        }
        return raidMember.getMembers().stream().map(member -> (RaidInfo)RetrofitRequestUtils.query(() -> this.redFishApi.getRaidStorageInfo(member.getDataId(), this.headers))).collect(Collectors.toList());
    }

    private void checkServerInfo() throws ToolException {
        if (this.server == null || StringUtils.isEmpty((String)this.server.getBmcIp())) {
            throw new ToolException("hardware.server.bmc.info");
        }
        LoginUser loginUser = this.server.getLoginUser();
        if (loginUser == null || StringUtils.isEmpty((String)loginUser.getName()) || StringUtils.isEmpty((String)loginUser.getPwd())) {
            throw new ToolException("hardware.server.bmc.info");
        }
    }

    private String getToken() throws ToolException {
        try {
            String password = AESEncrypt.decrypt((String)this.server.getLoginUser().getPwd());
            Response loginResponse = this.redFishApi.login(BmcUser.builder().userName(this.server.getLoginUser().getName()).password(password).build()).execute();
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)password);
            return Optional.of(loginResponse).map(Response::headers).map(p -> p.get(X_AUTH_TOKEN)).orElseThrow(() -> new ToolException("hardware.server.bmc.login"));
        }
        catch (IOException e) {
            log.error("bmc login error", (Throwable)e);
            throw new ToolException("hardware.server.bmc.login");
        }
    }

    public String getDevId() {
        return this.devId;
    }

    public Server getServer() {
        return this.server;
    }

    public String getResultDir() {
        return this.resultDir;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public RedFishApi getRedFishApi() {
        return this.redFishApi;
    }

    public HardwareInfo getHardwareInfo() {
        return this.hardwareInfo;
    }

    public BmcVersion getActiveBmcVersion() {
        return this.activeBmcVersion;
    }

    public BmcVersion getBackUpBmcVersion() {
        return this.backUpBmcVersion;
    }

    public int getPcieCount() {
        return this.pcieCount;
    }

    public HardwareInfoCollectTask(String devId, Server server, String resultDir, String taskId) {
        this.devId = devId;
        this.server = server;
        this.resultDir = resultDir;
        this.taskId = taskId;
    }
}

