/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.hardwareinfo.task;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.HardwareInfoCollectTask;
import com.huawei.ism.tool.infocollect.fit.task.ExecuteTaskManager;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectLldDevParam;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import utils.FilesUtil;

@Fitable
public class TaskProvider {
    private static final Map<String, List<HardwareInfoCollectTask>> taskCache = new ConcurrentHashMap<String, List<HardwareInfoCollectTask>>();
    @Fit
    private QueryServer queryServer;

    public void collectHardwareInfo(CollectLldDevParam collectLldDevParam) throws ToolException {
        this.checkParam(collectLldDevParam);
        List<HardwareInfoCollectTask> tasks = collectLldDevParam.getDevIds().stream().map(devId -> this.generateTask((String)devId, collectLldDevParam)).collect(Collectors.toList());
        taskCache.put(collectLldDevParam.getTaskId(), tasks);
        tasks.forEach(ExecuteTaskManager.DEV_EXECUTOR::execute);
    }

    public Optional<HardwareInfoCollectTask> findTask(String taskId, String devId) {
        return this.findTasks(taskId).stream().filter(task -> Objects.equals(task.getDevId(), devId)).findFirst();
    }

    public List<HardwareInfoCollectTask> findTasks(String taskId) {
        return taskCache.getOrDefault(taskId, Collections.emptyList());
    }

    private HardwareInfoCollectTask generateTask(String devId, CollectLldDevParam collectLldDevParam) {
        Server server = this.queryServer.process(devId);
        return new HardwareInfoCollectTask(devId, server, collectLldDevParam.getResultDir(), collectLldDevParam.getTaskId());
    }

    private void checkParam(CollectLldDevParam collectLldDevParam) throws ToolException {
        if (StringUtils.isEmpty((String)collectLldDevParam.getTaskId()) || CollectionUtils.isEmpty((Collection)collectLldDevParam.getDevIds())) {
            throw new ToolException("hardware.collect.param");
        }
        if (!this.isResultDirValid(collectLldDevParam.getResultDir())) {
            throw new ToolException("hardware.collect.dir");
        }
    }

    private boolean isResultDirValid(String resultDir) {
        if (StringUtils.isEmpty((String)resultDir)) {
            return false;
        }
        if (!FilesUtil.checkNormalPath((String)resultDir)) {
            return false;
        }
        File file = new File(resultDir);
        return file.exists() && file.isDirectory();
    }
}

