/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.hardwareinfo.task.excel.entity;

import com.alibaba.fastjson.JSON;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.base.IpAddress;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.base.Summary;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.board.raid.RaidBoardInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.version.BmcVersion;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.version.SpInfo;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.chassis.version.Version;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.System;
import com.huawei.ism.tool.infocollect.fit.hardwareinfo.redfish.system.SystemChassisInfo;
import com.huawei.ism.tool.infocollect.util.excel.ExcelData;
import com.huawei.ism.tool.infocollect.util.excel.ExcelField;
import java.util.List;
import java.util.Optional;

public class Chassis
implements ExcelData {
    @ExcelField(header="Node Management IP")
    private String nodeManagementIP;
    private String productName;
    private String productAlias;
    private String hostName;
    private String assetTag;
    private String productUniqueID;
    private String iPv6Addresses;
    private String activeiBmcVersion;
    private String backUpiBmcVersion;
    private String biosVersion;
    private String cpldVersion;
    @ExcelField(header="SP-APPVersion")
    private String spAppVersion;
    private Integer cPUNum;
    private Integer maxCPUNum;
    private Integer memoryNum;
    private Integer maxMemoryNum;
    private Integer diskNum;
    private Integer maxDiskNum;
    private Integer pCIeNum;
    private Integer maxPCIeNum;
    private Integer fanNum;
    private Integer maxFanNum;
    private Integer powerSupplyNum;
    private Integer maxPowerSupplyNum;

    public void fillNum(System systemInfo, SystemChassisInfo chassisInfo, int pcieCount) {
        this.pCIeNum = pcieCount;
        if (systemInfo != null) {
            this.memoryNum = systemInfo.getMemoryCount();
            this.cPUNum = Optional.ofNullable(systemInfo.getProcessorSummary()).map(Summary::getCount).orElse(0);
        }
        if (chassisInfo != null) {
            this.diskNum = Optional.ofNullable(chassisInfo.getDriveSummary()).map(Summary::getCount).orElse(0);
            this.fanNum = Optional.ofNullable(chassisInfo.getFanSummary()).map(Summary::getCount).orElse(0);
            this.powerSupplyNum = Optional.ofNullable(chassisInfo.getPowerSupplySummary()).map(Summary::getCount).orElse(0);
        }
    }

    public void fillIp(List<IpAddress> ipV6Address) {
        this.iPv6Addresses = CollectionUtils.isEmpty(ipV6Address) ? "" : JSON.toJSONString(ipV6Address);
    }

    public void fillVersion(BmcVersion activeBmcVersion, BmcVersion backUpBmcVersion, RaidBoardInfo boardInfo, SpInfo spInfo) {
        this.activeiBmcVersion = Optional.ofNullable(activeBmcVersion).map(BmcVersion::getVersion).orElse("");
        this.backUpiBmcVersion = Optional.ofNullable(backUpBmcVersion).map(BmcVersion::getVersion).orElse("");
        this.cpldVersion = Optional.ofNullable(boardInfo).map(RaidBoardInfo::getCpldVersion).orElse("");
        this.spAppVersion = Optional.ofNullable(spInfo).map(SpInfo::getVersion).map(Version::getAppVersion).orElse("");
    }

    public String getNodeManagementIP() {
        return this.nodeManagementIP;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductAlias() {
        return this.productAlias;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getAssetTag() {
        return this.assetTag;
    }

    public String getProductUniqueID() {
        return this.productUniqueID;
    }

    public String getIPv6Addresses() {
        return this.iPv6Addresses;
    }

    public String getActiveiBmcVersion() {
        return this.activeiBmcVersion;
    }

    public String getBackUpiBmcVersion() {
        return this.backUpiBmcVersion;
    }

    public String getBiosVersion() {
        return this.biosVersion;
    }

    public String getCpldVersion() {
        return this.cpldVersion;
    }

    public String getSpAppVersion() {
        return this.spAppVersion;
    }

    public Integer getCPUNum() {
        return this.cPUNum;
    }

    public Integer getMaxCPUNum() {
        return this.maxCPUNum;
    }

    public Integer getMemoryNum() {
        return this.memoryNum;
    }

    public Integer getMaxMemoryNum() {
        return this.maxMemoryNum;
    }

    public Integer getDiskNum() {
        return this.diskNum;
    }

    public Integer getMaxDiskNum() {
        return this.maxDiskNum;
    }

    public Integer getPCIeNum() {
        return this.pCIeNum;
    }

    public Integer getMaxPCIeNum() {
        return this.maxPCIeNum;
    }

    public Integer getFanNum() {
        return this.fanNum;
    }

    public Integer getMaxFanNum() {
        return this.maxFanNum;
    }

    public Integer getPowerSupplyNum() {
        return this.powerSupplyNum;
    }

    public Integer getMaxPowerSupplyNum() {
        return this.maxPowerSupplyNum;
    }

    public void setNodeManagementIP(String nodeManagementIP) {
        this.nodeManagementIP = nodeManagementIP;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductAlias(String productAlias) {
        this.productAlias = productAlias;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setAssetTag(String assetTag) {
        this.assetTag = assetTag;
    }

    public void setProductUniqueID(String productUniqueID) {
        this.productUniqueID = productUniqueID;
    }

    public void setIPv6Addresses(String iPv6Addresses) {
        this.iPv6Addresses = iPv6Addresses;
    }

    public void setActiveiBmcVersion(String activeiBmcVersion) {
        this.activeiBmcVersion = activeiBmcVersion;
    }

    public void setBackUpiBmcVersion(String backUpiBmcVersion) {
        this.backUpiBmcVersion = backUpiBmcVersion;
    }

    public void setBiosVersion(String biosVersion) {
        this.biosVersion = biosVersion;
    }

    public void setCpldVersion(String cpldVersion) {
        this.cpldVersion = cpldVersion;
    }

    public void setSpAppVersion(String spAppVersion) {
        this.spAppVersion = spAppVersion;
    }

    public void setCPUNum(Integer cPUNum) {
        this.cPUNum = cPUNum;
    }

    public void setMaxCPUNum(Integer maxCPUNum) {
        this.maxCPUNum = maxCPUNum;
    }

    public void setMemoryNum(Integer memoryNum) {
        this.memoryNum = memoryNum;
    }

    public void setMaxMemoryNum(Integer maxMemoryNum) {
        this.maxMemoryNum = maxMemoryNum;
    }

    public void setDiskNum(Integer diskNum) {
        this.diskNum = diskNum;
    }

    public void setMaxDiskNum(Integer maxDiskNum) {
        this.maxDiskNum = maxDiskNum;
    }

    public void setPCIeNum(Integer pCIeNum) {
        this.pCIeNum = pCIeNum;
    }

    public void setMaxPCIeNum(Integer maxPCIeNum) {
        this.maxPCIeNum = maxPCIeNum;
    }

    public void setFanNum(Integer fanNum) {
        this.fanNum = fanNum;
    }

    public void setMaxFanNum(Integer maxFanNum) {
        this.maxFanNum = maxFanNum;
    }

    public void setPowerSupplyNum(Integer powerSupplyNum) {
        this.powerSupplyNum = powerSupplyNum;
    }

    public void setMaxPowerSupplyNum(Integer maxPowerSupplyNum) {
        this.maxPowerSupplyNum = maxPowerSupplyNum;
    }
}

