/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.infocollect.entity.TaskParams;
import com.huawei.ism.tool.infocollect.fit.task.DevNodeManager;
import com.huawei.ism.tool.infocollect.fit.task.ExecuteTaskManager;
import com.huawei.ism.tool.infocollect.service.backgroud.ExecuteTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.Collect;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectParam;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.MultiCollectParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

@FitableSuite
public class CollectImpl {
    private static final Logger log = LoggerFactory.getLogger(CollectImpl.class);
    private static final int MIN_REMAIN_SPACE = 0x6400000;
    @Fit
    ExecuteTaskManager taskManager;
    @Fit
    DevNodeManager devNodeManager;

    @Fitable(generic=Collect.class, id="ae660a5871454183abf4d27c115968cd")
    public Response<String> collect(String taskId, MultiCollectParam multiCollectParam) {
        try {
            this.checkParamValid(taskId, multiCollectParam);
            this.submitCollectTask(taskId, multiCollectParam);
            return ResponseUtil.success((Object)"");
        }
        catch (ToolException e) {
            return ResponseUtil.failed((String)e.getErrorLocaleDescription(), (String)"");
        }
    }

    private void checkParamValid(String taskId, MultiCollectParam multiCollectParam) throws ToolException {
        if (this.taskManager.existsSameRunningTask(taskId)) {
            log.error("exists same running task: {}", (Object)taskId);
            throw new ToolException("lld.collect.same.task.running", (Object[])new String[]{taskId});
        }
        if (!this.isDevParamsValid(multiCollectParam)) {
            log.error("dev param in valid, param: {}", (Object)multiCollectParam.getParams());
            throw new ToolException("lld.collect.task.dev.param.error");
        }
        if (!FilesUtil.checkNormalPath((String)multiCollectParam.getResultDir())) {
            log.error("result path illegal");
            throw new ToolException("infocollect.remind.dirchangefail.character");
        }
        if (!FileUtils.isDiskFull((String)multiCollectParam.getResultDir(), (long)0x6400000L)) {
            log.error("free space not enough, min remain space: {}", (Object)0x6400000);
            throw new ToolException("inspsctor.wizard.performinspect.diskfull.failedfile");
        }
    }

    private boolean isDevParamsValid(MultiCollectParam multiCollectParam) {
        return !CollectionUtil.isEmpty((Collection)multiCollectParam.getParams()) && this.devNodeManager.containsAllNodes(multiCollectParam.getParams().stream().map(CollectParam::getDevId).collect(Collectors.toList()));
    }

    private void submitCollectTask(String taskId, MultiCollectParam multiCollectParam) throws ToolException {
        List<ExecuteTask> executeTaskList = multiCollectParam.getParams().stream().map(collectParam -> this.genTaskByParam((CollectParam)collectParam, multiCollectParam.getResultDir())).collect(Collectors.toList());
        this.taskManager.submitTask(taskId, executeTaskList);
    }

    private ExecuteTask genTaskByParam(CollectParam param, String resultDir) {
        TaskParams taskParams = new TaskParams();
        taskParams.setDevNode(this.devNodeManager.getNode(param.getDevId()));
        taskParams.setDevNodes(String.join((CharSequence)",", param.getClusterNodeIds()));
        taskParams.setWorkPath(resultDir);
        taskParams.setStartTime(param.getStartTime());
        taskParams.setEndTime(param.getEndTime());
        taskParams.setItemIds(param.getItemIds());
        return new ExecuteTask(taskParams);
    }
}

