/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infocollect.fit.service.CollectImpl;
import com.huawei.ism.tool.infocollect.fit.task.DevNodeManager;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.auth.entity.LoginUser;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryMultiCluster;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.CollectLldInfo;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectLldDevParam;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectParam;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.MultiCollectParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class CollectLldInfoImpl {
    private static final Logger log = LoggerFactory.getLogger(CollectLldInfoImpl.class);
    @Fit(alias="queryMultiCluster\u7684\u5b9e\u73b0")
    QueryMultiCluster queryMultiCluster;
    ResourceBundle sysBundle = ResourceBundle.getBundle("config.infocollect");
    List<String> lldItems = Arrays.asList(this.sysBundle.getString("lld_collect_items").split(","));
    @Fit
    DevNodeManager nodeManager;
    @Fit
    CollectImpl collectImpl;

    @Fitable(generic=CollectLldInfo.class, id="5afa10c99a2b4582b3413cde59599099")
    public Response<String> collectLldInfo(CollectLldDevParam collectLldDevParam) {
        try {
            this.loadCacheClusters();
            this.checkDevParam(collectLldDevParam.getDevIds());
            return this.collectImpl.collect(collectLldDevParam.getTaskId(), this.genMultiCollectParam(collectLldDevParam));
        }
        catch (ToolException exception) {
            return ResponseUtil.failed((String)exception.getErrorLocaleDescription(), (String)"");
        }
    }

    private void loadCacheClusters() {
        this.queryMultiCluster.process().getCluster().forEach(cluster -> {
            DevNode dev = new DevNode();
            dev.setDevKey(cluster.getUid());
            dev.setDeviceName(cluster.getClusterName());
            dev.setIp(cluster.getIp());
            dev.setDeviceSerialNumber(cluster.getSn());
            dev.setLoginUser(this.buildUser(cluster.getLoginUser()));
            dev.setProductModel(cluster.getClusterModel());
            dev.setProductVersion(cluster.getClusterVersion());
            dev.setHotPatchVersion(cluster.getClusterPatchVersion());
            dev.setItDeviceType(ItDeviceType.of((String)cluster.getItDeviceType()));
            if (Objects.nonNull(cluster.getFusionCubeLoginUser())) {
                dev.setFusionCubeLoginUser(this.buildUser(cluster.getFusionCubeLoginUser()));
            }
            if (Objects.nonNull(cluster.getRootUser())) {
                dev.setRootUser(this.buildUser(cluster.getRootUser()));
            }
            this.nodeManager.addNode(dev);
        });
    }

    private User buildUser(LoginUser loginUser) {
        User user = new User();
        user.setUserName(loginUser.getName());
        user.setEcptPassword(loginUser.getPwd());
        if (Objects.nonNull(loginUser.getPort())) {
            user.setPort(loginUser.getPort().intValue());
        }
        return user;
    }

    private void checkDevParam(List<String> devIds) throws ToolException {
        if (CollectionUtil.isEmpty(devIds) || !this.nodeManager.containsAllNodes(devIds)) {
            log.error("param error, devIds: {}", devIds);
            throw new ToolException("lld.collect.task.dev.param.error");
        }
    }

    private MultiCollectParam genMultiCollectParam(CollectLldDevParam collectLldDevParam) {
        List collectParams = collectLldDevParam.getDevIds().stream().map(this::genCollectParam).collect(Collectors.toList());
        return MultiCollectParam.builder().resultDir(collectLldDevParam.getResultDir()).params(collectParams).build();
    }

    private CollectParam genCollectParam(String devId) {
        return CollectParam.builder().devId(devId).clusterNodeIds(this.getClusterNodeIds(devId)).itemIds(this.lldItems).build();
    }

    private List<String> getClusterNodeIds(String devId) {
        DevNode devNode = this.nodeManager.getNode(devId);
        if (CollectionUtil.isEmpty((Collection)devNode.getClusterNodes())) {
            return Collections.emptyList();
        }
        return devNode.getClusterNodes().stream().filter(ClusterNode::includedStorageService).map(ClusterNode::getId).map(String::valueOf).collect(Collectors.toList());
    }
}

