/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.fit.task.DevNodeManager;
import com.huawei.ism.tool.infocollect.fit.task.ExecuteTaskManager;
import com.huawei.ism.tool.infocollect.fit.task.entity.TaskStatus;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryCollectDetail;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectDevDetailDTO;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectItemDetailDTO;
import java.util.List;
import java.util.stream.Collectors;

@FitableSuite
public class QueryCollectDetailImpl {
    @Fit
    private DevNodeManager nodeManager;
    @Fit
    private ExecuteTaskManager taskManager;

    @Fitable(generic=QueryCollectDetail.class, id="17cd46793fff41c5a9eb108e3f5043ee")
    public Response<CollectDevDetailDTO> queryCollectDetail(String taskId, String devId) {
        try {
            this.checkParamValid(taskId, devId);
            return ResponseUtil.success((Object)this.queryDevDetails(taskId, devId));
        }
        catch (ToolException exception) {
            return ResponseUtil.failed((String)exception.getErrorLocaleDescription(), (String)"");
        }
    }

    private void checkParamValid(String taskId, String devId) throws ToolException {
        if (!this.taskManager.containsTask(taskId)) {
            throw new ToolException("lld.collect.task.not.exists", (Object[])new String[]{taskId});
        }
        if (!this.nodeManager.containsNode(devId)) {
            throw new ToolException("lld.collect.task.dev.param.error");
        }
    }

    private CollectDevDetailDTO queryDevDetails(String taskId, String devId) {
        List detailDTOS = this.taskManager.queryDevNodeResult(taskId, this.nodeManager.getNode(devId)).stream().map(this::genItemDetailDto).collect(Collectors.toList());
        return CollectDevDetailDTO.builder().collectItemDetailDTO(detailDTOS).build();
    }

    private CollectItemDetailDTO genItemDetailDto(ExecuteResult result) {
        return CollectItemDetailDTO.builder().name(result.getDescription()).detail(result.getDetail()).progress(Double.valueOf(result.getSingleProgress())).result(result.getResult()).startTime(result.getStartDateString()).status(this.calcTaskStatus(result).getName()).build();
    }

    private TaskStatus calcTaskStatus(ExecuteResult result) {
        if (result.isProcessing()) {
            return TaskStatus.RUNNING;
        }
        if (result.isSuccess()) {
            return TaskStatus.SUCCESS;
        }
        return TaskStatus.FAILED;
    }
}

