/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.infocollect.fit.task.ExecuteTaskManager;
import com.huawei.ism.tool.infocollect.fit.task.entity.TaskStatus;
import com.huawei.ism.tool.infocollect.service.backgroud.ExecuteTask;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryTaskOverView;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectDevOverViewDTO;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.MultiCollectDevOverViewDTO;
import java.util.List;
import java.util.stream.Collectors;

@FitableSuite
public class QueryTaskOverViewImpl {
    @Fit
    ExecuteTaskManager executeTaskManager;

    @Fitable(generic=QueryTaskOverView.class, id="f9f1e29bdf9f42d7ad6cb239595d8d99")
    public Response<MultiCollectDevOverViewDTO> queryTaskOverView(String taskId) {
        try {
            this.checkParamValid(taskId);
            return ResponseUtil.success((Object)this.queryTaskOverViewDTO(taskId));
        }
        catch (ToolException toolException) {
            return ResponseUtil.failed((String)toolException.getErrorLocaleDescription(), (String)"");
        }
    }

    private void checkParamValid(String taskId) throws ToolException {
        if (!this.executeTaskManager.containsTask(taskId)) {
            throw new ToolException("lld.collect.task.not.exists", (Object[])new String[]{taskId});
        }
    }

    private MultiCollectDevOverViewDTO queryTaskOverViewDTO(String taskId) {
        List<CollectDevOverViewDTO> devOverViewDTOS = this.genDevOverViewDTOs(taskId);
        TaskStatistics taskStatistics = this.genTaskStatistics(devOverViewDTOS);
        return MultiCollectDevOverViewDTO.builder().collectDevOverViewDTO(devOverViewDTOS).taskStatistics(taskStatistics).build();
    }

    private List<CollectDevOverViewDTO> genDevOverViewDTOs(String taskId) {
        return this.executeTaskManager.getExecuteTasks(taskId).stream().map(executeTask -> this.genDevOverView(taskId, (ExecuteTask)executeTask)).collect(Collectors.toList());
    }

    private CollectDevOverViewDTO genDevOverView(String taskId, ExecuteTask task) {
        DevNode devNode = task.getParams().getDevNode();
        return CollectDevOverViewDTO.builder().ip(devNode.getIp()).name(devNode.getDeviceName()).sn(devNode.getDeviceSerialNumber()).model(devNode.getProductModel()).version(devNode.getProductVersion()).status(this.executeTaskManager.queryDevNodeStatus(taskId, devNode).getName()).progress(Double.valueOf(this.executeTaskManager.queryDevNodeProgress(taskId, devNode))).build();
    }

    private TaskStatistics genTaskStatistics(List<CollectDevOverViewDTO> devOverViewDTOS) {
        return TaskStatistics.builder().successNum(Integer.valueOf(this.calcNumAssignStatus(TaskStatus.SUCCESS, devOverViewDTOS))).failedNum(Integer.valueOf(this.calcNumAssignStatus(TaskStatus.FAILED, devOverViewDTOS))).noExecutedNum(Integer.valueOf(this.calcNumAssignStatus(TaskStatus.WAITED, devOverViewDTOS))).runningNum(Integer.valueOf(this.calcNumAssignStatus(TaskStatus.RUNNING, devOverViewDTOS))).build();
    }

    private int calcNumAssignStatus(TaskStatus status, List<CollectDevOverViewDTO> devOverViewDTOS) {
        return (int)devOverViewDTOS.stream().filter(collectDevOverViewDTO -> collectDevOverViewDTO.getStatus().equals(status.getName())).count();
    }
}

