/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.infocollect.fit.task.ExecuteTaskManager;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateConcurrentNumber;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class UpdateCollectInfoConcurrentNumberImpl {
    private static final Logger log = LoggerFactory.getLogger(UpdateCollectInfoConcurrentNumberImpl.class);
    private static final int MIN_CONCURRENT_NUMBER = 20;
    private static final int MAX_CONCURRENT_NUMBER = 100;
    @Fit
    ResponseUtil responseUtil;

    @Fitable(generic=UpdateConcurrentNumber.class, id="ec8d23d354d0f82d09ad70dd14cb15f3")
    public Response<String> updateCollectInfoConcurrentNumber(Map<String, Integer> concurrentNumberMap) {
        if (MapUtils.isEmpty(concurrentNumberMap) || !concurrentNumberMap.containsKey("concurrentNumber")) {
            log.error("updateCollectInfoConcurrentNumber request error, the request don't have the concurrentNumber key");
            return ResponseUtil.failed((String)ResourceUtil.getString((String)"update.concurrent.number.request.error"), (String)"");
        }
        int currentNumber = concurrentNumberMap.get("concurrentNumber");
        if (currentNumber < 20 || currentNumber > 100) {
            log.error("The current number is {}, less than {} or greater than {}", new Object[]{currentNumber, 20, 100});
            return ResponseUtil.failed((String)ResourceUtil.getString((String)"update.concurrent.number.restriction.error"), (String)ResourceUtil.getStringWithParams((String)"update.concurrent.number.restriction.suggest", (Object[])new Object[]{20, 100}));
        }
        ThreadPoolExecutor executor = ExecuteTaskManager.DEV_EXECUTOR;
        executor.setCorePoolSize(currentNumber);
        log.info("Set the concurrent number {} successfully.", (Object)currentNumber);
        return ResponseUtil.success((Object)ResourceUtil.getString((String)"update.concurrent.number.success"));
    }

    public void setResponseUtil(ResponseUtil responseUtil) {
        this.responseUtil = responseUtil;
    }
}

