/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.task;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DevNodeManager {
    private static final Logger log = LoggerFactory.getLogger(DevNodeManager.class);
    INodeTypeQuery queryImpl = new DSstorageInfoQryServiceImpl();
    private Map<String, DevNode> devNodeMap = new HashMap<String, DevNode>();

    public void loadDeviceFromToolBox() {
        List<DevNode> nodes = DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(DevNode::isDsStorage).collect(Collectors.toList());
        nodes.forEach(this::setDevProductModel);
        this.initNodes(nodes);
    }

    public void addNode(DevNode devNode) {
        this.devNodeMap.put(devNode.getDeviceSerialNumber(), devNode);
    }

    public DevNode getNode(String serialNumber) {
        return this.devNodeMap.get(serialNumber);
    }

    public boolean containsNode(String serialNumber) {
        return this.devNodeMap.containsKey(serialNumber);
    }

    public boolean containsAllNodes(List<String> devIds) {
        return devIds.stream().allMatch(this::containsNode);
    }

    public List<DevNode> queryAllDevNodes() {
        return new ArrayList<DevNode>(this.devNodeMap.values());
    }

    public void queryNodeInfo(String devId) throws ToolException {
        TaskResult result = this.queryImpl.queryNodeInfo(this.getNode(devId), DeviceOpr.ADD);
        if (result.getResult() == TaskResult.Result.FAILED) {
            log.error("query device node info failed : {}", (Object)devId);
            throw new ToolException("lld.collect.task.dev.query.node.error");
        }
    }

    private void initNodes(List<DevNode> devNodeList) {
        this.devNodeMap.clear();
        devNodeList.forEach(this::addNode);
    }

    private void setDevProductModel(DevNode devNode) {
        if (Strings.isEmpty((CharSequence)devNode.getProductModel()) && devNode.getDeviceType() != null) {
            devNode.setProductModel(devNode.getDeviceType().toString());
        }
    }
}

