/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.task;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.fit.task.entity.MultiDevExecuteTask;
import com.huawei.ism.tool.infocollect.fit.task.entity.TaskStatus;
import com.huawei.ism.tool.infocollect.service.backgroud.ExecuteTask;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class ExecuteTaskManager {
    private static final Logger log = LoggerFactory.getLogger(ExecuteTaskManager.class);
    public static final Thread.UncaughtExceptionHandler EXCEPTION_HANDLER = (thread, throwable) -> log.error("uncaught executor exception.", throwable);
    public static final ThreadPoolExecutor DEV_EXECUTOR = new ThreadPoolExecutor(20, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setUncaughtExceptionHandler(EXCEPTION_HANDLER).setNameFormat("ExecuteTaskManager-%d").build());
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Map<String, MultiDevExecuteTask> taskMap = new HashMap<String, MultiDevExecuteTask>();

    public List<ExecuteTask> getExecuteTasks(String taskId) {
        if (!this.taskMap.containsKey(taskId)) {
            return Collections.emptyList();
        }
        return this.taskMap.get(taskId).getExecuteTaskList();
    }

    public void submitTask(String taskId, List<ExecuteTask> tasks) {
        log.info("submit task: {}", (Object)taskId);
        MultiDevExecuteTask task = new MultiDevExecuteTask(taskId, tasks);
        this.taskMap.put(taskId, task);
        this.executor.submit(task);
    }

    public boolean existsSameRunningTask(String taskId) {
        return this.taskMap.containsKey(taskId) && !this.taskMap.get(taskId).isFinished();
    }

    public boolean containsTask(String taskId) {
        return this.taskMap.containsKey(taskId);
    }

    public List<ExecuteResult> queryDevNodeResult(String taskId, DevNode devNode) {
        return this.taskMap.get(taskId).queryResults(devNode);
    }

    public TaskStatus queryDevNodeStatus(String taskId, DevNode devNode) {
        return this.taskMap.get(taskId).queryStatus(devNode);
    }

    public int queryDevNodeProgress(String taskId, DevNode devNode) {
        return this.taskMap.get(taskId).queryProgress(devNode);
    }
}

