/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.fit.task.entity;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.fit.task.ExecuteTaskManager;
import com.huawei.ism.tool.infocollect.fit.task.entity.TaskStatus;
import com.huawei.ism.tool.infocollect.service.backgroud.ExecuteTask;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDevExecuteTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MultiDevExecuteTask.class);
    private final String taskId;
    private final Map<DevNode, ICollectInfo> collectInfoMap = new HashMap<DevNode, ICollectInfo>();
    private List<ExecuteTask> executeTaskList;
    private boolean isFinished = false;

    public MultiDevExecuteTask(String taskId, List<ExecuteTask> executeTaskList) {
        this.taskId = taskId;
        this.executeTaskList = executeTaskList;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("MultiDevExecuteTask_" + this.taskId);
        CompletableFuture.allOf(this.initFutureList()).join();
        log.info("multiDevExecuteTask {} finished, clear env", (Object)this.taskId);
        this.saveCollectInfos();
        this.clearContextInfos();
        this.isFinished = true;
    }

    public List<ExecuteResult> queryResults(DevNode devNode) {
        ICollectInfo collectInfo = this.getCollectInfo(devNode);
        return collectInfo == null ? Collections.emptyList() : collectInfo.getExecuteResults();
    }

    public TaskStatus queryStatus(DevNode devNode) {
        ICollectInfo collectInfo = this.getCollectInfo(devNode);
        return collectInfo == null ? TaskStatus.WAITED : this.trans2TaskStatus(collectInfo.getCollectStatus());
    }

    private CompletableFuture[] initFutureList() {
        return (CompletableFuture[])this.executeTaskList.stream().map(executeTask -> CompletableFuture.runAsync(executeTask, ExecuteTaskManager.DEV_EXECUTOR)).toArray(CompletableFuture[]::new);
    }

    private void saveCollectInfos() {
        this.executeTaskList.stream().map(executeTask -> executeTask.getParams().getDevNode()).forEach(devNode -> this.collectInfoMap.put((DevNode)devNode, CollectDataContext.getInstance().getCollectInfo((DevNode)devNode)));
    }

    private void clearContextInfos() {
        CollectDataContext.getInstance().clear();
    }

    public int queryProgress(DevNode devNode) {
        ICollectInfo collectInfo = this.getCollectInfo(devNode);
        return collectInfo == null ? 0 : collectInfo.getCurrentProgress();
    }

    private ICollectInfo getCollectInfo(DevNode devNode) {
        return this.isFinished ? this.collectInfoMap.get(devNode) : CollectDataContext.getInstance().getCollectInfo(devNode);
    }

    private TaskStatus trans2TaskStatus(CollectStatus status) {
        switch (status) {
            case COLLECTING: {
                return TaskStatus.RUNNING;
            }
            case COLLECT_FINISHED: {
                return TaskStatus.SUCCESS;
            }
            case COLLECT_FAILED: {
                return TaskStatus.FAILED;
            }
            case COLLECT_FINISHED_NOTALL: {
                return TaskStatus.PART_SUCCESS;
            }
        }
        return TaskStatus.WAITED;
    }

    public void setExecuteTaskList(List<ExecuteTask> executeTaskList) {
        this.executeTaskList = executeTaskList;
    }

    public List<ExecuteTask> getExecuteTaskList() {
        return this.executeTaskList;
    }

    public boolean isFinished() {
        return this.isFinished;
    }
}

